/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.Iteration;
import org.eclipse.rdf4j.common.iteration.LookAheadIteration;
import org.eclipse.rdf4j.common.iteration.UnionIteration;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.sail.SailConnection;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.helpers.SailConnectionWrapper;
import org.eclipse.rdf4j.sail.shacl.RdfsSubClassOfReasoner;

class VerySimpleRdfsBackwardsChainingConnection
extends SailConnectionWrapper {
    private final RdfsSubClassOfReasoner rdfsSubClassOfReasoner;

    VerySimpleRdfsBackwardsChainingConnection(SailConnection wrappedCon, RdfsSubClassOfReasoner rdfsSubClassOfReasoner) {
        super(wrappedCon);
        this.rdfsSubClassOfReasoner = rdfsSubClassOfReasoner;
    }

    public boolean hasStatement(Resource subj, IRI pred, Value obj, boolean includeInferred, Resource ... contexts) throws SailException {
        boolean hasStatement = super.hasStatement(subj, pred, obj, includeInferred, contexts);
        if (this.rdfsSubClassOfReasoner != null && includeInferred && obj instanceof Resource && RDF.TYPE.equals((Object)pred)) {
            return hasStatement | this.rdfsSubClassOfReasoner.backwardsChain((Resource)obj).stream().map(type -> super.hasStatement(subj, pred, (Value)type, false, contexts)).reduce((a, b) -> a != false || b != false).orElse(false);
        }
        return hasStatement;
    }

    public CloseableIteration<? extends Statement, SailException> getStatements(Resource subj, IRI pred, final Value obj, boolean includeInferred, Resource ... contexts) throws SailException {
        Set<Resource> inferredTypes;
        if (this.rdfsSubClassOfReasoner != null && includeInferred && obj instanceof Resource && RDF.TYPE.equals((Object)pred) && !(inferredTypes = this.rdfsSubClassOfReasoner.backwardsChain((Resource)obj)).isEmpty()) {
            final CloseableIteration[] statementsMatchingInferredTypes = (CloseableIteration[])inferredTypes.stream().map(r -> super.getStatements(subj, pred, (Value)r, false, contexts)).toArray(CloseableIteration[]::new);
            return new LookAheadIteration<Statement, SailException>(){
                UnionIteration<Statement, SailException> unionIteration;
                HashSet<Statement> dedupe;
                {
                    this.unionIteration = new UnionIteration((Iteration[])statementsMatchingInferredTypes);
                    this.dedupe = new HashSet();
                }

                protected Statement getNextElement() throws SailException {
                    Statement next = null;
                    while (next == null && this.unionIteration.hasNext()) {
                        Statement temp = (Statement)this.unionIteration.next();
                        temp = SimpleValueFactory.getInstance().createStatement(temp.getSubject(), temp.getPredicate(), obj, temp.getContext());
                        if (!this.dedupe.isEmpty()) {
                            boolean contains = this.dedupe.contains(temp);
                            if (contains) continue;
                            next = temp;
                            this.dedupe.add(next);
                            continue;
                        }
                        next = temp;
                        this.dedupe.add(next);
                    }
                    return next;
                }

                public void remove() throws SailException {
                    throw new IllegalStateException("Not implemented");
                }

                protected void handleClose() throws SailException {
                    try {
                        this.unionIteration.close();
                    }
                    finally {
                        super.handleClose();
                    }
                }
            };
        }
        return super.getStatements(subj, pred, obj, includeInferred, contexts);
    }
}

