/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.planNodes;

import org.apache.commons.text.StringEscapeUtils;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.shacl.planNodes.IteratorData;
import org.eclipse.rdf4j.sail.shacl.planNodes.LoggingCloseableIteration;
import org.eclipse.rdf4j.sail.shacl.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.Tuple;
import org.eclipse.rdf4j.sail.shacl.planNodes.ValidationExecutionLogger;

public class TrimTuple
implements PlanNode {
    PlanNode parent;
    private int newLength;
    private int startIndex;
    private boolean printed = false;
    private ValidationExecutionLogger validationExecutionLogger;

    public TrimTuple(PlanNode parent, int startIndex, int newLength) {
        this.parent = parent;
        this.newLength = newLength;
        this.startIndex = startIndex;
    }

    @Override
    public CloseableIteration<Tuple, SailException> iterator() {
        return new LoggingCloseableIteration(this, this.validationExecutionLogger){
            CloseableIteration<Tuple, SailException> parentIterator;
            {
                this.parentIterator = TrimTuple.this.parent.iterator();
            }

            public void close() throws SailException {
                this.parentIterator.close();
            }

            @Override
            boolean localHasNext() throws SailException {
                return this.parentIterator.hasNext();
            }

            @Override
            Tuple loggingNext() throws SailException {
                Tuple next = (Tuple)this.parentIterator.next();
                Tuple tuple = new Tuple();
                int tempLength = TrimTuple.this.newLength >= 0 ? TrimTuple.this.newLength : next.line.size();
                for (int i = TrimTuple.this.startIndex; i < tempLength && i < next.line.size(); ++i) {
                    tuple.line.add(next.line.get(i));
                }
                tuple.addHistory(next);
                tuple.addAllCausedByPropertyShape(next.getCausedByPropertyShapes());
                return tuple;
            }

            public void remove() throws SailException {
            }
        };
    }

    @Override
    public int depth() {
        return this.parent.depth() + 1;
    }

    @Override
    public void getPlanAsGraphvizDot(StringBuilder stringBuilder) {
        if (this.printed) {
            return;
        }
        this.printed = true;
        stringBuilder.append(this.getId() + " [label=\"" + StringEscapeUtils.escapeJava((String)this.toString()) + "\"];").append("\n");
        stringBuilder.append(this.parent.getId() + " -> " + this.getId()).append("\n");
        this.parent.getPlanAsGraphvizDot(stringBuilder);
    }

    public String toString() {
        return "TrimTuple{newLength=" + this.newLength + ", startIndex=" + this.startIndex + '}';
    }

    @Override
    public String getId() {
        return System.identityHashCode(this) + "";
    }

    @Override
    public IteratorData getIteratorDataType() {
        if (this.newLength == 1) {
            return IteratorData.tripleBased;
        }
        return this.parent.getIteratorDataType();
    }

    @Override
    public void receiveLogger(ValidationExecutionLogger validationExecutionLogger) {
        this.validationExecutionLogger = validationExecutionLogger;
        this.parent.receiveLogger(validationExecutionLogger);
    }
}

