/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.planNodes;

import java.util.Arrays;
import java.util.Set;
import org.apache.commons.text.StringEscapeUtils;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.sail.SailConnection;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.memory.MemoryStoreConnection;
import org.eclipse.rdf4j.sail.shacl.planNodes.Formatter;
import org.eclipse.rdf4j.sail.shacl.planNodes.IteratorData;
import org.eclipse.rdf4j.sail.shacl.planNodes.LoggingCloseableIteration;
import org.eclipse.rdf4j.sail.shacl.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.Tuple;
import org.eclipse.rdf4j.sail.shacl.planNodes.ValidationExecutionLogger;

public class ExternalFilterByPredicate
implements PlanNode {
    private final SailConnection connection;
    private final Set<IRI> filterOnPredicates;
    final PlanNode parent;
    final int index;
    private final On on;
    private boolean printed = false;
    private ValidationExecutionLogger validationExecutionLogger;

    public ExternalFilterByPredicate(SailConnection connection, Set<IRI> filterOnPredicates, PlanNode parent, int index, On on) {
        this.connection = connection;
        this.filterOnPredicates = filterOnPredicates;
        this.parent = parent;
        this.index = index;
        this.on = on;
    }

    @Override
    public CloseableIteration<Tuple, SailException> iterator() {
        return new LoggingCloseableIteration(this, this.validationExecutionLogger){
            Tuple next;
            CloseableIteration<Tuple, SailException> parentIterator;
            {
                this.next = null;
                this.parentIterator = ExternalFilterByPredicate.this.parent.iterator();
            }

            void calculateNext() {
                while (this.next == null && this.parentIterator.hasNext()) {
                    Tuple temp = (Tuple)this.parentIterator.next();
                    Value subject = temp.line.get(ExternalFilterByPredicate.this.index);
                    IRI matchedPredicate = this.matchesFilter(subject);
                    if (matchedPredicate == null) continue;
                    this.next = temp;
                    this.next.addHistory(new Tuple(Arrays.asList(subject, matchedPredicate)));
                }
            }

            private IRI matchesFilter(Value node) {
                if (node instanceof Resource && ExternalFilterByPredicate.this.on == On.Subject) {
                    return ExternalFilterByPredicate.this.filterOnPredicates.stream().filter(predicate -> ExternalFilterByPredicate.this.connection.hasStatement((Resource)node, predicate, null, true, new Resource[0])).findFirst().orElse(null);
                }
                if (ExternalFilterByPredicate.this.on == On.Object) {
                    return ExternalFilterByPredicate.this.filterOnPredicates.stream().filter(predicate -> ExternalFilterByPredicate.this.connection.hasStatement(null, predicate, node, true, new Resource[0])).findFirst().orElse(null);
                }
                return null;
            }

            public void close() throws SailException {
                this.parentIterator.close();
            }

            @Override
            boolean localHasNext() throws SailException {
                this.calculateNext();
                return this.next != null;
            }

            @Override
            Tuple loggingNext() throws SailException {
                this.calculateNext();
                Tuple temp = this.next;
                this.next = null;
                return temp;
            }

            public void remove() throws SailException {
            }
        };
    }

    @Override
    public int depth() {
        return this.parent.depth() + 1;
    }

    @Override
    public void getPlanAsGraphvizDot(StringBuilder stringBuilder) {
        if (this.printed) {
            return;
        }
        this.printed = true;
        stringBuilder.append(this.getId() + " [label=\"" + StringEscapeUtils.escapeJava((String)this.toString()) + "\"];").append("\n");
        stringBuilder.append(this.parent.getId() + " -> " + this.getId()).append("\n");
        if (this.connection instanceof MemoryStoreConnection) {
            stringBuilder.append(System.identityHashCode(((MemoryStoreConnection)this.connection).getSail()) + " -> " + this.getId() + " [label=\"filter source\"]").append("\n");
        } else {
            stringBuilder.append(System.identityHashCode(this.connection) + " -> " + this.getId() + " [label=\"filter source\"]").append("\n");
        }
        this.parent.getPlanAsGraphvizDot(stringBuilder);
    }

    public String toString() {
        return "ExternalFilterByPredicate{filterOnPredicates=" + Arrays.toString(this.filterOnPredicates.stream().map(Formatter::prefix).toArray()) + '}';
    }

    @Override
    public String getId() {
        return System.identityHashCode(this) + "";
    }

    @Override
    public IteratorData getIteratorDataType() {
        return this.parent.getIteratorDataType();
    }

    @Override
    public void receiveLogger(ValidationExecutionLogger validationExecutionLogger) {
        this.validationExecutionLogger = validationExecutionLogger;
        this.parent.receiveLogger(validationExecutionLogger);
    }

    public static enum On {
        Subject,
        Object;

    }
}

