/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.planNodes;

import java.util.ArrayDeque;
import org.apache.commons.text.StringEscapeUtils;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.parser.ParsedQuery;
import org.eclipse.rdf4j.query.parser.QueryParserUtil;
import org.eclipse.rdf4j.sail.SailConnection;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.memory.MemoryStoreConnection;
import org.eclipse.rdf4j.sail.shacl.planNodes.AbstractBulkJoinPlanNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.IteratorData;
import org.eclipse.rdf4j.sail.shacl.planNodes.LoggingCloseableIteration;
import org.eclipse.rdf4j.sail.shacl.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.Tuple;
import org.eclipse.rdf4j.sail.shacl.planNodes.TupleHelper;
import org.eclipse.rdf4j.sail.shacl.planNodes.ValidationExecutionLogger;

public class BulkedExternalInnerJoin
extends AbstractBulkJoinPlanNode {
    private final SailConnection connection;
    private final PlanNode leftNode;
    private final ParsedQuery parsedQuery;
    private final boolean skipBasedOnPreviousConnection;
    private final SailConnection previousStateConnection;
    private boolean printed = false;

    public BulkedExternalInnerJoin(PlanNode leftNode, SailConnection connection, String query, boolean skipBasedOnPreviousConnection, SailConnection previousStateConnection, String ... variables) {
        this.leftNode = leftNode;
        String completeQuery = "select * where { VALUES (?a) {}" + query + "} order by ?a";
        this.parsedQuery = QueryParserUtil.parseTupleQuery((QueryLanguage)QueryLanguage.SPARQL, (String)completeQuery, null);
        this.connection = connection;
        this.skipBasedOnPreviousConnection = skipBasedOnPreviousConnection;
        this.variables = variables;
        this.previousStateConnection = previousStateConnection;
    }

    @Override
    public CloseableIteration<Tuple, SailException> iterator() {
        return new LoggingCloseableIteration(this, this.validationExecutionLogger){
            ArrayDeque<Tuple> left;
            ArrayDeque<Tuple> right;
            ArrayDeque<Tuple> joined;
            CloseableIteration<Tuple, SailException> leftNodeIterator;
            {
                this.left = new ArrayDeque();
                this.right = new ArrayDeque();
                this.joined = new ArrayDeque();
                this.leftNodeIterator = BulkedExternalInnerJoin.this.leftNode.iterator();
            }

            private void calculateNext() {
                if (!this.joined.isEmpty()) {
                    return;
                }
                while (this.joined.isEmpty() && this.leftNodeIterator.hasNext()) {
                    while (this.left.size() < 200 && this.leftNodeIterator.hasNext()) {
                        this.left.addFirst((Tuple)this.leftNodeIterator.next());
                    }
                    BulkedExternalInnerJoin.this.runQuery(this.left, this.right, BulkedExternalInnerJoin.this.connection, BulkedExternalInnerJoin.this.parsedQuery, BulkedExternalInnerJoin.this.skipBasedOnPreviousConnection, BulkedExternalInnerJoin.this.previousStateConnection, BulkedExternalInnerJoin.this.variables);
                    while (!this.right.isEmpty()) {
                        Tuple leftPeek = this.left.peekLast();
                        Tuple rightPeek = this.right.peekLast();
                        if (rightPeek.line.get(0) == leftPeek.line.get(0) || rightPeek.line.get(0).equals(leftPeek.line.get(0))) {
                            this.joined.addLast(TupleHelper.join(leftPeek, rightPeek));
                            this.right.removeLast();
                            Tuple rightPeek2 = this.right.peekLast();
                            if (rightPeek2 != null && rightPeek2.line.get(0).equals(leftPeek.line.get(0))) continue;
                            this.left.removeLast();
                            continue;
                        }
                        int compare = rightPeek.line.get(0).stringValue().compareTo(leftPeek.line.get(0).stringValue());
                        if (compare < 0) {
                            if (this.right.isEmpty()) {
                                throw new IllegalStateException();
                            }
                            this.right.removeLast();
                            continue;
                        }
                        if (this.left.isEmpty()) {
                            throw new IllegalStateException();
                        }
                        this.left.removeLast();
                    }
                    this.left.clear();
                }
            }

            public void close() throws SailException {
                this.leftNodeIterator.close();
            }

            @Override
            boolean localHasNext() throws SailException {
                this.calculateNext();
                return !this.joined.isEmpty();
            }

            @Override
            Tuple loggingNext() throws SailException {
                this.calculateNext();
                return this.joined.removeFirst();
            }

            public void remove() throws SailException {
            }
        };
    }

    @Override
    public int depth() {
        return this.leftNode.depth() + 1;
    }

    @Override
    public void getPlanAsGraphvizDot(StringBuilder stringBuilder) {
        if (this.printed) {
            return;
        }
        this.printed = true;
        stringBuilder.append(this.getId() + " [label=\"" + StringEscapeUtils.escapeJava((String)this.toString()) + "\"];").append("\n");
        stringBuilder.append(this.leftNode.getId() + " -> " + this.getId() + " [label=\"left\"]").append("\n");
        if (this.connection instanceof MemoryStoreConnection) {
            stringBuilder.append(System.identityHashCode(((MemoryStoreConnection)this.connection).getSail()) + " -> " + this.getId() + " [label=\"right\"]").append("\n");
        } else {
            stringBuilder.append(System.identityHashCode(this.connection) + " -> " + this.getId() + " [label=\"right\"]").append("\n");
        }
        if (this.skipBasedOnPreviousConnection) {
            stringBuilder.append(System.identityHashCode(this.previousStateConnection) + " -> " + this.getId() + " [label=\"skip if not present\"]").append("\n");
        }
        this.leftNode.getPlanAsGraphvizDot(stringBuilder);
    }

    public String toString() {
        return "BulkedExternalInnerJoin{parsedQuery=" + this.parsedQuery.getSourceString().replace("\n", "  ") + '}';
    }

    @Override
    public String getId() {
        return System.identityHashCode(this) + "";
    }

    @Override
    public IteratorData getIteratorDataType() {
        return this.leftNode.getIteratorDataType();
    }

    @Override
    public void receiveLogger(ValidationExecutionLogger validationExecutionLogger) {
        this.validationExecutionLogger = validationExecutionLogger;
        this.leftNode.receiveLogger(validationExecutionLogger);
    }
}

