/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.planNodes;

import java.util.ArrayDeque;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.rdf4j.common.iteration.Iteration;
import org.eclipse.rdf4j.common.iteration.Iterations;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.algebra.BindingSetAssignment;
import org.eclipse.rdf4j.query.algebra.QueryModelVisitor;
import org.eclipse.rdf4j.query.algebra.helpers.AbstractQueryModelVisitor;
import org.eclipse.rdf4j.query.impl.ListBindingSet;
import org.eclipse.rdf4j.query.impl.MapBindingSet;
import org.eclipse.rdf4j.query.parser.ParsedQuery;
import org.eclipse.rdf4j.sail.SailConnection;
import org.eclipse.rdf4j.sail.shacl.ShaclSailConnection;
import org.eclipse.rdf4j.sail.shacl.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.Tuple;

abstract class AbstractBulkJoinPlanNode
implements PlanNode {
    protected String[] variables;

    AbstractBulkJoinPlanNode() {
    }

    static void runQuery(ArrayDeque<Tuple> left, ArrayDeque<Tuple> right, SailConnection connection, ParsedQuery parsedQuery, boolean skipBasedOnPreviousConnection, String[] variables) {
        List<BindingSet> newBindindingset = AbstractBulkJoinPlanNode.buildBindingSets(left, connection, skipBasedOnPreviousConnection);
        if (!newBindindingset.isEmpty()) {
            AbstractBulkJoinPlanNode.updateQuery(parsedQuery, newBindindingset);
            AbstractBulkJoinPlanNode.executeQuery(right, connection, parsedQuery, variables);
        }
    }

    private static void executeQuery(ArrayDeque<Tuple> right, SailConnection connection, ParsedQuery parsedQuery, String[] variables) {
        try (Stream stream = Iterations.stream((Iteration)connection.evaluate(parsedQuery.getTupleExpr(), parsedQuery.getDataset(), (BindingSet)new MapBindingSet(), true));){
            stream.map(t -> new Tuple((BindingSet)t, variables)).forEachOrdered(right::addFirst);
        }
    }

    private static void updateQuery(ParsedQuery parsedQuery, final List<BindingSet> newBindindingset) {
        try {
            parsedQuery.getTupleExpr().visitChildren((QueryModelVisitor)new AbstractQueryModelVisitor<Exception>(){

                public void meet(BindingSetAssignment node) {
                    node.setBindingSets((Iterable)newBindindingset);
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static List<BindingSet> buildBindingSets(ArrayDeque<Tuple> left, SailConnection connection, boolean skipBasedOnPreviousConnection) {
        return left.stream().map(tuple -> tuple.line.get(0)).map(v -> (Resource)v).filter(r -> {
            if (!skipBasedOnPreviousConnection) {
                return true;
            }
            if (connection instanceof ShaclSailConnection) {
                return ((ShaclSailConnection)connection).getPreviousStateConnection().hasStatement(r, null, null, true, new Resource[0]);
            }
            return true;
        }).map(r -> new ListBindingSet(Collections.singletonList("a"), Collections.singletonList(r))).collect(Collectors.toList());
    }
}

