/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.StampedLock;
import org.apache.commons.io.IOUtils;
import org.eclipse.rdf4j.IsolationLevel;
import org.eclipse.rdf4j.IsolationLevels;
import org.eclipse.rdf4j.common.iteration.Iteration;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.vocabulary.SHACL;
import org.eclipse.rdf4j.repository.RepositoryResult;
import org.eclipse.rdf4j.repository.sail.SailRepository;
import org.eclipse.rdf4j.repository.sail.SailRepositoryConnection;
import org.eclipse.rdf4j.sail.NotifyingSail;
import org.eclipse.rdf4j.sail.NotifyingSailConnection;
import org.eclipse.rdf4j.sail.Sail;
import org.eclipse.rdf4j.sail.SailConflictException;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.helpers.NotifyingSailWrapper;
import org.eclipse.rdf4j.sail.memory.MemoryStore;
import org.eclipse.rdf4j.sail.shacl.AST.NodeShape;
import org.eclipse.rdf4j.sail.shacl.GlobalValidationExecutionLogging;
import org.eclipse.rdf4j.sail.shacl.ShaclSailConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShaclSail
extends NotifyingSailWrapper {
    private static final Logger logger = LoggerFactory.getLogger(ShaclSail.class);
    private List<NodeShape> nodeShapes = Collections.emptyList();
    private static String IMPLICIT_TARGET_CLASS_NODE_SHAPE;
    private static String IMPLICIT_TARGET_CLASS_PROPERTY_SHAPE;
    private static String PROPERTY_SHAPE_WITH_TARGET;
    private SailRepository shapesRepo;
    private final StampedLock lock = new StampedLock();
    private transient Thread threadHoldingWriteLock;
    private boolean parallelValidation = false;
    private boolean undefinedTargetValidatesAllSubjects = false;
    private boolean logValidationPlans = false;
    private boolean logValidationViolations = false;
    private boolean ignoreNoShapesLoadedException = false;
    private boolean validationEnabled = true;
    private boolean cacheSelectNodes = true;
    private boolean rdfsSubClassReasoning = true;
    private boolean performanceLogging = false;
    private final AtomicBoolean initialized = new AtomicBoolean(false);

    private static String resourceAsString(String s) throws IOException {
        return IOUtils.toString((InputStream)ShaclSail.class.getClassLoader().getResourceAsStream(s), (Charset)StandardCharsets.UTF_8);
    }

    public ShaclSail(NotifyingSail baseSail) {
        super(baseSail);
    }

    public ShaclSail() {
    }

    public static List<IRI> getSupportedShaclPredicates() {
        return Arrays.asList(SHACL.TARGET_CLASS, SHACL.PATH, SHACL.PROPERTY, SHACL.OR, SHACL.AND, SHACL.MIN_COUNT, SHACL.MAX_COUNT, SHACL.MIN_LENGTH, SHACL.MAX_LENGTH, SHACL.PATTERN, SHACL.FLAGS, SHACL.NODE_KIND_PROP, SHACL.LANGUAGE_IN, SHACL.DATATYPE, SHACL.MIN_EXCLUSIVE, SHACL.MIN_INCLUSIVE, SHACL.MAX_EXCLUSIVE, SHACL.MAX_INCLUSIVE, SHACL.CLASS, SHACL.TARGET_NODE, SHACL.DEACTIVATED, SHACL.TARGET_SUBJECTS_OF, SHACL.IN, SHACL.UNIQUE_LANG, SHACL.NOT, SHACL.TARGET_OBJECTS_OF);
    }

    public void initialize() throws SailException {
        if (!this.initialized.compareAndSet(false, true)) {
            return;
        }
        super.initialize();
        if (this.getDataDir() != null) {
            if (this.parallelValidation) {
                logger.info("Automatically disabled parallel SHACL validation because persistent base sail was detected! Re-enable by calling setParallelValidation(true) after calling init() / initialize().");
            }
            this.setParallelValidation(false);
        }
        if (this.shapesRepo != null) {
            this.shapesRepo.shutDown();
            this.shapesRepo = null;
        }
        if (super.getBaseSail().getDataDir() != null) {
            String path = super.getBaseSail().getDataDir().getPath();
            if (path.endsWith("/")) {
                path = path.substring(0, path.length() - 1);
            }
            path = path + "-shapes-graph/";
            this.shapesRepo = new SailRepository((Sail)new MemoryStore(new File(path)));
        } else {
            this.shapesRepo = new SailRepository((Sail)new MemoryStore());
        }
        this.shapesRepo.init();
        try (SailRepositoryConnection shapesRepoConnection = this.shapesRepo.getConnection();){
            shapesRepoConnection.begin((IsolationLevel)IsolationLevels.NONE);
            this.nodeShapes = this.refreshShapes(shapesRepoConnection);
            shapesRepoConnection.commit();
        }
    }

    List<NodeShape> refreshShapes(SailRepositoryConnection shapesRepoConnection) throws SailException {
        List<NodeShape> shapes;
        SailRepository shapesRepoCache = new SailRepository((Sail)new MemoryStore());
        shapesRepoCache.init();
        try (SailRepositoryConnection shapesRepoCacheConnection = shapesRepoCache.getConnection();){
            shapesRepoCacheConnection.begin((IsolationLevel)IsolationLevels.NONE);
            try (RepositoryResult statements = shapesRepoConnection.getStatements(null, null, null, false, new Resource[0]);){
                shapesRepoCacheConnection.add((Iteration)statements, new Resource[0]);
            }
            this.runInferencingSparqlQueries(shapesRepoCacheConnection);
            shapesRepoCacheConnection.commit();
            shapes = NodeShape.Factory.getShapes(shapesRepoCacheConnection, this);
        }
        shapesRepoCache.shutDown();
        return shapes;
    }

    public void shutDown() throws SailException {
        if (this.shapesRepo != null) {
            this.shapesRepo.shutDown();
            this.shapesRepo = null;
        }
        this.initialized.set(false);
        this.nodeShapes = Collections.emptyList();
        super.shutDown();
    }

    public NotifyingSailConnection getConnection() throws SailException {
        return new ShaclSailConnection(this, super.getConnection(), super.getConnection(), this.shapesRepo.getConnection());
    }

    List<NodeShape> getNodeShapes() {
        return this.nodeShapes;
    }

    private void runInferencingSparqlQueries(SailRepositoryConnection shaclSailConnection) {
        long prevSize;
        long currentSize = shaclSailConnection.size(new Resource[0]);
        do {
            prevSize = currentSize;
            shaclSailConnection.prepareUpdate(IMPLICIT_TARGET_CLASS_PROPERTY_SHAPE).execute();
            shaclSailConnection.prepareUpdate(IMPLICIT_TARGET_CLASS_NODE_SHAPE).execute();
            shaclSailConnection.prepareUpdate(PROPERTY_SHAPE_WITH_TARGET).execute();
        } while (prevSize != (currentSize = shaclSailConnection.size(new Resource[0])));
    }

    long acquireExclusiveWriteLock(long stamp) {
        if (this.lock.validate(stamp)) {
            return stamp;
        }
        if (this.threadHoldingWriteLock == Thread.currentThread()) {
            throw new SailConflictException("Deadlock detected when a single thread uses multiple connections interleaved and one connection has modified the shapes without calling commit() while another connection also tries to modify the shapes!");
        }
        long newStamp = this.lock.writeLock();
        this.threadHoldingWriteLock = Thread.currentThread();
        return newStamp;
    }

    boolean holdsWriteLock(long stamp) {
        return this.lock.validate(stamp);
    }

    void releaseExclusiveWriteLock(long stamp) {
        this.threadHoldingWriteLock = null;
        this.lock.unlockWrite(stamp);
    }

    long readlock() {
        if (this.threadHoldingWriteLock == Thread.currentThread()) {
            throw new SailConflictException("Deadlock detected when a single thread uses multiple connections interleaved and one connection has modified the shapes without calling commit() while another connection calls commit()!");
        }
        return this.lock.readLock();
    }

    void releaseReadlock(long stamp) {
        this.lock.unlockRead(stamp);
    }

    public void setGlobalLogValidationExecution(boolean loggingEnabled) {
        GlobalValidationExecutionLogging.loggingEnabled = loggingEnabled;
    }

    public boolean isGlobalLogValidationExecution() {
        return GlobalValidationExecutionLogging.loggingEnabled;
    }

    public boolean isLogValidationViolations() {
        return this.logValidationViolations;
    }

    public void setLogValidationViolations(boolean logValidationViolations) {
        this.logValidationViolations = logValidationViolations;
    }

    public void setUndefinedTargetValidatesAllSubjects(boolean undefinedTargetValidatesAllSubjects) {
        this.undefinedTargetValidatesAllSubjects = undefinedTargetValidatesAllSubjects;
    }

    public boolean isUndefinedTargetValidatesAllSubjects() {
        return this.undefinedTargetValidatesAllSubjects;
    }

    public boolean isParallelValidation() {
        return this.parallelValidation;
    }

    public void setParallelValidation(boolean parallelValidation) {
        if (parallelValidation) {
            logger.warn("Parallel SHACL validation enabled. This is an experimental feature and may cause deadlocks!");
        }
        this.parallelValidation = parallelValidation;
    }

    public boolean isCacheSelectNodes() {
        return this.cacheSelectNodes;
    }

    public void setCacheSelectNodes(boolean cacheSelectNodes) {
        this.cacheSelectNodes = cacheSelectNodes;
    }

    public boolean isRdfsSubClassReasoning() {
        return this.rdfsSubClassReasoning;
    }

    public void setRdfsSubClassReasoning(boolean rdfsSubClassReasoning) {
        this.rdfsSubClassReasoning = rdfsSubClassReasoning;
    }

    public void disableValidation() {
        this.validationEnabled = false;
    }

    public void enableValidation() {
        this.validationEnabled = true;
    }

    public boolean isValidationEnabled() {
        return this.validationEnabled;
    }

    public boolean isLogValidationPlans() {
        return this.logValidationPlans;
    }

    public boolean isIgnoreNoShapesLoadedException() {
        return this.ignoreNoShapesLoadedException;
    }

    public void setIgnoreNoShapesLoadedException(boolean ignoreNoShapesLoadedException) {
        this.ignoreNoShapesLoadedException = ignoreNoShapesLoadedException;
    }

    public void setLogValidationPlans(boolean logValidationPlans) {
        this.logValidationPlans = logValidationPlans;
    }

    public boolean isPerformanceLogging() {
        return this.performanceLogging;
    }

    public void setPerformanceLogging(boolean performanceLogging) {
        this.performanceLogging = performanceLogging;
    }

    public void setNodeShapes(List<NodeShape> nodeShapes) {
        this.nodeShapes = nodeShapes;
    }

    static {
        try {
            IMPLICIT_TARGET_CLASS_NODE_SHAPE = ShaclSail.resourceAsString("shacl-sparql-inference/implicitTargetClassNodeShape.rq");
            IMPLICIT_TARGET_CLASS_PROPERTY_SHAPE = ShaclSail.resourceAsString("shacl-sparql-inference/implicitTargetClassPropertyShape.rq");
            PROPERTY_SHAPE_WITH_TARGET = ShaclSail.resourceAsString("shacl-sparql-inference/propertyShapeWithTarget.rq");
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }
}

