/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.AST;

import java.util.Objects;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.repository.sail.SailRepositoryConnection;
import org.eclipse.rdf4j.sail.NotifyingSailConnection;
import org.eclipse.rdf4j.sail.SailConnection;
import org.eclipse.rdf4j.sail.shacl.AST.NodeShape;
import org.eclipse.rdf4j.sail.shacl.AST.Path;
import org.eclipse.rdf4j.sail.shacl.AST.PathPropertyShape;
import org.eclipse.rdf4j.sail.shacl.ShaclSailConnection;
import org.eclipse.rdf4j.sail.shacl.SourceConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.planNodes.BulkedExternalInnerJoin;
import org.eclipse.rdf4j.sail.shacl.planNodes.EnrichWithShape;
import org.eclipse.rdf4j.sail.shacl.planNodes.InnerJoin;
import org.eclipse.rdf4j.sail.shacl.planNodes.NonUniqueTargetLang;
import org.eclipse.rdf4j.sail.shacl.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.PlanNodeProvider;
import org.eclipse.rdf4j.sail.shacl.planNodes.TrimTuple;
import org.eclipse.rdf4j.sail.shacl.planNodes.UnBufferedPlanNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.UnionNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.Unique;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UniqueLangPropertyShape
extends PathPropertyShape {
    private final boolean uniqueLang;
    private static final Logger logger = LoggerFactory.getLogger(UniqueLangPropertyShape.class);

    UniqueLangPropertyShape(Resource id, SailRepositoryConnection connection, NodeShape nodeShape, boolean deactivated, PathPropertyShape parent, Resource path, boolean uniqueLang) {
        super(id, connection, nodeShape, deactivated, parent, path);
        this.uniqueLang = uniqueLang;
        assert (uniqueLang) : "uniqueLang should always be true";
    }

    @Override
    public PlanNode getPlan(ShaclSailConnection shaclSailConnection, boolean printPlans, PlanNodeProvider overrideTargetNode, boolean negateThisPlan, boolean negateSubPlans) {
        if (this.deactivated) {
            return null;
        }
        assert (!negateSubPlans) : "There are no subplans!";
        assert (!negateThisPlan);
        assert (this.hasOwnPath());
        if (overrideTargetNode != null) {
            BulkedExternalInnerJoin relevantTargetsWithPath = new BulkedExternalInnerJoin(overrideTargetNode.getPlanNode(), (SailConnection)shaclSailConnection, this.getPath().getQuery("?a", "?c", null), false, "?a", "?c");
            NonUniqueTargetLang planNode = new NonUniqueTargetLang(relevantTargetsWithPath);
            if (printPlans) {
                String planAsGraphvizDot = this.getPlanAsGraphvizDot(planNode, shaclSailConnection);
                logger.info(planAsGraphvizDot);
            }
            return new EnrichWithShape(planNode, this);
        }
        if (shaclSailConnection.stats.isBaseSailEmpty()) {
            PlanNode addedTargets = this.nodeShape.getPlanAddedStatements(shaclSailConnection, null);
            PlanNode addedByPath = super.getPlanAddedStatements(shaclSailConnection, null);
            PlanNode innerJoin = new InnerJoin(addedTargets, addedByPath).getJoined(UnBufferedPlanNode.class);
            NonUniqueTargetLang planNode = new NonUniqueTargetLang(innerJoin);
            if (printPlans) {
                String planAsGraphvizDot = this.getPlanAsGraphvizDot(planNode, shaclSailConnection);
                logger.info(planAsGraphvizDot);
            }
            return new EnrichWithShape(planNode, this);
        }
        PlanNode addedTargets = this.nodeShape.getPlanAddedStatements(shaclSailConnection, null);
        PlanNode addedByPath = super.getPlanAddedStatements(shaclSailConnection, null);
        addedByPath = this.nodeShape.getTargetFilter((NotifyingSailConnection)shaclSailConnection, addedByPath);
        UnionNode mergeNode = new UnionNode(addedTargets, addedByPath);
        TrimTuple trimmed = new TrimTuple(mergeNode, 0, 1);
        Unique allRelevantTargets = new Unique(trimmed);
        BulkedExternalInnerJoin relevantTargetsWithPath = new BulkedExternalInnerJoin(allRelevantTargets, (SailConnection)shaclSailConnection, this.getPath().getQuery("?a", "?c", null), false, "?a", "?c");
        NonUniqueTargetLang planNode = new NonUniqueTargetLang(relevantTargetsWithPath);
        if (printPlans) {
            String planAsGraphvizDot = this.getPlanAsGraphvizDot(planNode, shaclSailConnection);
            logger.info(planAsGraphvizDot);
        }
        return new EnrichWithShape(planNode, this);
    }

    @Override
    public SourceConstraintComponent getSourceConstraintComponent() {
        return SourceConstraintComponent.UniqueLangConstraintComponent;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        UniqueLangPropertyShape that = (UniqueLangPropertyShape)o;
        return this.uniqueLang == that.uniqueLang;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.uniqueLang);
    }

    public String toString() {
        return "UniqueLangPropertyShape{uniqueLang=" + this.uniqueLang + ", path=" + this.getPath() + '}';
    }

    @Override
    public PlanNode getAllTargetsPlan(ShaclSailConnection shaclSailConnection, boolean negated) {
        PlanNode plan = this.nodeShape.getPlanAddedStatements(shaclSailConnection, null);
        plan = new UnionNode(plan, this.nodeShape.getPlanRemovedStatements(shaclSailConnection, null));
        Path path = this.getPath();
        if (path != null) {
            plan = new UnionNode(plan, this.getPlanAddedStatements(shaclSailConnection, null));
            plan = new UnionNode(plan, this.getPlanRemovedStatements(shaclSailConnection, null));
        }
        plan = new Unique(new TrimTuple(plan, 0, 1));
        return this.nodeShape.getTargetFilter((NotifyingSailConnection)shaclSailConnection, plan);
    }
}

