/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.AST;

import java.util.Arrays;
import java.util.Objects;
import java.util.Set;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.repository.sail.SailRepositoryConnection;
import org.eclipse.rdf4j.sail.NotifyingSailConnection;
import org.eclipse.rdf4j.sail.SailConnection;
import org.eclipse.rdf4j.sail.shacl.AST.NodeShape;
import org.eclipse.rdf4j.sail.shacl.AST.PlaneNodeWrapper;
import org.eclipse.rdf4j.sail.shacl.RdfsSubClassOfReasoner;
import org.eclipse.rdf4j.sail.shacl.ShaclSailConnection;
import org.eclipse.rdf4j.sail.shacl.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.PlanNodeProvider;
import org.eclipse.rdf4j.sail.shacl.planNodes.Select;
import org.eclipse.rdf4j.sail.shacl.planNodes.SetFilterNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.TrimTuple;
import org.eclipse.rdf4j.sail.shacl.planNodes.Unique;

public class TargetNode
extends NodeShape {
    private final Set<Value> targetNodeSet;

    TargetNode(Resource id, SailRepositoryConnection connection, boolean deactivated, Set<Value> targetNode) {
        super(id, connection, deactivated);
        this.targetNodeSet = targetNode;
        assert (!this.targetNodeSet.isEmpty());
    }

    @Override
    public PlanNode getPlan(ShaclSailConnection shaclSailConnection, boolean printPlans, PlanNodeProvider overrideTargetNode, boolean negateThisPlan, boolean negateSubPlans) {
        assert (!negateSubPlans) : "There are no subplans!";
        assert (!negateThisPlan);
        PlanNode parent = shaclSailConnection.getCachedNodeFor(new Select((SailConnection)shaclSailConnection, this.getQuery("?a", "?c", shaclSailConnection.getRdfsSubClassOfReasoner()), "?a", "?c"));
        return new Unique(new TrimTuple(parent, 0, 1));
    }

    @Override
    public PlanNode getPlanAddedStatements(ShaclSailConnection shaclSailConnection, PlaneNodeWrapper planeNodeWrapper) {
        PlanNode parent = shaclSailConnection.getCachedNodeFor(new Select(shaclSailConnection.getAddedStatements(), this.getQuery("?a", "?c", null), "?a", "?c"));
        return new Unique(new TrimTuple(parent, 0, 1));
    }

    @Override
    public PlanNode getPlanRemovedStatements(ShaclSailConnection shaclSailConnection, PlaneNodeWrapper planeNodeWrapper) {
        PlanNode parent = shaclSailConnection.getCachedNodeFor(new Select(shaclSailConnection.getRemovedStatements(), this.getQuery("?a", "?c", null), "?a", "?c"));
        return new Unique(new TrimTuple(parent, 0, 1));
    }

    @Override
    public boolean requiresEvaluation(SailConnection addedStatements, SailConnection removedStatements) {
        return true;
    }

    @Override
    public String getQuery(String subjectVariable, String objectVariable, RdfsSubClassOfReasoner rdfsSubClassOfReasoner) {
        return this.targetNodeSet.stream().map(node -> {
            if (node instanceof Resource) {
                return "<" + node + ">";
            }
            if (node instanceof Literal) {
                IRI datatype = ((Literal)node).getDatatype();
                if (datatype == null) {
                    return "\"" + node.stringValue() + "\"";
                }
                return "\"" + node.stringValue() + "\"^^<" + datatype.stringValue() + ">";
            }
            throw new IllegalStateException(node.getClass().getSimpleName());
        }).map(r -> "{{ select * where {BIND(" + r + " as " + subjectVariable + "). " + subjectVariable + " ?b1 " + objectVariable + " .}}}\n UNION \n{{ select * where {BIND(" + r + " as " + subjectVariable + "). " + objectVariable + " ?b1 " + subjectVariable + " .}}}").reduce((a, b) -> a + " UNION " + b).get();
    }

    @Override
    public PlanNode getTargetFilter(NotifyingSailConnection shaclSailConnection, PlanNode parent) {
        return new SetFilterNode(this.targetNodeSet, parent, 0, true);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TargetNode that = (TargetNode)o;
        return this.targetNodeSet.equals(that.targetNodeSet);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.targetNodeSet);
    }

    @Override
    public String toString() {
        return "TargetNode{targetNodeSet=" + Arrays.toString(this.targetNodeSet.toArray()) + '}';
    }
}

