/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.AST;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.repository.sail.SailRepositoryConnection;
import org.eclipse.rdf4j.sail.NotifyingSailConnection;
import org.eclipse.rdf4j.sail.SailConnection;
import org.eclipse.rdf4j.sail.shacl.AST.NodeShape;
import org.eclipse.rdf4j.sail.shacl.AST.Path;
import org.eclipse.rdf4j.sail.shacl.AST.PlaneNodeWrapper;
import org.eclipse.rdf4j.sail.shacl.AST.PropertyShape;
import org.eclipse.rdf4j.sail.shacl.AST.SimplePath;
import org.eclipse.rdf4j.sail.shacl.ShaclSailConnection;
import org.eclipse.rdf4j.sail.shacl.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.PlanNodeProvider;
import org.eclipse.rdf4j.sail.shacl.planNodes.Select;
import org.eclipse.rdf4j.sail.shacl.planNodes.Sort;
import org.eclipse.rdf4j.sail.shacl.planNodes.Unique;
import org.eclipse.rdf4j.sail.shacl.planNodes.UnorderedSelect;

public abstract class PathPropertyShape
extends PropertyShape {
    private Path path;

    PathPropertyShape(Resource id, SailRepositoryConnection connection, NodeShape nodeShape, boolean deactivated, PathPropertyShape parent, Resource path) {
        super(id, nodeShape, deactivated, parent);
        if (path != null) {
            this.path = new SimplePath((IRI)path);
        }
    }

    PathPropertyShape(Resource id, NodeShape nodeShape, boolean deactivated, PathPropertyShape parent, Path path) {
        super(id, nodeShape, deactivated, parent);
        this.path = path;
    }

    @Override
    public PlanNode getPlan(ShaclSailConnection shaclSailConnection, boolean printPlans, PlanNodeProvider overrideTargetNode, boolean negateThisPlan, boolean negateSubPlans) {
        return shaclSailConnection.getCachedNodeFor(new Sort(new UnorderedSelect((SailConnection)shaclSailConnection, null, (IRI)this.getPath().getId(), null, UnorderedSelect.OutputPattern.SubjectObject)));
    }

    @Override
    public PlanNode getPlanAddedStatements(ShaclSailConnection shaclSailConnection, PlaneNodeWrapper planeNodeWrapper) {
        PlanNode unorderedSelect = new UnorderedSelect(shaclSailConnection.getAddedStatements(), null, (IRI)this.getPath().getId(), null, UnorderedSelect.OutputPattern.SubjectObject);
        if (planeNodeWrapper != null) {
            unorderedSelect = planeNodeWrapper.wrap(unorderedSelect);
        }
        return shaclSailConnection.getCachedNodeFor(new Sort(unorderedSelect));
    }

    @Override
    public PlanNode getPlanRemovedStatements(ShaclSailConnection shaclSailConnection, PlaneNodeWrapper planeNodeWrapper) {
        PlanNode unorderedSelect = new UnorderedSelect(shaclSailConnection.getRemovedStatements(), null, (IRI)this.getPath().getId(), null, UnorderedSelect.OutputPattern.SubjectObject);
        if (planeNodeWrapper != null) {
            unorderedSelect = planeNodeWrapper.wrap(unorderedSelect);
        }
        return shaclSailConnection.getCachedNodeFor(new Sort(unorderedSelect));
    }

    @Override
    public List<Path> getPaths() {
        return Collections.singletonList(this.getPath());
    }

    public boolean hasOwnPath() {
        return this.path != null;
    }

    @Override
    public boolean requiresEvaluation(SailConnection addedStatements, SailConnection removedStatements) {
        if (this.deactivated) {
            return false;
        }
        if (this.path == null) {
            return super.requiresEvaluation(addedStatements, removedStatements);
        }
        return super.requiresEvaluation(addedStatements, removedStatements) || this.path.requiresEvaluation(addedStatements, removedStatements);
    }

    public Path getPath() {
        if (this.path == null && this.parent != null) {
            return this.parent.getPath();
        }
        return this.path;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PathPropertyShape that = (PathPropertyShape)o;
        return Objects.equals(this.path, that.path);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.path);
    }

    @Override
    public PlanNode getAllTargetsPlan(ShaclSailConnection shaclSailConnection, boolean negated) {
        Select select = new Select((SailConnection)shaclSailConnection, "?a ?b ?c", "?a");
        Unique unique = new Unique(select);
        return this.nodeShape.getTargetFilter((NotifyingSailConnection)shaclSailConnection, unique);
    }
}

