/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.AST;

import java.util.Objects;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.repository.sail.SailRepositoryConnection;
import org.eclipse.rdf4j.sail.NotifyingSailConnection;
import org.eclipse.rdf4j.sail.SailConnection;
import org.eclipse.rdf4j.sail.shacl.AST.NodeShape;
import org.eclipse.rdf4j.sail.shacl.AST.Path;
import org.eclipse.rdf4j.sail.shacl.AST.PathPropertyShape;
import org.eclipse.rdf4j.sail.shacl.ShaclSailConnection;
import org.eclipse.rdf4j.sail.shacl.SourceConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.planNodes.AggregateIteratorTypeOverride;
import org.eclipse.rdf4j.sail.shacl.planNodes.BulkedExternalLeftOuterJoin;
import org.eclipse.rdf4j.sail.shacl.planNodes.EnrichWithShape;
import org.eclipse.rdf4j.sail.shacl.planNodes.GroupByCount;
import org.eclipse.rdf4j.sail.shacl.planNodes.MinCountFilter;
import org.eclipse.rdf4j.sail.shacl.planNodes.ModifyTuple;
import org.eclipse.rdf4j.sail.shacl.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.PlanNodeProvider;
import org.eclipse.rdf4j.sail.shacl.planNodes.Select;
import org.eclipse.rdf4j.sail.shacl.planNodes.TrimTuple;
import org.eclipse.rdf4j.sail.shacl.planNodes.UnBufferedPlanNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.UnionNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.Unique;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MinCountPropertyShape
extends PathPropertyShape {
    private long minCount;
    private static final Logger logger = LoggerFactory.getLogger(MinCountPropertyShape.class);
    private boolean optimizeWhenNoStatementsRemoved = true;

    MinCountPropertyShape(Resource id, SailRepositoryConnection connection, NodeShape nodeShape, boolean deactivated, PathPropertyShape parent, Resource path, Long minCount) {
        super(id, connection, nodeShape, deactivated, parent, path);
        this.minCount = minCount;
    }

    @Override
    public PlanNode getPlan(ShaclSailConnection shaclSailConnection, boolean printPlans, PlanNodeProvider overrideTargetNode, boolean negateThisPlan, boolean negateSubPlans) {
        PlanNode filteredStatements;
        UnionNode topNode;
        if (this.deactivated) {
            return null;
        }
        assert (!negateSubPlans) : "There are no subplans!";
        assert (!negateThisPlan);
        assert (this.hasOwnPath());
        if (overrideTargetNode != null) {
            BulkedExternalLeftOuterJoin allStatements = new BulkedExternalLeftOuterJoin(overrideTargetNode.getPlanNode(), (SailConnection)shaclSailConnection, this.getPath().getQuery("?a", "?c", null), false, "?a", "?c");
            GroupByCount groupBy = new GroupByCount(allStatements);
            PlanNode filteredStatements2 = new MinCountFilter(groupBy, this.minCount).getFalseNode(UnBufferedPlanNode.class);
            if (printPlans) {
                String planAsGraphvizDot = this.getPlanAsGraphvizDot(filteredStatements2, shaclSailConnection);
                logger.info(planAsGraphvizDot);
            }
            return new EnrichWithShape(filteredStatements2, this);
        }
        if (this.minCount == 1L && shaclSailConnection.stats.isBaseSailEmpty()) {
            String query = this.nodeShape.getQuery("?a", "?b", null);
            String query1 = this.getPath().getQuery("?a", "?d", null);
            String negationQuery = query + "\n FILTER(NOT EXISTS{" + query1 + "})";
            PlanNode select = new Select(shaclSailConnection.getAddedStatements(), negationQuery, "?a");
            select = new ModifyTuple(select, a -> {
                a.line.add((Value)SimpleValueFactory.getInstance().createLiteral(0));
                return a;
            });
            select = new AggregateIteratorTypeOverride(select);
            if (printPlans) {
                String planAsGraphvizDot = this.getPlanAsGraphvizDot(select, shaclSailConnection);
                logger.info(planAsGraphvizDot);
            }
            return new EnrichWithShape(select, this);
        }
        if (!this.optimizeWhenNoStatementsRemoved || shaclSailConnection.stats.hasRemoved()) {
            Unique planRemovedStatements = new Unique(new TrimTuple(this.getPlanRemovedStatements(shaclSailConnection, null), 0, 1));
            PlanNode filteredPlanRemovedStatements = this.nodeShape.getTargetFilter((NotifyingSailConnection)shaclSailConnection, planRemovedStatements);
            PlanNode planAddedStatements = this.nodeShape.getPlanAddedStatements(shaclSailConnection, null);
            UnionNode mergeNode = new UnionNode(planAddedStatements, filteredPlanRemovedStatements);
            Unique unique = new Unique(mergeNode);
            PlanNode planAddedStatements1 = this.getPlanAddedStatements(shaclSailConnection, null);
            planAddedStatements1 = this.nodeShape.getTargetFilter((NotifyingSailConnection)shaclSailConnection, planAddedStatements1);
            topNode = new UnionNode(unique, planAddedStatements1);
        } else {
            PlanNode planAddedForShape = this.nodeShape.getPlanAddedStatements(shaclSailConnection, null);
            PlanNode addedByPath = this.getPlanAddedStatements(shaclSailConnection, null);
            addedByPath = this.nodeShape.getTargetFilter((NotifyingSailConnection)shaclSailConnection, addedByPath);
            topNode = new UnionNode(planAddedForShape, addedByPath);
        }
        GroupByCount groupBy = new GroupByCount(topNode);
        PlanNode minCountFilter = filteredStatements = new MinCountFilter(groupBy, this.minCount).getFalseNode(UnBufferedPlanNode.class);
        Unique trimTuple = new Unique(new TrimTuple(minCountFilter, 0, 1));
        BulkedExternalLeftOuterJoin bulkedExternalLeftOuterJoin2 = new BulkedExternalLeftOuterJoin(trimTuple, (SailConnection)shaclSailConnection, this.getPath().getQuery("?a", "?c", null), false, "?a", "?c");
        GroupByCount groupBy2 = new GroupByCount(bulkedExternalLeftOuterJoin2);
        PlanNode filteredStatements2 = new MinCountFilter(groupBy2, this.minCount).getFalseNode(UnBufferedPlanNode.class);
        if (printPlans) {
            String planAsGraphvizDot = this.getPlanAsGraphvizDot(filteredStatements2, shaclSailConnection);
            logger.info(planAsGraphvizDot);
        }
        return new EnrichWithShape(filteredStatements2, this);
    }

    @Override
    public SourceConstraintComponent getSourceConstraintComponent() {
        return SourceConstraintComponent.MinCountConstraintComponent;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MinCountPropertyShape that = (MinCountPropertyShape)o;
        return this.minCount == that.minCount;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.minCount);
    }

    public String toString() {
        return "MinCountPropertyShape{minCount=" + this.minCount + ", path=" + this.getPath() + '}';
    }

    @Override
    public PlanNode getAllTargetsPlan(ShaclSailConnection shaclSailConnection, boolean negated) {
        PlanNode plan = this.nodeShape.getPlanAddedStatements(shaclSailConnection, null);
        plan = new UnionNode(plan, this.nodeShape.getPlanRemovedStatements(shaclSailConnection, null));
        Path path = this.getPath();
        if (path != null) {
            plan = new UnionNode(plan, this.getPlanAddedStatements(shaclSailConnection, null));
            plan = new UnionNode(plan, this.getPlanRemovedStatements(shaclSailConnection, null));
        }
        plan = new Unique(new TrimTuple(plan, 0, 1));
        return this.nodeShape.getTargetFilter((NotifyingSailConnection)shaclSailConnection, plan);
    }
}

