/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.AST;

import java.util.Objects;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.repository.sail.SailRepositoryConnection;
import org.eclipse.rdf4j.sail.NotifyingSailConnection;
import org.eclipse.rdf4j.sail.SailConnection;
import org.eclipse.rdf4j.sail.shacl.AST.NodeShape;
import org.eclipse.rdf4j.sail.shacl.AST.Path;
import org.eclipse.rdf4j.sail.shacl.AST.PathPropertyShape;
import org.eclipse.rdf4j.sail.shacl.ShaclSailConnection;
import org.eclipse.rdf4j.sail.shacl.SourceConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.planNodes.AggregateIteratorTypeOverride;
import org.eclipse.rdf4j.sail.shacl.planNodes.BufferedPlanNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.BulkedExternalInnerJoin;
import org.eclipse.rdf4j.sail.shacl.planNodes.EnrichWithShape;
import org.eclipse.rdf4j.sail.shacl.planNodes.GroupByCount;
import org.eclipse.rdf4j.sail.shacl.planNodes.MaxCountFilter;
import org.eclipse.rdf4j.sail.shacl.planNodes.ModifyTuple;
import org.eclipse.rdf4j.sail.shacl.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.PlanNodeProvider;
import org.eclipse.rdf4j.sail.shacl.planNodes.Select;
import org.eclipse.rdf4j.sail.shacl.planNodes.TrimTuple;
import org.eclipse.rdf4j.sail.shacl.planNodes.UnBufferedPlanNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.UnionNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.Unique;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaxCountPropertyShape
extends PathPropertyShape {
    private static final Logger logger = LoggerFactory.getLogger(MaxCountPropertyShape.class);
    private long maxCount;

    MaxCountPropertyShape(Resource id, SailRepositoryConnection connection, NodeShape nodeShape, boolean deactivated, PathPropertyShape parent, Resource path, Long maxCount) {
        super(id, connection, nodeShape, deactivated, parent, path);
        this.maxCount = maxCount;
    }

    @Override
    public PlanNode getPlan(ShaclSailConnection shaclSailConnection, boolean printPlans, PlanNodeProvider overrideTargetNode, boolean negateThisPlan, boolean negateSubPlans) {
        PlanNode mergeNode1;
        if (this.deactivated) {
            return null;
        }
        assert (!negateSubPlans) : "There are no subplans!";
        assert (!negateThisPlan);
        assert (this.hasOwnPath());
        if (overrideTargetNode != null) {
            BulkedExternalInnerJoin bulkedExternalInnerJoin = new BulkedExternalInnerJoin(overrideTargetNode.getPlanNode(), (SailConnection)shaclSailConnection, this.getPath().getQuery("?a", "?c", null), false, "?a", "?c");
            GroupByCount groupByCount = new GroupByCount(bulkedExternalInnerJoin);
            PlanNode directTupleFromFilter = new MaxCountFilter(groupByCount, this.maxCount).getFalseNode(UnBufferedPlanNode.class);
            if (printPlans) {
                String planAsGraphvizDot = this.getPlanAsGraphvizDot(directTupleFromFilter, shaclSailConnection);
                logger.info(planAsGraphvizDot);
            }
            return new EnrichWithShape(directTupleFromFilter, this);
        }
        if (this.maxCount == 1L && shaclSailConnection.stats.isBaseSailEmpty()) {
            String query = this.nodeShape.getQuery("?a", "?b", null);
            String query1 = this.getPath().getQuery("?a", "?d", null);
            String query2 = this.getPath().getQuery("?a", "?e", null);
            String negationQuery = query + "\n" + query1 + "\n" + query2 + "\nFILTER(?d != ?e)";
            PlanNode select = new Select(shaclSailConnection.getAddedStatements(), negationQuery, "?a");
            select = new ModifyTuple(select, a -> {
                a.line.add((Value)SimpleValueFactory.getInstance().createLiteral(">= 2"));
                return a;
            });
            select = new AggregateIteratorTypeOverride(select);
            if (printPlans) {
                String planAsGraphvizDot = this.getPlanAsGraphvizDot(select, shaclSailConnection);
                logger.info(planAsGraphvizDot);
            }
            return new EnrichWithShape(select, this);
        }
        PlanNode planAddedStatements = this.nodeShape.getPlanAddedStatements(shaclSailConnection, null);
        PlanNode planAddedStatements1 = super.getPlanAddedStatements(shaclSailConnection, null);
        planAddedStatements1 = this.nodeShape.getTargetFilter((NotifyingSailConnection)shaclSailConnection, planAddedStatements1);
        UnionNode mergeNode = new UnionNode(planAddedStatements, planAddedStatements1);
        GroupByCount groupByCount1 = new GroupByCount(mergeNode);
        MaxCountFilter maxCountFilter = new MaxCountFilter(groupByCount1, this.maxCount);
        PlanNode validValues = maxCountFilter.getTrueNode(BufferedPlanNode.class);
        PlanNode invalidValues = maxCountFilter.getFalseNode(BufferedPlanNode.class);
        if (!shaclSailConnection.stats.isBaseSailEmpty()) {
            TrimTuple trimmed = new TrimTuple(validValues, 0, 1);
            Unique unique = new Unique(trimmed);
            BulkedExternalInnerJoin bulkedExternalInnerJoin = new BulkedExternalInnerJoin(unique, (SailConnection)shaclSailConnection, this.getPath().getQuery("?a", "?c", null), true, "?a", "?c");
            GroupByCount groupByCount = new GroupByCount(bulkedExternalInnerJoin);
            PlanNode directTupleFromFilter = new MaxCountFilter(groupByCount, this.maxCount).getFalseNode(UnBufferedPlanNode.class);
            mergeNode1 = new UnionNode(directTupleFromFilter, invalidValues);
        } else {
            mergeNode1 = invalidValues;
        }
        if (printPlans) {
            String planAsGraphvizDot = this.getPlanAsGraphvizDot(mergeNode1, shaclSailConnection);
            logger.info(planAsGraphvizDot);
        }
        return new EnrichWithShape(mergeNode1, this);
    }

    @Override
    public SourceConstraintComponent getSourceConstraintComponent() {
        return SourceConstraintComponent.MaxCountConstraintComponent;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MaxCountPropertyShape that = (MaxCountPropertyShape)o;
        return this.maxCount == that.maxCount;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.maxCount);
    }

    public String toString() {
        return "MaxCountPropertyShape{maxCount=" + this.maxCount + ", path=" + this.getPath() + '}';
    }

    @Override
    public PlanNode getAllTargetsPlan(ShaclSailConnection shaclSailConnection, boolean negated) {
        PlanNode plan = this.nodeShape.getPlanAddedStatements(shaclSailConnection, null);
        plan = new UnionNode(plan, this.nodeShape.getPlanRemovedStatements(shaclSailConnection, null));
        Path path = this.getPath();
        if (path != null) {
            plan = new UnionNode(plan, this.getPlanAddedStatements(shaclSailConnection, null));
            plan = new UnionNode(plan, this.getPlanRemovedStatements(shaclSailConnection, null));
        }
        plan = new Unique(new TrimTuple(plan, 0, 1));
        return this.nodeShape.getTargetFilter((NotifyingSailConnection)shaclSailConnection, plan);
    }
}

