/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.AST;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.repository.sail.SailRepositoryConnection;
import org.eclipse.rdf4j.sail.NotifyingSailConnection;
import org.eclipse.rdf4j.sail.SailConnection;
import org.eclipse.rdf4j.sail.shacl.AST.NodeShape;
import org.eclipse.rdf4j.sail.shacl.AST.Path;
import org.eclipse.rdf4j.sail.shacl.AST.PathPropertyShape;
import org.eclipse.rdf4j.sail.shacl.ShaclSailConnection;
import org.eclipse.rdf4j.sail.shacl.SourceConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.planNodes.BufferedPlanNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.BulkedExternalInnerJoin;
import org.eclipse.rdf4j.sail.shacl.planNodes.BulkedExternalLeftOuterJoin;
import org.eclipse.rdf4j.sail.shacl.planNodes.EmptyNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.EnrichWithShape;
import org.eclipse.rdf4j.sail.shacl.planNodes.ExternalTypeFilterNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.InnerJoin;
import org.eclipse.rdf4j.sail.shacl.planNodes.ModifyTuple;
import org.eclipse.rdf4j.sail.shacl.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.PlanNodeProvider;
import org.eclipse.rdf4j.sail.shacl.planNodes.Select;
import org.eclipse.rdf4j.sail.shacl.planNodes.Sort;
import org.eclipse.rdf4j.sail.shacl.planNodes.TrimTuple;
import org.eclipse.rdf4j.sail.shacl.planNodes.TupleLengthFilter;
import org.eclipse.rdf4j.sail.shacl.planNodes.UnBufferedPlanNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.UnionNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.Unique;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassPropertyShape
extends PathPropertyShape {
    private final Resource classResource;
    private static final Logger logger = LoggerFactory.getLogger(ClassPropertyShape.class);

    ClassPropertyShape(Resource id, SailRepositoryConnection connection, NodeShape nodeShape, boolean deactivated, PathPropertyShape parent, Resource path, Resource classResource) {
        super(id, connection, nodeShape, deactivated, parent, path);
        this.classResource = classResource;
    }

    @Override
    public PlanNode getPlan(ShaclSailConnection shaclSailConnection, boolean printPlans, PlanNodeProvider overrideTargetNode, boolean negateThisPlan, boolean negateSubPlans) {
        if (this.deactivated) {
            return null;
        }
        assert (!negateSubPlans) : "There are no subplans!";
        if (negateThisPlan) {
            PlanNode negatedPlan = this.getNegatedPlan(shaclSailConnection, overrideTargetNode);
            if (printPlans) {
                String planAsGraphvizDot = this.getPlanAsGraphvizDot(negatedPlan, shaclSailConnection);
                logger.info(planAsGraphvizDot);
            }
            return new EnrichWithShape(negatedPlan, this);
        }
        SailConnection addedStatements = shaclSailConnection.getAddedStatements();
        if (overrideTargetNode != null) {
            PlanNode planNode = this.getPath() == null ? new ModifyTuple(overrideTargetNode.getPlanNode(), t -> {
                t.line.add(t.line.get(0));
                return t;
            }) : new BulkedExternalInnerJoin(overrideTargetNode.getPlanNode(), (SailConnection)shaclSailConnection, this.getPath().getQuery("?a", "?c", null), false, "?a", "?c");
            ExternalTypeFilterNode addedStatementsTypeFilter = new ExternalTypeFilterNode(addedStatements, Collections.singleton(this.classResource), planNode, 1, false);
            ExternalTypeFilterNode invalidTuplesDueToDataAddedThatMatchesTargetOrPath = new ExternalTypeFilterNode((SailConnection)shaclSailConnection, Collections.singleton(this.classResource), addedStatementsTypeFilter, 1, false);
            if (printPlans) {
                String planAsGraphvizDot = this.getPlanAsGraphvizDot(invalidTuplesDueToDataAddedThatMatchesTargetOrPath, shaclSailConnection);
                logger.info(planAsGraphvizDot);
            }
            return new EnrichWithShape(invalidTuplesDueToDataAddedThatMatchesTargetOrPath, this);
        }
        if (this.getPath() != null && shaclSailConnection.stats.isBaseSailEmpty()) {
            String query = this.nodeShape.getQuery("?a", "?b", null);
            String query1 = this.getPath().getQuery("?a", "?d", null);
            String negationQuery = query + "\n" + query1 + "\n FILTER(NOT EXISTS{?d a <" + this.classResource + ">})\n";
            Select select = new Select(shaclSailConnection.getAddedStatements(), negationQuery, "?a", "?d");
            if (printPlans) {
                String planAsGraphvizDot = this.getPlanAsGraphvizDot(select, shaclSailConnection);
                logger.info(planAsGraphvizDot);
            }
            return new EnrichWithShape(select, this);
        }
        if (this.getPath() == null) {
            ModifyTuple targets = new ModifyTuple(this.nodeShape.getPlanAddedStatements(shaclSailConnection, null), t -> {
                t.line.add(t.line.get(0));
                return t;
            });
            ExternalTypeFilterNode filteredAgainstAdded = new ExternalTypeFilterNode(addedStatements, Collections.singleton(this.classResource), targets, 1, false);
            PlanNode filteredAgainsteBaseSail = new ExternalTypeFilterNode((SailConnection)shaclSailConnection, Collections.singleton(this.classResource), filteredAgainstAdded, 1, false);
            if (shaclSailConnection.stats.hasRemoved()) {
                Select removedTypeStatements = new Select(shaclSailConnection.getRemovedStatements(), "?a a <" + this.classResource + ">", "?a");
                String query = this.nodeShape.getQuery("?a", "?q", shaclSailConnection.getRdfsSubClassOfReasoner());
                Unique invalidDataDueToRemovedTypeStatement = new Unique(new TrimTuple(new BulkedExternalInnerJoin(removedTypeStatements, (SailConnection)shaclSailConnection, query, false, "?a", "?c"), 0, 1));
                filteredAgainsteBaseSail = new UnionNode(filteredAgainsteBaseSail, invalidDataDueToRemovedTypeStatement);
            }
            return new EnrichWithShape(filteredAgainsteBaseSail, this);
        }
        PlanNode addedByPath = this.getPlanAddedStatements(shaclSailConnection, null);
        InnerJoin innerJoinHolder = new InnerJoin(this.nodeShape.getPlanAddedStatements(shaclSailConnection, null), addedByPath);
        PlanNode innerJoin = innerJoinHolder.getJoined(BufferedPlanNode.class);
        PlanNode discardedRight = innerJoinHolder.getDiscardedRight(BufferedPlanNode.class);
        PlanNode typeFilterPlan = this.nodeShape.getTargetFilter((NotifyingSailConnection)shaclSailConnection, discardedRight);
        innerJoin = new Unique(new UnionNode(innerJoin, typeFilterPlan));
        BulkedExternalLeftOuterJoin bulkedExternalLeftOuter = new BulkedExternalLeftOuterJoin(this.nodeShape.getPlanAddedStatements(shaclSailConnection, null), (SailConnection)shaclSailConnection, this.getPath().getQuery("?a", "?c", null), true, "?a", "?c");
        PlanNode joined = new TupleLengthFilter(new UnionNode(innerJoin, bulkedExternalLeftOuter), 2, false).getTrueNode(UnBufferedPlanNode.class);
        ExternalTypeFilterNode addedStatementsTypeFilter = new ExternalTypeFilterNode(addedStatements, Collections.singleton(this.classResource), joined, 1, false);
        PlanNode invalidTuplesDueToDataAddedThatMatchesTargetOrPath = new ExternalTypeFilterNode((SailConnection)shaclSailConnection, Collections.singleton(this.classResource), addedStatementsTypeFilter, 1, false);
        if (shaclSailConnection.stats.hasRemoved()) {
            Select removedTypeStatements = new Select(shaclSailConnection.getRemovedStatements(), "?a a <" + this.classResource + ">", "?a");
            String query = this.getPath().getQuery("?c", "?a", null) + this.nodeShape.getQuery("?c", "?q", shaclSailConnection.getRdfsSubClassOfReasoner());
            Sort invalidDataDueToRemovedTypeStatement = new Sort(new ModifyTuple(new BulkedExternalInnerJoin(removedTypeStatements, (SailConnection)shaclSailConnection, query, false, "?a", "?c"), t -> {
                List<Value> line = t.line;
                t.line = new ArrayList<Value>(2);
                t.line.add(line.get(1));
                t.line.add(line.get(0));
                return t;
            }));
            invalidTuplesDueToDataAddedThatMatchesTargetOrPath = new UnionNode(invalidTuplesDueToDataAddedThatMatchesTargetOrPath, invalidDataDueToRemovedTypeStatement);
        }
        if (printPlans) {
            String planAsGraphvizDot = this.getPlanAsGraphvizDot(invalidTuplesDueToDataAddedThatMatchesTargetOrPath, shaclSailConnection);
            logger.info(planAsGraphvizDot);
        }
        return new EnrichWithShape(invalidTuplesDueToDataAddedThatMatchesTargetOrPath, this);
    }

    private PlanNode getNegatedPlan(ShaclSailConnection shaclSailConnection, PlanNodeProvider overrideTargetNode) {
        if (overrideTargetNode != null) {
            PlanNode planNode = this.getPath() == null ? new ModifyTuple(overrideTargetNode.getPlanNode(), t -> {
                t.line.add(t.line.get(0));
                return t;
            }) : new BulkedExternalInnerJoin(overrideTargetNode.getPlanNode(), (SailConnection)shaclSailConnection, this.getPath().getQuery("?a", "?c", null), false, "?a", "?c");
            planNode = new ExternalTypeFilterNode((SailConnection)shaclSailConnection, Collections.singleton(this.classResource), planNode, 1, true);
            return planNode;
        }
        if (this.getPath() != null) {
            if (shaclSailConnection.stats.isBaseSailEmpty()) {
                StringBuilder query = new StringBuilder();
                query.append(this.nodeShape.getQuery("?target", "?type", null));
                query.append("\n");
                query.append(this.getPath().getQuery("?target", "?object", null));
                query.append("\n");
                query.append("?object a <" + this.classResource + ">");
                return new Select(shaclSailConnection.getAddedStatements(), query.toString(), "?target", "?object");
            }
            if (!shaclSailConnection.hasStatement(null, RDF.TYPE, (Value)this.classResource, true, new Resource[0])) {
                return new EmptyNode();
            }
            PlanNode addedByPath = this.getPlanAddedStatements(shaclSailConnection, null);
            InnerJoin innerJoinHolder = new InnerJoin(this.nodeShape.getPlanAddedStatements(shaclSailConnection, null), addedByPath);
            PlanNode innerJoin = innerJoinHolder.getJoined(BufferedPlanNode.class);
            PlanNode discardedRight = innerJoinHolder.getDiscardedRight(BufferedPlanNode.class);
            PlanNode typeFilterPlan = this.nodeShape.getTargetFilter((NotifyingSailConnection)shaclSailConnection, discardedRight);
            innerJoin = new Unique(new UnionNode(innerJoin, typeFilterPlan));
            BulkedExternalLeftOuterJoin bulkedExternalLeftOuter = new BulkedExternalLeftOuterJoin(this.nodeShape.getPlanAddedStatements(shaclSailConnection, null), (SailConnection)shaclSailConnection, this.getPath().getQuery("?a", "?c", null), true, "?a", "?c");
            innerJoin = new TupleLengthFilter(new UnionNode(innerJoin, bulkedExternalLeftOuter), 2, false).getTrueNode(UnBufferedPlanNode.class);
            Select newAddedByClassResource = new Select(shaclSailConnection.getAddedStatements(), "?a a <" + this.classResource + ">", "?a");
            String query = this.getPath().getQuery("?c", "?a", null) + this.nodeShape.getQuery("?c", "?q", shaclSailConnection.getRdfsSubClassOfReasoner());
            Sort invalidDataDueToRemovedTypeStatement = new Sort(new ModifyTuple(new BulkedExternalInnerJoin(newAddedByClassResource, (SailConnection)shaclSailConnection, query, false, "?a", "?c"), t -> {
                List<Value> line = t.line;
                t.line = new ArrayList<Value>(2);
                t.line.add(line.get(1));
                t.line.add(line.get(0));
                return t;
            }));
            innerJoin = new UnionNode(innerJoin, invalidDataDueToRemovedTypeStatement);
            innerJoin = new Unique(innerJoin);
            return new ExternalTypeFilterNode((SailConnection)shaclSailConnection, Collections.singleton(this.classResource), innerJoin, 1, true);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean requiresEvaluation(SailConnection addedStatements, SailConnection removedStatements) {
        if (this.deactivated) {
            return false;
        }
        return removedStatements.hasStatement(null, RDF.TYPE, (Value)this.classResource, true, new Resource[0]) || super.requiresEvaluation(addedStatements, removedStatements);
    }

    @Override
    public SourceConstraintComponent getSourceConstraintComponent() {
        return SourceConstraintComponent.ClassConstraintComponent;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ClassPropertyShape that = (ClassPropertyShape)o;
        return this.classResource.equals(that.classResource);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.classResource);
    }

    public String toString() {
        return "ClassPropertyShape{classResource=" + this.classResource + ", path=" + this.getPath() + '}';
    }

    @Override
    public PlanNode getAllTargetsPlan(ShaclSailConnection shaclSailConnection, boolean negated) {
        Sort invalidDataDueToRemovedTypeStatement;
        String query;
        Select removedTypeStatements;
        PlanNode plan = this.nodeShape.getPlanAddedStatements(shaclSailConnection, null);
        plan = new UnionNode(plan, this.nodeShape.getPlanRemovedStatements(shaclSailConnection, null));
        Path path = this.getPath();
        if (path != null) {
            plan = new UnionNode(plan, this.getPlanAddedStatements(shaclSailConnection, null));
            plan = new UnionNode(plan, this.getPlanRemovedStatements(shaclSailConnection, null));
        }
        if (!negated && shaclSailConnection.stats.hasRemoved() && this.getPath() != null) {
            removedTypeStatements = new Select(shaclSailConnection.getRemovedStatements(), "?a a <" + this.classResource + ">", "?a");
            query = this.getPath().getQuery("?c", "?a", null) + this.nodeShape.getQuery("?c", "?q", shaclSailConnection.getRdfsSubClassOfReasoner());
            invalidDataDueToRemovedTypeStatement = new Sort(new ModifyTuple(new BulkedExternalInnerJoin(removedTypeStatements, (SailConnection)shaclSailConnection, query, false, "?a", "?c"), t -> {
                List<Value> line = t.line;
                t.line = new ArrayList<Value>(2);
                t.line.add(line.get(1));
                t.line.add(line.get(0));
                return t;
            }));
            plan = new UnionNode(plan, invalidDataDueToRemovedTypeStatement);
        }
        if (negated && shaclSailConnection.stats.hasAdded() && this.getPath() != null) {
            removedTypeStatements = new Select(shaclSailConnection.getAddedStatements(), "?a a <" + this.classResource + ">", "?a");
            query = this.getPath().getQuery("?c", "?a", null) + this.nodeShape.getQuery("?c", "?q", shaclSailConnection.getRdfsSubClassOfReasoner());
            invalidDataDueToRemovedTypeStatement = new Sort(new ModifyTuple(new BulkedExternalInnerJoin(removedTypeStatements, (SailConnection)shaclSailConnection, query, false, "?a", "?c"), t -> {
                List<Value> line = t.line;
                t.line = new ArrayList<Value>(2);
                t.line.add(line.get(1));
                t.line.add(line.get(0));
                return t;
            }));
            plan = new UnionNode(plan, invalidDataDueToRemovedTypeStatement);
        }
        plan = new Unique(new TrimTuple(plan, 0, 1));
        return this.nodeShape.getTargetFilter((NotifyingSailConnection)shaclSailConnection, plan);
    }
}

