/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.rdf4j.IsolationLevel;
import org.eclipse.rdf4j.IsolationLevels;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.Iteration;
import org.eclipse.rdf4j.common.iteration.Iterations;
import org.eclipse.rdf4j.common.iteration.UnionIteration;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.model.vocabulary.RDF4J;
import org.eclipse.rdf4j.repository.sail.SailRepositoryConnection;
import org.eclipse.rdf4j.sail.NotifyingSailConnection;
import org.eclipse.rdf4j.sail.SailConnection;
import org.eclipse.rdf4j.sail.SailConnectionListener;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.UpdateContext;
import org.eclipse.rdf4j.sail.helpers.NotifyingSailConnectionWrapper;
import org.eclipse.rdf4j.sail.memory.MemoryStore;
import org.eclipse.rdf4j.sail.shacl.AST.NodeShape;
import org.eclipse.rdf4j.sail.shacl.AST.PropertyShape;
import org.eclipse.rdf4j.sail.shacl.NoShapesLoadedException;
import org.eclipse.rdf4j.sail.shacl.RdfsSubClassOfReasoner;
import org.eclipse.rdf4j.sail.shacl.ShaclSail;
import org.eclipse.rdf4j.sail.shacl.ShaclSailValidationException;
import org.eclipse.rdf4j.sail.shacl.planNodes.BufferedSplitter;
import org.eclipse.rdf4j.sail.shacl.planNodes.EnrichWithShape;
import org.eclipse.rdf4j.sail.shacl.planNodes.LoggingNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.Select;
import org.eclipse.rdf4j.sail.shacl.planNodes.Tuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShaclSailConnection
extends NotifyingSailConnectionWrapper
implements SailConnectionListener {
    private static final Logger logger = LoggerFactory.getLogger(ShaclSailConnection.class);
    private NotifyingSailConnection previousStateConnection;
    MemoryStore addedStatements;
    MemoryStore removedStatements;
    private ConcurrentLinkedQueue<SailConnection> connectionsToClose = new ConcurrentLinkedQueue();
    private HashSet<Statement> addedStatementsSet = new HashSet();
    private HashSet<Statement> removedStatementsSet = new HashSet();
    private boolean isShapeRefreshNeeded = false;
    public final ShaclSail sail;
    public Stats stats;
    RdfsSubClassOfReasoner rdfsSubClassOfReasoner;
    private boolean preparedHasRun = false;
    private SailRepositoryConnection shapesConnection;
    private Map<Select, BufferedSplitter> selectNodeCache;
    boolean validating;

    ShaclSailConnection(ShaclSail sail, NotifyingSailConnection connection, NotifyingSailConnection previousStateConnection, SailRepositoryConnection shapesConnection) {
        super(connection);
        this.previousStateConnection = previousStateConnection;
        this.shapesConnection = shapesConnection;
        this.sail = sail;
        if (sail.isValidationEnabled()) {
            this.addConnectionListener(this);
        }
    }

    public NotifyingSailConnection getPreviousStateConnection() {
        return this.previousStateConnection;
    }

    public SailConnection getAddedStatements() {
        NotifyingSailConnection connection = this.addedStatements.getConnection();
        this.connectionsToClose.add((SailConnection)connection);
        return connection;
    }

    public SailConnection getRemovedStatements() {
        NotifyingSailConnection connection = this.removedStatements.getConnection();
        this.connectionsToClose.add((SailConnection)connection);
        return connection;
    }

    public void begin() throws SailException {
        this.begin(this.sail.getDefaultIsolationLevel());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void begin(IsolationLevel level) throws SailException {
        assert (this.addedStatements == null);
        assert (this.removedStatements == null);
        assert (this.connectionsToClose.size() == 0);
        this.stats = new Stats();
        ShaclSail shaclSail = this.sail;
        synchronized (shaclSail) {
            super.begin(level);
            this.shapesConnection.begin(level);
            this.previousStateConnection.begin(level);
        }
        this.stats.baseSailEmpty = !this.hasStatement(null, null, null, true, new Resource[0]);
    }

    private MemoryStore getNewMemorySail() {
        MemoryStore sail = new MemoryStore();
        sail.setDefaultIsolationLevel((IsolationLevel)IsolationLevels.NONE);
        sail.init();
        return sail;
    }

    public void commit() throws SailException {
        if (!this.preparedHasRun) {
            this.prepare();
        }
        this.previousStateConnection.commit();
        super.commit();
        this.shapesConnection.commit();
        this.cleanup();
    }

    public void addStatement(UpdateContext modify, Resource subj, IRI pred, Value obj, Resource ... contexts) throws SailException {
        if (contexts.length == 1 && RDF4J.SHACL_SHAPE_GRAPH.equals((Object)contexts[0])) {
            this.shapesConnection.add(subj, pred, obj, new Resource[0]);
            this.isShapeRefreshNeeded = true;
        } else {
            super.addStatement(modify, subj, pred, obj, contexts);
        }
    }

    public void removeStatement(UpdateContext modify, Resource subj, IRI pred, Value obj, Resource ... contexts) throws SailException {
        if (contexts.length == 1 && RDF4J.SHACL_SHAPE_GRAPH.equals((Object)contexts[0])) {
            this.shapesConnection.remove(subj, pred, obj, new Resource[0]);
            this.isShapeRefreshNeeded = true;
        } else {
            super.removeStatement(modify, subj, pred, obj, contexts);
        }
    }

    public void addStatement(Resource subj, IRI pred, Value obj, Resource ... contexts) throws SailException {
        if (contexts.length == 1 && RDF4J.SHACL_SHAPE_GRAPH.equals((Object)contexts[0])) {
            this.shapesConnection.add(subj, pred, obj, new Resource[0]);
            this.isShapeRefreshNeeded = true;
        } else {
            super.addStatement(subj, pred, obj, contexts);
        }
    }

    public void removeStatements(Resource subj, IRI pred, Value obj, Resource ... contexts) throws SailException {
        if (contexts.length == 1 && contexts[0].equals(RDF4J.SHACL_SHAPE_GRAPH)) {
            this.shapesConnection.remove(subj, pred, obj, new Resource[0]);
            this.isShapeRefreshNeeded = true;
        } else {
            super.removeStatements(subj, pred, obj, contexts);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() throws SailException {
        ShaclSail shaclSail = this.sail;
        synchronized (shaclSail) {
            this.previousStateConnection.rollback();
            this.shapesConnection.rollback();
            super.rollback();
            this.cleanup();
            this.refreshShapes(this.shapesConnection);
        }
    }

    void cleanup() {
        logger.debug("Cleanup");
        this.connectionsToClose.forEach(SailConnection::close);
        this.connectionsToClose = new ConcurrentLinkedQueue();
        if (this.addedStatements != null) {
            this.addedStatements.shutDown();
            this.addedStatements = null;
        }
        if (this.removedStatements != null) {
            this.removedStatements.shutDown();
            this.removedStatements = null;
        }
        this.addedStatementsSet.clear();
        this.removedStatementsSet.clear();
        this.stats = null;
        this.preparedHasRun = false;
        this.isShapeRefreshNeeded = false;
        this.selectNodeCache = null;
    }

    private List<NodeShape> refreshShapes(SailRepositoryConnection shapesRepoConnection) {
        List<NodeShape> nodeShapes = this.sail.getNodeShapes();
        if (this.isShapeRefreshNeeded) {
            nodeShapes = this.sail.refreshShapes(shapesRepoConnection);
            this.isShapeRefreshNeeded = false;
        }
        return nodeShapes;
    }

    private List<Tuple> validate() {
        if (!this.sail.isValidationEnabled()) {
            return Collections.emptyList();
        }
        if (this.sail.isRdfsSubClassReasoning()) {
            this.rdfsSubClassOfReasoner = RdfsSubClassOfReasoner.createReasoner(this);
        }
        try {
            this.validating = true;
            this.fillAddedAndRemovedStatementRepositories();
            try {
                Stream planNodeStream = this.sail.getNodeShapes().stream().flatMap(nodeShape -> nodeShape.generatePlans(this, (NodeShape)nodeShape, this.sail.isLogValidationPlans()).stream());
                if (this.sail.isParallelValidation()) {
                    planNodeStream = (Stream)planNodeStream.parallel();
                }
                List<Tuple> list = planNodeStream.flatMap(planNode -> {
                    try (Stream stream = Iterations.stream(planNode.iterator());){
                        boolean valid;
                        if (LoggingNode.loggingEnabled) {
                            PropertyShape propertyShape = ((EnrichWithShape)planNode).getPropertyShape();
                            logger.info("Start execution of plan " + propertyShape.getNodeShape().toString() + " : " + propertyShape.getId());
                        }
                        List collect = stream.collect(Collectors.toList());
                        if (LoggingNode.loggingEnabled) {
                            PropertyShape propertyShape = ((EnrichWithShape)planNode).getPropertyShape();
                            logger.info("Finished execution of plan {} : {}", (Object)propertyShape.getNodeShape().toString(), (Object)propertyShape.getId());
                        }
                        boolean bl = valid = collect.size() == 0;
                        if (!valid && this.sail.isLogValidationViolations()) {
                            PropertyShape propertyShape = ((EnrichWithShape)planNode).getPropertyShape();
                            logger.info("SHACL not valid. The following experimental debug results were produced: \n\tNodeShape: {}\n\tPropertyShape: {} \n\t\t{}", new Object[]{propertyShape.getNodeShape().getId(), propertyShape.getId(), collect.stream().map(a -> a.toString() + " -cause-> " + a.getCause()).collect(Collectors.joining("\n\t\t"))});
                        }
                        Stream stream2 = collect.stream();
                        return stream2;
                    }
                }).collect(Collectors.toList());
                this.connectionsToClose.forEach(SailConnection::close);
                this.connectionsToClose = new ConcurrentLinkedQueue();
                return list;
            }
            catch (Throwable throwable) {
                this.connectionsToClose.forEach(SailConnection::close);
                this.connectionsToClose = new ConcurrentLinkedQueue();
                throw throwable;
            }
        }
        finally {
            this.validating = false;
            this.rdfsSubClassOfReasoner = null;
        }
    }

    void fillAddedAndRemovedStatementRepositories() {
        this.connectionsToClose.forEach(SailConnection::close);
        this.connectionsToClose = new ConcurrentLinkedQueue();
        if (this.addedStatements != null) {
            this.addedStatements.shutDown();
            this.addedStatements = null;
        }
        if (this.removedStatements != null) {
            this.removedStatements.shutDown();
            this.removedStatements = null;
        }
        this.addedStatements = this.getNewMemorySail();
        this.removedStatements = this.getNewMemorySail();
        this.addedStatementsSet.forEach(this.stats::added);
        this.removedStatementsSet.forEach(this.stats::removed);
        try (NotifyingSailConnection connection = this.addedStatements.getConnection();){
            connection.begin((IsolationLevel)IsolationLevels.NONE);
            this.addedStatementsSet.stream().filter(statement -> !this.removedStatementsSet.contains(statement)).flatMap(statement -> this.rdfsSubClassOfReasoner == null ? Stream.of(statement) : this.rdfsSubClassOfReasoner.forwardChain((Statement)statement)).forEach(arg_0 -> ShaclSailConnection.lambda$fillAddedAndRemovedStatementRepositories$5((SailConnection)connection, arg_0));
            connection.commit();
        }
        connection = this.removedStatements.getConnection();
        var2_2 = null;
        try {
            connection.begin((IsolationLevel)IsolationLevels.NONE);
            this.removedStatementsSet.stream().filter(statement -> !this.addedStatementsSet.contains(statement)).flatMap(statement -> this.rdfsSubClassOfReasoner == null ? Stream.of(statement) : this.rdfsSubClassOfReasoner.forwardChain((Statement)statement)).forEach(arg_0 -> ShaclSailConnection.lambda$fillAddedAndRemovedStatementRepositories$8((SailConnection)connection, arg_0));
            connection.commit();
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (connection != null) {
                if (var2_2 != null) {
                    try {
                        connection.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    connection.close();
                }
            }
        }
        this.selectNodeCache = new HashMap<Select, BufferedSplitter>();
    }

    public synchronized void close() throws SailException {
        if (this.isActive()) {
            this.rollback();
        }
        this.shapesConnection.close();
        this.previousStateConnection.close();
        super.close();
        this.connectionsToClose.forEach(SailConnection::close);
        this.connectionsToClose = new ConcurrentLinkedQueue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepare() throws SailException {
        try {
            this.preparedHasRun = true;
            List<NodeShape> nodeShapes = this.refreshShapes(this.shapesConnection);
            if (this.addedStatementsSet.isEmpty() && this.removedStatementsSet.isEmpty()) {
                logger.debug("Nothing has changed, nothing to validate.");
                return;
            }
            if (!(this.sail.isIgnoreNoShapesLoadedException() || this.addedStatementsSet.isEmpty() && this.removedStatementsSet.isEmpty() || !nodeShapes.isEmpty())) {
                throw new NoShapesLoadedException();
            }
            List<Tuple> invalidTuples = this.validate();
            boolean valid = invalidTuples.isEmpty();
            if (!valid) {
                throw new ShaclSailValidationException(invalidTuples);
            }
        }
        finally {
            super.prepare();
            this.previousStateConnection.prepare();
        }
    }

    public void statementAdded(Statement statement) {
        if (this.preparedHasRun) {
            throw new IllegalStateException("Detected changes after prepare() has been called.");
        }
        boolean add = this.addedStatementsSet.add(statement);
        if (!add) {
            this.removedStatementsSet.remove(statement);
        }
    }

    public void statementRemoved(Statement statement) {
        if (this.preparedHasRun) {
            throw new IllegalStateException("Detected changes after prepare() has been called.");
        }
        boolean add = this.removedStatementsSet.add(statement);
        if (!add) {
            this.addedStatementsSet.remove(statement);
        }
    }

    public synchronized PlanNode getCachedNodeFor(Select select) {
        if (!this.sail.isCacheSelectNodes()) {
            return select;
        }
        BufferedSplitter bufferedSplitter = this.selectNodeCache.computeIfAbsent(select, BufferedSplitter::new);
        return bufferedSplitter.getPlanNode();
    }

    public RdfsSubClassOfReasoner getRdfsSubClassOfReasoner() {
        return this.rdfsSubClassOfReasoner;
    }

    public CloseableIteration<? extends Statement, SailException> getStatements(Resource subj, IRI pred, final Value obj, boolean includeInferred, Resource ... contexts) throws SailException {
        Set<Resource> inferredTypes;
        if (this.rdfsSubClassOfReasoner != null && includeInferred && this.validating && obj instanceof Resource && RDF.TYPE.equals((Object)pred) && !(inferredTypes = this.rdfsSubClassOfReasoner.backwardsChain((Resource)obj)).isEmpty()) {
            final CloseableIteration[] statementsMatchingInferredTypes = (CloseableIteration[])inferredTypes.stream().map(r -> super.getStatements(subj, pred, (Value)r, false, contexts)).toArray(CloseableIteration[]::new);
            return new CloseableIteration<Statement, SailException>(){
                UnionIteration<Statement, SailException> unionIteration;
                Statement next;
                HashSet<Statement> dedupe;
                {
                    this.unionIteration = new UnionIteration((Iteration[])statementsMatchingInferredTypes);
                    this.next = null;
                    this.dedupe = new HashSet();
                }

                private void calculateNext() {
                    if (this.next != null) {
                        return;
                    }
                    while (this.next == null && this.unionIteration.hasNext()) {
                        Statement temp = (Statement)this.unionIteration.next();
                        temp = SimpleValueFactory.getInstance().createStatement(temp.getSubject(), temp.getPredicate(), obj, temp.getContext());
                        if (!this.dedupe.isEmpty()) {
                            boolean contains = this.dedupe.contains(temp);
                            if (contains) continue;
                            this.next = temp;
                            this.dedupe.add(this.next);
                            continue;
                        }
                        this.next = temp;
                        this.dedupe.add(this.next);
                    }
                }

                public boolean hasNext() throws SailException {
                    this.calculateNext();
                    return this.next != null;
                }

                public Statement next() throws SailException {
                    this.calculateNext();
                    Statement temp = this.next;
                    this.next = null;
                    return temp;
                }

                public void remove() throws SailException {
                    this.unionIteration.remove();
                }

                public void close() throws SailException {
                    this.unionIteration.close();
                }
            };
        }
        return super.getStatements(subj, pred, obj, includeInferred, contexts);
    }

    public boolean hasStatement(Resource subj, IRI pred, Value obj, boolean includeInferred, Resource ... contexts) throws SailException {
        boolean hasStatement = super.hasStatement(subj, pred, obj, includeInferred, contexts);
        if (this.rdfsSubClassOfReasoner != null && includeInferred && this.validating && obj instanceof Resource && RDF.TYPE.equals((Object)pred)) {
            return hasStatement | this.rdfsSubClassOfReasoner.backwardsChain((Resource)obj).stream().map(type -> super.hasStatement(subj, pred, (Value)type, false, contexts)).reduce((a, b) -> a != false || b != false).orElse(false);
        }
        return hasStatement;
    }

    private static /* synthetic */ void lambda$fillAddedAndRemovedStatementRepositories$8(SailConnection connection, Statement statement) {
        connection.addStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[]{statement.getContext()});
    }

    private static /* synthetic */ void lambda$fillAddedAndRemovedStatementRepositories$5(SailConnection connection, Statement statement) {
        connection.addStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[]{statement.getContext()});
    }

    public class Stats {
        boolean baseSailEmpty;
        boolean hasAdded;
        boolean hasRemoved;

        public void added(Statement statement) {
            this.hasAdded = true;
        }

        public void removed(Statement statement) {
            this.hasRemoved = true;
        }

        public boolean hasAdded() {
            return this.hasAdded;
        }

        public boolean hasRemoved() {
            return this.hasRemoved;
        }

        public boolean isBaseSailEmpty() {
            return this.baseSailEmpty;
        }
    }
}

