/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.AST;

import java.util.Set;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.repository.sail.SailRepositoryConnection;
import org.eclipse.rdf4j.sail.NotifyingSailConnection;
import org.eclipse.rdf4j.sail.SailConnection;
import org.eclipse.rdf4j.sail.shacl.AST.NodeShape;
import org.eclipse.rdf4j.sail.shacl.RdfsSubClassOfReasoner;
import org.eclipse.rdf4j.sail.shacl.ShaclSailConnection;
import org.eclipse.rdf4j.sail.shacl.planNodes.ExternalTypeFilterNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.LoggingNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.Select;
import org.eclipse.rdf4j.sail.shacl.planNodes.TrimTuple;

public class TargetClass
extends NodeShape {
    private final Resource targetClass;

    TargetClass(Resource id, SailRepositoryConnection connection, Resource targetClass) {
        super(id, connection);
        this.targetClass = targetClass;
    }

    @Override
    public PlanNode getPlan(ShaclSailConnection shaclSailConnection, NodeShape nodeShape, boolean printPlans, PlanNode overrideTargetNode) {
        PlanNode parent = shaclSailConnection.getCachedNodeFor(new Select((SailConnection)shaclSailConnection, this.getQuery("?a", "?c", shaclSailConnection.getRdfsSubClassOfReasoner())));
        return new TrimTuple(new LoggingNode(parent, ""), 0, 1);
    }

    @Override
    public PlanNode getPlanAddedStatements(ShaclSailConnection shaclSailConnection, NodeShape nodeShape) {
        PlanNode cachedNodeFor = shaclSailConnection.getCachedNodeFor(new Select(shaclSailConnection.getAddedStatements(), this.getQuery("?a", "?c", null)));
        return new TrimTuple(new LoggingNode(cachedNodeFor, ""), 0, 1);
    }

    @Override
    public PlanNode getPlanRemovedStatements(ShaclSailConnection shaclSailConnection, NodeShape nodeShape) {
        PlanNode parent = shaclSailConnection.getCachedNodeFor(new Select(shaclSailConnection.getRemovedStatements(), this.getQuery("?a", "?c", null)));
        return new TrimTuple(parent, 0, 1);
    }

    @Override
    public boolean requiresEvaluation(SailConnection addedStatements, SailConnection removedStatements) {
        return addedStatements.hasStatement(null, RDF.TYPE, (Value)this.targetClass, false, new Resource[0]);
    }

    @Override
    public String getQuery(String subjectVariable, String objectVariable, RdfsSubClassOfReasoner rdfsSubClassOfReasoner) {
        Set<Resource> resources;
        if (rdfsSubClassOfReasoner != null && (resources = rdfsSubClassOfReasoner.backwardsChain(this.targetClass)).size() > 1) {
            return resources.stream().map(r -> "{ BIND(rdf:type as ?b1) \n BIND(<" + r + "> as " + objectVariable + ") \n " + subjectVariable + " ?b1 " + objectVariable + ". } \n").reduce((l, r) -> l + " UNION " + r).get();
        }
        return "BIND(rdf:type as ?b1) \n BIND(<" + this.targetClass + "> as " + objectVariable + ") \n " + subjectVariable + " ?b1 " + objectVariable + ". \n";
    }

    @Override
    public PlanNode getTargetFilter(NotifyingSailConnection shaclSailConnection, PlanNode parent) {
        return new ExternalTypeFilterNode((SailConnection)shaclSailConnection, this.targetClass, parent, 0, true);
    }
}

