/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.AST;

import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.repository.sail.SailRepositoryConnection;
import org.eclipse.rdf4j.sail.NotifyingSailConnection;
import org.eclipse.rdf4j.sail.SailConnection;
import org.eclipse.rdf4j.sail.shacl.AST.NodeShape;
import org.eclipse.rdf4j.sail.shacl.AST.PathPropertyShape;
import org.eclipse.rdf4j.sail.shacl.ShaclSailConnection;
import org.eclipse.rdf4j.sail.shacl.SourceConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.planNodes.BulkedExternalLeftOuterJoin;
import org.eclipse.rdf4j.sail.shacl.planNodes.EnrichWithShape;
import org.eclipse.rdf4j.sail.shacl.planNodes.GroupByCount;
import org.eclipse.rdf4j.sail.shacl.planNodes.LoggingNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.MinCountFilter;
import org.eclipse.rdf4j.sail.shacl.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.TrimTuple;
import org.eclipse.rdf4j.sail.shacl.planNodes.UnBufferedPlanNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.UnionNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.Unique;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MinCountPropertyShape
extends PathPropertyShape {
    private long minCount;
    private static final Logger logger = LoggerFactory.getLogger(MinCountPropertyShape.class);
    private boolean optimizeWhenNoStatementsRemoved = true;

    MinCountPropertyShape(Resource id, SailRepositoryConnection connection, NodeShape nodeShape, Long minCount) {
        super(id, connection, nodeShape);
        this.minCount = minCount;
    }

    public String toString() {
        return "MinCountPropertyShape{minCount=" + this.minCount + '}';
    }

    @Override
    public PlanNode getPlan(ShaclSailConnection shaclSailConnection, NodeShape nodeShape, boolean printPlans, PlanNode overrideTargetNode) {
        LoggingNode topNode;
        if (overrideTargetNode != null) {
            LoggingNode allStatements = new LoggingNode(new BulkedExternalLeftOuterJoin(overrideTargetNode, (SailConnection)shaclSailConnection, this.path.getQuery("?a", "?c", null), false), "");
            LoggingNode groupBy = new LoggingNode(new GroupByCount(allStatements), "");
            PlanNode filteredStatements = new MinCountFilter(groupBy, this.minCount).getFalseNode(UnBufferedPlanNode.class);
            if (printPlans) {
                String planAsGraphvizDot = this.getPlanAsGraphvizDot(filteredStatements, shaclSailConnection);
                logger.info(planAsGraphvizDot);
            }
            return new EnrichWithShape(new LoggingNode(filteredStatements, ""), this);
        }
        if (!this.optimizeWhenNoStatementsRemoved || shaclSailConnection.stats.hasRemoved()) {
            LoggingNode planRemovedStatements = new LoggingNode(new TrimTuple(new LoggingNode(super.getPlanRemovedStatements(shaclSailConnection, nodeShape), ""), 0, 1), "");
            LoggingNode filteredPlanRemovedStatements = new LoggingNode(nodeShape.getTargetFilter((NotifyingSailConnection)shaclSailConnection, planRemovedStatements), "");
            LoggingNode planAddedStatements = new LoggingNode(nodeShape.getPlanAddedStatements(shaclSailConnection, nodeShape), "");
            LoggingNode mergeNode = new LoggingNode(new UnionNode(planAddedStatements, filteredPlanRemovedStatements), "");
            LoggingNode unique = new LoggingNode(new Unique(mergeNode), "");
            PlanNode planAddedStatements1 = super.getPlanAddedStatements(shaclSailConnection, nodeShape);
            planAddedStatements1 = new LoggingNode(nodeShape.getTargetFilter((NotifyingSailConnection)shaclSailConnection, planAddedStatements1), "");
            topNode = new LoggingNode(new UnionNode(unique, planAddedStatements1), "");
        } else {
            LoggingNode planAddedForShape = new LoggingNode(nodeShape.getPlanAddedStatements(shaclSailConnection, nodeShape), "");
            LoggingNode addedByPath = new LoggingNode(this.getPlanAddedStatements(shaclSailConnection, nodeShape), "");
            addedByPath = new LoggingNode(nodeShape.getTargetFilter((NotifyingSailConnection)shaclSailConnection, addedByPath), "");
            topNode = new LoggingNode(new UnionNode(planAddedForShape, addedByPath), "");
        }
        LoggingNode groupBy = new LoggingNode(new GroupByCount(topNode), "");
        PlanNode filteredStatements = new MinCountFilter(groupBy, this.minCount).getFalseNode(UnBufferedPlanNode.class);
        LoggingNode minCountFilter = new LoggingNode(filteredStatements, "");
        LoggingNode trimTuple = new LoggingNode(new TrimTuple(minCountFilter, 0, 1), "");
        LoggingNode bulkedExternalLeftOuterJoin2 = new LoggingNode(new BulkedExternalLeftOuterJoin(trimTuple, (SailConnection)shaclSailConnection, this.path.getQuery("?a", "?c", null), false), "");
        LoggingNode groupBy2 = new LoggingNode(new GroupByCount(bulkedExternalLeftOuterJoin2), "");
        PlanNode filteredStatements2 = new MinCountFilter(groupBy2, this.minCount).getFalseNode(UnBufferedPlanNode.class);
        if (printPlans) {
            String planAsGraphvizDot = this.getPlanAsGraphvizDot(filteredStatements2, shaclSailConnection);
            logger.info(planAsGraphvizDot);
        }
        return new EnrichWithShape(new LoggingNode(filteredStatements2, ""), this);
    }

    @Override
    public SourceConstraintComponent getSourceConstraintComponent() {
        return SourceConstraintComponent.MinCountConstraintComponent;
    }
}

