/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.planNodes;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.shacl.planNodes.IteratorData;
import org.eclipse.rdf4j.sail.shacl.planNodes.LoggingNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.ParentProvider;
import org.eclipse.rdf4j.sail.shacl.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.PushBasedPlanNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.SupportsParentProvider;
import org.eclipse.rdf4j.sail.shacl.planNodes.Tuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PushBasedLoggingNode
implements SupportsParentProvider,
PushBasedPlanNode,
PlanNode {
    private static final Logger logger = LoggerFactory.getLogger(PushBasedLoggingNode.class);
    private final PushBasedPlanNode parent;
    private List<PlanNode> parents;

    public PushBasedLoggingNode(PushBasedPlanNode parent) {
        this.parent = parent;
    }

    @Override
    public CloseableIteration<Tuple, SailException> iterator() {
        throw new IllegalStateException();
    }

    @Override
    public int depth() {
        return ((PlanNode)((Object)this.parent)).depth();
    }

    @Override
    public void getPlanAsGraphvizDot(StringBuilder stringBuilder) {
        ((PlanNode)((Object)this.parent)).getPlanAsGraphvizDot(stringBuilder);
    }

    @Override
    public String getId() {
        return ((PlanNode)((Object)this.parent)).getId();
    }

    @Override
    public IteratorData getIteratorDataType() {
        return ((PlanNode)((Object)this.parent)).getIteratorDataType();
    }

    @Override
    public void push(Tuple t) {
        if (LoggingNode.loggingEnabled) {
            logger.info(this.leadingSpace() + this.parent.getClass().getSimpleName() + ".next():  " + t.toString());
        }
        this.parent.push(t);
    }

    @Override
    public void parentIterator(CloseableIteration<Tuple, SailException> iterator) {
        this.parent.parentIterator(iterator);
    }

    @Override
    public void receiveParentProvider(ParentProvider parentProvider) {
        this.parents = parentProvider.parent();
        ((SupportsParentProvider)((Object)this.parent)).receiveParentProvider(parentProvider);
    }

    private String leadingSpace() {
        return StringUtils.leftPad((String)"", (int)this.depth(), (String)"    ");
    }
}

