/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.planNodes;

import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.sail.shacl.AST.NodeKindPropertyShape;
import org.eclipse.rdf4j.sail.shacl.planNodes.FilterPlanNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.PushBasedPlanNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.Tuple;

public class NodeKindFilter
extends FilterPlanNode {
    private final NodeKindPropertyShape.NodeKind nodeKind;

    public NodeKindFilter(PlanNode parent, PushBasedPlanNode trueNode, PushBasedPlanNode falseNode, NodeKindPropertyShape.NodeKind nodeKind) {
        super(parent, trueNode, falseNode);
        this.nodeKind = nodeKind;
    }

    @Override
    boolean checkTuple(Tuple t) {
        Value value = t.line.get(1);
        switch (this.nodeKind) {
            case IRI: {
                return value instanceof IRI;
            }
            case Literal: {
                return value instanceof Literal;
            }
            case BlankNode: {
                return value instanceof BNode;
            }
            case IRIOrLiteral: {
                return value instanceof IRI || value instanceof Literal;
            }
            case BlankNodeOrIRI: {
                return value instanceof BNode || value instanceof IRI;
            }
            case BlankNodeOrLiteral: {
                return value instanceof BNode || value instanceof Literal;
            }
        }
        throw new IllegalStateException("Unknown nodeKind");
    }

    @Override
    public String toString() {
        return "NodeKindFilter{nodeKind=" + (Object)((Object)this.nodeKind) + '}';
    }
}

