/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.planNodes;

import java.math.BigDecimal;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.sail.shacl.planNodes.FilterPlanNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.PushBasedPlanNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.Tuple;

public class MinExclusiveFilter
extends FilterPlanNode {
    private final BigDecimal min;

    public MinExclusiveFilter(PlanNode parent, PushBasedPlanNode trueNode, PushBasedPlanNode falseNode, BigDecimal min) {
        super(parent, trueNode, falseNode);
        this.min = min;
    }

    @Override
    boolean checkTuple(Tuple t) {
        Value literal = t.line.get(1);
        if (literal instanceof Literal) {
            BigDecimal bigDecimal = ((Literal)literal).decimalValue();
            return this.min.compareTo(bigDecimal) < 0;
        }
        return false;
    }

    @Override
    public String toString() {
        return "MinLengthFilter{min=" + this.min + '}';
    }
}

