/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.planNodes;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.shacl.planNodes.LoggingNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.ParentProvider;
import org.eclipse.rdf4j.sail.shacl.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.PushBasedPlanNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.SupportsParentProvider;
import org.eclipse.rdf4j.sail.shacl.planNodes.Tuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FilterPlanNode<T extends PushBasedPlanNode & SupportsParentProvider>
implements ParentProvider {
    private static final Logger logger = LoggerFactory.getLogger(FilterPlanNode.class);
    PlanNode parent;
    T trueNode;
    T falseNode;
    boolean printed = false;

    abstract boolean checkTuple(Tuple var1);

    public FilterPlanNode(PlanNode parent, T trueNode, T falseNode) {
        this.parent = parent;
        this.trueNode = trueNode;
        this.falseNode = falseNode;
        this.initialize(trueNode, falseNode);
    }

    private void initialize(T trueNode, T falseNode) {
        CloseableIteration<Tuple, SailException> iterator = this.iterator();
        if (trueNode != null) {
            trueNode.parentIterator(iterator);
            ((SupportsParentProvider)trueNode).receiveParentProvider(this);
        }
        if (falseNode != null) {
            falseNode.parentIterator(iterator);
            ((SupportsParentProvider)falseNode).receiveParentProvider(this);
        }
    }

    private CloseableIteration<Tuple, SailException> iterator() {
        final FilterPlanNode that = this;
        return new CloseableIteration<Tuple, SailException>(){
            CloseableIteration<Tuple, SailException> parentIterator;
            Tuple next;
            boolean closed = false;

            private void calculateNext() {
                if (this.parentIterator == null) {
                    this.parentIterator = FilterPlanNode.this.parent.iterator();
                }
                if (this.next != null) {
                    return;
                }
                while (this.parentIterator.hasNext() && this.next == null) {
                    Tuple temp = (Tuple)this.parentIterator.next();
                    if (FilterPlanNode.this.checkTuple(temp)) {
                        if (FilterPlanNode.this.trueNode != null) {
                            if (LoggingNode.loggingEnabled) {
                                logger.info(FilterPlanNode.this.leadingSpace() + that.getClass().getSimpleName() + ";trueNode:  " + temp.toString());
                            }
                            FilterPlanNode.this.trueNode.push(temp);
                        }
                    } else if (FilterPlanNode.this.falseNode != null) {
                        if (LoggingNode.loggingEnabled) {
                            logger.info(FilterPlanNode.this.leadingSpace() + that.getClass().getSimpleName() + ";falseNode:  " + temp.toString());
                        }
                        FilterPlanNode.this.falseNode.push(temp);
                    }
                    this.next = temp;
                }
            }

            public void close() throws SailException {
                if (this.closed) {
                    return;
                }
                this.closed = true;
                if (this.parentIterator != null) {
                    this.parentIterator.close();
                }
            }

            public boolean hasNext() throws SailException {
                this.calculateNext();
                if (this.next == null) {
                    this.close();
                }
                return this.next != null;
            }

            public Tuple next() throws SailException {
                Tuple temp = this.next;
                this.next = null;
                return temp;
            }

            public void remove() throws SailException {
            }
        };
    }

    @Override
    public List<PlanNode> parent() {
        return Arrays.asList(this.parent);
    }

    public void getPlanAsGraphvizDot(StringBuilder stringBuilder) {
        String id;
        if (this.printed) {
            return;
        }
        this.printed = true;
        stringBuilder.append(this.getId() + " [label=\"" + StringEscapeUtils.escapeJava((String)this.toString()) + "\"];").append("\n");
        stringBuilder.append(this.parent.getId() + " -> " + this.getId()).append("\n");
        if (this.trueNode != null) {
            id = this.getId(this.trueNode);
            stringBuilder.append(this.getId() + " -> " + id + " [label=\"true values\"]").append("\n");
        }
        if (this.falseNode != null) {
            id = this.getId(this.falseNode);
            stringBuilder.append(this.getId() + " -> " + id + " [label=\"false values\"]").append("\n");
        }
        this.parent.getPlanAsGraphvizDot(stringBuilder);
    }

    private String getId(T node) {
        if (node instanceof PlanNode) {
            return ((PlanNode)node).getId();
        }
        return System.identityHashCode(node) + "";
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public String getId() {
        return System.identityHashCode(this) + "";
    }

    private String leadingSpace() {
        return StringUtils.leftPad((String)"", (int)(this.parent.depth() + 1), (String)"    ");
    }
}

