/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.planNodes;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringEscapeUtils;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.algebra.BindingSetAssignment;
import org.eclipse.rdf4j.query.algebra.QueryModelVisitor;
import org.eclipse.rdf4j.query.algebra.helpers.AbstractQueryModelVisitor;
import org.eclipse.rdf4j.query.impl.ListBindingSet;
import org.eclipse.rdf4j.query.impl.MapBindingSet;
import org.eclipse.rdf4j.query.parser.ParsedQuery;
import org.eclipse.rdf4j.query.parser.QueryParserFactory;
import org.eclipse.rdf4j.query.parser.QueryParserRegistry;
import org.eclipse.rdf4j.sail.SailConnection;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.memory.MemoryStoreConnection;
import org.eclipse.rdf4j.sail.shacl.ShaclSailConnection;
import org.eclipse.rdf4j.sail.shacl.planNodes.IteratorData;
import org.eclipse.rdf4j.sail.shacl.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.Tuple;
import org.eclipse.rdf4j.sail.shacl.planNodes.TupleHelper;

public class BulkedExternalLeftOuterJoin
implements PlanNode {
    private final SailConnection connection;
    private final PlanNode leftNode;
    private final ParsedQuery parsedQuery;
    private final boolean skipBasedOnPreviousConnection;
    private boolean printed = false;

    public BulkedExternalLeftOuterJoin(PlanNode leftNode, SailConnection connection, String query, boolean skipBasedOnPreviousConnection) {
        this.leftNode = leftNode;
        QueryParserFactory queryParserFactory = (QueryParserFactory)QueryParserRegistry.getInstance().get((Object)QueryLanguage.SPARQL).get();
        this.parsedQuery = queryParserFactory.getParser().parseQuery("select * where { VALUES (?a) {}" + query + "} order by ?a", null);
        this.connection = connection;
        this.skipBasedOnPreviousConnection = skipBasedOnPreviousConnection;
    }

    @Override
    public CloseableIteration<Tuple, SailException> iterator() {
        return new CloseableIteration<Tuple, SailException>(){
            LinkedList<Tuple> left = new LinkedList();
            LinkedList<Tuple> right = new LinkedList();
            CloseableIteration<Tuple, SailException> leftNodeIterator = BulkedExternalLeftOuterJoin.access$000(BulkedExternalLeftOuterJoin.this).iterator();

            private void calculateNext() {
                if (!this.left.isEmpty()) {
                    return;
                }
                while (this.left.size() < 100 && this.leftNodeIterator.hasNext()) {
                    this.left.addFirst((Tuple)this.leftNodeIterator.next());
                }
                if (this.left.isEmpty()) {
                    return;
                }
                final List newBindindingset = this.left.stream().map(tuple -> tuple.line.get(0)).map(v -> (Resource)v).filter(r -> {
                    if (!BulkedExternalLeftOuterJoin.this.skipBasedOnPreviousConnection) {
                        return true;
                    }
                    if (BulkedExternalLeftOuterJoin.this.connection instanceof ShaclSailConnection) {
                        return ((ShaclSailConnection)BulkedExternalLeftOuterJoin.this.connection).getPreviousStateConnection().hasStatement(r, null, null, true, new Resource[0]);
                    }
                    return true;
                }).map(r -> new ListBindingSet(Collections.singletonList("a"), Collections.singletonList(r))).collect(Collectors.toList());
                if (!newBindindingset.isEmpty()) {
                    try {
                        BulkedExternalLeftOuterJoin.this.parsedQuery.getTupleExpr().visitChildren((QueryModelVisitor)new AbstractQueryModelVisitor<Exception>(){

                            public void meet(BindingSetAssignment node) throws Exception {
                                node.setBindingSets((Iterable)newBindindingset);
                            }
                        });
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                    try (CloseableIteration evaluate = BulkedExternalLeftOuterJoin.this.connection.evaluate(BulkedExternalLeftOuterJoin.this.parsedQuery.getTupleExpr(), null, (BindingSet)new MapBindingSet(), true);){
                        while (evaluate.hasNext()) {
                            BindingSet next = (BindingSet)evaluate.next();
                            this.right.addFirst(new Tuple(next));
                        }
                    }
                }
            }

            public void close() throws SailException {
                this.leftNodeIterator.close();
            }

            public boolean hasNext() throws SailException {
                this.calculateNext();
                return !this.left.isEmpty();
            }

            public Tuple next() throws SailException {
                this.calculateNext();
                if (!this.left.isEmpty()) {
                    Tuple leftPeek = this.left.peekLast();
                    Tuple joined = null;
                    if (!this.right.isEmpty()) {
                        Tuple rightPeek = this.right.peekLast();
                        if (rightPeek.line.get(0) == leftPeek.line.get(0) || rightPeek.line.get(0).equals(leftPeek.line.get(0))) {
                            joined = TupleHelper.join(leftPeek, rightPeek);
                            this.right.removeLast();
                            Tuple rightPeek2 = this.right.peekLast();
                            if (rightPeek2 == null || !rightPeek2.line.get(0).equals(leftPeek.line.get(0))) {
                                this.left.removeLast();
                            }
                        }
                    }
                    if (joined != null) {
                        return joined;
                    }
                    this.left.removeLast();
                    return leftPeek;
                }
                return null;
            }

            public void remove() throws SailException {
            }
        };
    }

    @Override
    public int depth() {
        return this.leftNode.depth() + 1;
    }

    @Override
    public void getPlanAsGraphvizDot(StringBuilder stringBuilder) {
        if (this.printed) {
            return;
        }
        this.printed = true;
        stringBuilder.append(this.getId() + " [label=\"" + StringEscapeUtils.escapeJava((String)this.toString()) + "\"];").append("\n");
        this.leftNode.getPlanAsGraphvizDot(stringBuilder);
        if (this.connection instanceof MemoryStoreConnection) {
            stringBuilder.append(System.identityHashCode(((MemoryStoreConnection)this.connection).getSail()) + " -> " + this.getId() + " [label=\"right\"]").append("\n");
        } else {
            stringBuilder.append(System.identityHashCode(this.connection) + " -> " + this.getId() + " [label=\"right\"]").append("\n");
        }
        stringBuilder.append(this.leftNode.getId() + " -> " + this.getId() + " [label=\"left\"]").append("\n");
    }

    public String toString() {
        return "BulkedExternalLeftOuterJoin{parsedQuery=" + this.parsedQuery.getSourceString() + '}';
    }

    @Override
    public String getId() {
        return System.identityHashCode(this) + "";
    }

    @Override
    public IteratorData getIteratorDataType() {
        return this.leftNode.getIteratorDataType();
    }

    static /* synthetic */ PlanNode access$000(BulkedExternalLeftOuterJoin x0) {
        return x0.leftNode;
    }
}

