/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.AST;

import java.util.Set;
import java.util.stream.Stream;
import org.eclipse.rdf4j.common.iteration.Iteration;
import org.eclipse.rdf4j.common.iteration.Iterations;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.model.vocabulary.SHACL;
import org.eclipse.rdf4j.repository.sail.SailRepositoryConnection;
import org.eclipse.rdf4j.sail.NotifyingSailConnection;
import org.eclipse.rdf4j.sail.SailConnection;
import org.eclipse.rdf4j.sail.shacl.AST.NodeShape;
import org.eclipse.rdf4j.sail.shacl.RdfsSubClassOfReasoner;
import org.eclipse.rdf4j.sail.shacl.ShaclSailConnection;
import org.eclipse.rdf4j.sail.shacl.planNodes.ExternalTypeFilterNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.LoggingNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.Select;
import org.eclipse.rdf4j.sail.shacl.planNodes.TrimTuple;

public class TargetClass
extends NodeShape {
    Resource targetClass;

    TargetClass(Resource id, SailRepositoryConnection connection) {
        super(id, connection);
        try (Stream stream = Iterations.stream((Iteration)connection.getStatements(id, SHACL.TARGET_CLASS, null, new Resource[0]));){
            this.targetClass = stream.map(Statement::getObject).map(v -> (Resource)v).findAny().orElseThrow(() -> new RuntimeException("Expected to find sh:targetClass on " + id));
        }
    }

    @Override
    public PlanNode getPlan(ShaclSailConnection shaclSailConnection, NodeShape nodeShape, boolean printPlans, PlanNode overrideTargetNode) {
        return new TrimTuple(new LoggingNode(new Select((SailConnection)shaclSailConnection, this.getQuery("?a", "?c", shaclSailConnection.getRdfsSubClassOfReasoner())), ""), 0, 1);
    }

    @Override
    public PlanNode getPlanAddedStatements(ShaclSailConnection shaclSailConnection, NodeShape nodeShape) {
        return new TrimTuple(new LoggingNode(new Select(shaclSailConnection.getAddedStatements(), this.getQuery("?a", "?c", null)), ""), 0, 1);
    }

    @Override
    public PlanNode getPlanRemovedStatements(ShaclSailConnection shaclSailConnection, NodeShape nodeShape) {
        return new Select(shaclSailConnection.getRemovedStatements(), this.getQuery("?a", "?c", null));
    }

    @Override
    public boolean requiresEvaluation(SailConnection addedStatements, SailConnection removedStatements) {
        return addedStatements.hasStatement(null, RDF.TYPE, (Value)this.targetClass, false, new Resource[0]);
    }

    @Override
    public String getQuery(String subjectVariable, String objectVariable, RdfsSubClassOfReasoner rdfsSubClassOfReasoner) {
        Set<Resource> resources;
        if (rdfsSubClassOfReasoner != null && (resources = rdfsSubClassOfReasoner.backwardsChain(this.targetClass)).size() > 1) {
            return resources.stream().map(r -> "{ BIND(rdf:type as ?b1) \n BIND(<" + r + "> as " + objectVariable + ") \n " + subjectVariable + " ?b1 " + objectVariable + ". } \n").reduce((l, r) -> l + " UNION " + r).get();
        }
        return "BIND(rdf:type as ?b1) \n BIND(<" + this.targetClass + "> as " + objectVariable + ") \n " + subjectVariable + " ?b1 " + objectVariable + ". \n";
    }

    public PlanNode getTypeFilterPlan(NotifyingSailConnection shaclSailConnection, PlanNode parent) {
        return new ExternalTypeFilterNode((SailConnection)shaclSailConnection, this.targetClass, parent, 0, true);
    }
}

