/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.AST;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.repository.sail.SailRepositoryConnection;
import org.eclipse.rdf4j.sail.SailConnection;
import org.eclipse.rdf4j.sail.shacl.AST.NodeShape;
import org.eclipse.rdf4j.sail.shacl.AST.Path;
import org.eclipse.rdf4j.sail.shacl.AST.PropertyShape;
import org.eclipse.rdf4j.sail.shacl.ShaclSailConnection;
import org.eclipse.rdf4j.sail.shacl.SourceConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.planNodes.BufferedSplitter;
import org.eclipse.rdf4j.sail.shacl.planNodes.EnrichWithShape;
import org.eclipse.rdf4j.sail.shacl.planNodes.EqualsJoin;
import org.eclipse.rdf4j.sail.shacl.planNodes.InnerJoin;
import org.eclipse.rdf4j.sail.shacl.planNodes.IteratorData;
import org.eclipse.rdf4j.sail.shacl.planNodes.LoggingNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.TrimTuple;
import org.eclipse.rdf4j.sail.shacl.planNodes.UnionNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.Unique;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrPropertyShape
extends PropertyShape {
    private final List<List<PropertyShape>> or;
    private static final Logger logger = LoggerFactory.getLogger(OrPropertyShape.class);

    OrPropertyShape(Resource id, SailRepositoryConnection connection, NodeShape nodeShape, Resource or) {
        super(id, nodeShape);
        this.or = OrPropertyShape.toList(connection, or).stream().map(v -> PropertyShape.Factory.getPropertyShapesInner(connection, nodeShape, (Resource)v)).collect(Collectors.toList());
    }

    @Override
    public PlanNode getPlan(ShaclSailConnection shaclSailConnection, NodeShape nodeShape, boolean printPlans, PlanNode overrideTargetNode) {
        LoggingNode ret;
        List collect;
        List initialPlanNodes = this.or.stream().map(shapes -> shapes.stream().map(shape -> shape.getPlan(shaclSailConnection, nodeShape, false, null)).collect(Collectors.toList())).collect(Collectors.toList());
        BufferedSplitter targetNodesToValidate = overrideTargetNode == null ? new BufferedSplitter(this.unionAll(initialPlanNodes.stream().flatMap(Collection::stream).map(p -> new TrimTuple((PlanNode)p, 0, 1)).collect(Collectors.toList()))) : new BufferedSplitter(overrideTargetNode);
        List plannodes = this.or.stream().map(shapes -> shapes.stream().map(shape -> {
            if (shaclSailConnection.stats.isBaseSailEmpty()) {
                return shape.getPlan(shaclSailConnection, nodeShape, false, null);
            }
            return shape.getPlan(shaclSailConnection, nodeShape, false, new LoggingNode(targetNodesToValidate.getPlanNode(), ""));
        }).collect(Collectors.toList())).collect(Collectors.toList());
        List iteratorDataTypes = plannodes.stream().flatMap(shapes -> shapes.stream().map(PlanNode::getIteratorDataType)).distinct().collect(Collectors.toList());
        if (iteratorDataTypes.size() > 1) {
            throw new UnsupportedOperationException("No support for OR shape with mix between aggregate and raw triples");
        }
        IteratorData iteratorData = (IteratorData)((Object)iteratorDataTypes.get(0));
        if (iteratorData == IteratorData.tripleBased && (collect = this.getPaths().stream().distinct().collect(Collectors.toList())).size() > 1) {
            iteratorData = IteratorData.aggregated;
        }
        if (iteratorData == IteratorData.tripleBased) {
            EqualsJoin equalsJoin = new EqualsJoin(this.unionAll((List)plannodes.get(0)), this.unionAll((List)plannodes.get(1)), true);
            for (int i = 2; i < this.or.size(); ++i) {
                equalsJoin = new EqualsJoin(equalsJoin, this.unionAll((List)plannodes.get(i)), true);
            }
            ret = new LoggingNode(equalsJoin, "");
        } else if (iteratorData == IteratorData.aggregated) {
            LoggingNode innerJoin = new LoggingNode(new InnerJoin(this.unionAll((List)plannodes.get(0)), this.unionAll((List)plannodes.get(1)), null, null), "");
            for (int i = 2; i < this.or.size(); ++i) {
                innerJoin = new LoggingNode(new InnerJoin(innerJoin, this.unionAll((List)plannodes.get(i)), null, null), "");
            }
            ret = new LoggingNode(innerJoin, "");
        } else {
            throw new IllegalStateException("Should not get here!");
        }
        if (printPlans) {
            String planAsGraphiz = this.getPlanAsGraphvizDot(ret, shaclSailConnection);
            logger.info(planAsGraphiz);
        }
        return new EnrichWithShape(ret, this);
    }

    @Override
    public List<Path> getPaths() {
        return this.or.stream().flatMap(a -> a.stream().flatMap(b -> b.getPaths().stream())).collect(Collectors.toList());
    }

    private PlanNode unionAll(List<PlanNode> planNodes) {
        return new Unique(new UnionNode(planNodes.toArray(new PlanNode[0])));
    }

    @Override
    public boolean requiresEvaluation(SailConnection addedStatements, SailConnection removedStatements) {
        return super.requiresEvaluation(addedStatements, removedStatements) || this.or.stream().flatMap(Collection::stream).map(p -> p.requiresEvaluation(addedStatements, removedStatements)).reduce((a, b) -> a != false || b != false).orElse(false) != false;
    }

    @Override
    public SourceConstraintComponent getSourceConstraintComponent() {
        return SourceConstraintComponent.OrConstraintComponent;
    }
}

