/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.AST;

import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.repository.sail.SailRepositoryConnection;
import org.eclipse.rdf4j.sail.NotifyingSailConnection;
import org.eclipse.rdf4j.sail.SailConnection;
import org.eclipse.rdf4j.sail.shacl.AST.NodeShape;
import org.eclipse.rdf4j.sail.shacl.AST.PathPropertyShape;
import org.eclipse.rdf4j.sail.shacl.AST.TargetClass;
import org.eclipse.rdf4j.sail.shacl.ShaclSailConnection;
import org.eclipse.rdf4j.sail.shacl.SourceConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.planNodes.BufferedTupleFromFilter;
import org.eclipse.rdf4j.sail.shacl.planNodes.BulkedExternalLeftOuterJoin;
import org.eclipse.rdf4j.sail.shacl.planNodes.DirectTupleFromFilter;
import org.eclipse.rdf4j.sail.shacl.planNodes.EnrichWithShape;
import org.eclipse.rdf4j.sail.shacl.planNodes.GroupByCount;
import org.eclipse.rdf4j.sail.shacl.planNodes.LoggingNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.MaxCountFilter;
import org.eclipse.rdf4j.sail.shacl.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.TrimTuple;
import org.eclipse.rdf4j.sail.shacl.planNodes.UnionNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.Unique;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaxCountPropertyShape
extends PathPropertyShape {
    private static final Logger logger = LoggerFactory.getLogger(MaxCountPropertyShape.class);
    private long maxCount;

    MaxCountPropertyShape(Resource id, SailRepositoryConnection connection, NodeShape nodeShape, Long maxCount) {
        super(id, connection, nodeShape);
        this.maxCount = maxCount;
    }

    public String toString() {
        return "MaxCountPropertyShape{maxCount=" + this.maxCount + '}';
    }

    @Override
    public PlanNode getPlan(ShaclSailConnection shaclSailConnection, NodeShape nodeShape, boolean printPlans, PlanNode overrideTargetNode) {
        if (overrideTargetNode != null) {
            LoggingNode bulkedExternalLeftOuterJoin = new LoggingNode(new BulkedExternalLeftOuterJoin(overrideTargetNode, (SailConnection)shaclSailConnection, this.path.getQuery("?a", "?c", null), false), "");
            LoggingNode groupByCount = new LoggingNode(new GroupByCount(bulkedExternalLeftOuterJoin), "");
            DirectTupleFromFilter directTupleFromFilter = new DirectTupleFromFilter();
            new MaxCountFilter(groupByCount, null, directTupleFromFilter, this.maxCount);
            if (printPlans) {
                String planAsGraphvizDot = this.getPlanAsGraphvizDot(directTupleFromFilter, shaclSailConnection);
                logger.info(planAsGraphvizDot);
            }
            return new EnrichWithShape(new LoggingNode(directTupleFromFilter, ""), this);
        }
        LoggingNode planAddedStatements = new LoggingNode(nodeShape.getPlanAddedStatements(shaclSailConnection, nodeShape), "");
        LoggingNode planAddedStatements1 = new LoggingNode(super.getPlanAddedStatements(shaclSailConnection, nodeShape), "");
        if (nodeShape instanceof TargetClass) {
            planAddedStatements1 = new LoggingNode(((TargetClass)nodeShape).getTypeFilterPlan((NotifyingSailConnection)shaclSailConnection, planAddedStatements1), "");
        }
        LoggingNode mergeNode = new LoggingNode(new UnionNode(planAddedStatements, planAddedStatements1), "");
        LoggingNode groupByCount1 = new LoggingNode(new GroupByCount(mergeNode), "");
        BufferedTupleFromFilter validValues = new BufferedTupleFromFilter();
        BufferedTupleFromFilter invalidValues = new BufferedTupleFromFilter();
        new MaxCountFilter(groupByCount1, validValues, invalidValues, this.maxCount);
        LoggingNode trimmed = new LoggingNode(new TrimTuple(validValues, 0, 1), "");
        LoggingNode unique = new LoggingNode(new Unique(trimmed), "");
        LoggingNode bulkedExternalLeftOuterJoin = new LoggingNode(new BulkedExternalLeftOuterJoin(unique, (SailConnection)shaclSailConnection, this.path.getQuery("?a", "?c", null), false), "");
        LoggingNode groupByCount = new LoggingNode(new GroupByCount(bulkedExternalLeftOuterJoin), "");
        DirectTupleFromFilter directTupleFromFilter = new DirectTupleFromFilter();
        new MaxCountFilter(groupByCount, null, directTupleFromFilter, this.maxCount);
        UnionNode mergeNode1 = new UnionNode(new LoggingNode(directTupleFromFilter, ""), new LoggingNode(invalidValues, ""));
        if (printPlans) {
            String planAsGraphvizDot = this.getPlanAsGraphvizDot(mergeNode1, shaclSailConnection);
            logger.info(planAsGraphvizDot);
        }
        return new EnrichWithShape(new LoggingNode(mergeNode1, ""), this);
    }

    @Override
    public SourceConstraintComponent getSourceConstraintComponent() {
        return SourceConstraintComponent.MaxCountConstraintComponent;
    }
}

