/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.AST;

import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.repository.sail.SailRepositoryConnection;
import org.eclipse.rdf4j.sail.shacl.AST.NodeShape;
import org.eclipse.rdf4j.sail.shacl.AST.PathPropertyShape;
import org.eclipse.rdf4j.sail.shacl.AST.StandardisedPlanHelper;
import org.eclipse.rdf4j.sail.shacl.ShaclSailConnection;
import org.eclipse.rdf4j.sail.shacl.SourceConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.planNodes.EnrichWithShape;
import org.eclipse.rdf4j.sail.shacl.planNodes.LanguageInFilter;
import org.eclipse.rdf4j.sail.shacl.planNodes.PlanNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LanguageInPropertyShape
extends PathPropertyShape {
    private final List<String> languageIn;
    private static final Logger logger = LoggerFactory.getLogger(LanguageInPropertyShape.class);

    LanguageInPropertyShape(Resource id, SailRepositoryConnection connection, NodeShape nodeShape, Resource languageIn) {
        super(id, connection, nodeShape);
        this.languageIn = LanguageInPropertyShape.toList(connection, languageIn).stream().map(Value::stringValue).collect(Collectors.toList());
    }

    @Override
    public PlanNode getPlan(ShaclSailConnection shaclSailConnection, NodeShape nodeShape, boolean printPlans, PlanNode overrideTargetNode) {
        PlanNode invalidValues = StandardisedPlanHelper.getGenericSingleObjectPlan(shaclSailConnection, nodeShape, (parent, trueNode, falseNode) -> new LanguageInFilter(parent, trueNode, falseNode, this.languageIn), this, overrideTargetNode);
        if (printPlans) {
            String planAsGraphvizDot = this.getPlanAsGraphvizDot(invalidValues, shaclSailConnection);
            logger.info(planAsGraphvizDot);
        }
        return new EnrichWithShape(invalidValues, this);
    }

    @Override
    public SourceConstraintComponent getSourceConstraintComponent() {
        return SourceConstraintComponent.LanguageInConstraintComponent;
    }
}

