/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.planNodes;

import org.apache.commons.lang.StringEscapeUtils;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.impl.MapBindingSet;
import org.eclipse.rdf4j.query.parser.ParsedQuery;
import org.eclipse.rdf4j.query.parser.QueryParserFactory;
import org.eclipse.rdf4j.query.parser.QueryParserRegistry;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.shacl.ShaclSailConnection;
import org.eclipse.rdf4j.sail.shacl.planNodes.IteratorData;
import org.eclipse.rdf4j.sail.shacl.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.Tuple;

public class Select
implements PlanNode {
    final Repository repository;
    ShaclSailConnection connection;
    String query;

    public Select(Repository repository, String query) {
        this.repository = repository;
        this.query = "select * where { " + query + "} order by ?a";
    }

    public Select(ShaclSailConnection connection, String query) {
        this.connection = connection;
        this.repository = null;
        this.query = "select * where { " + query + "} order by ?a";
    }

    @Override
    public CloseableIteration<Tuple, SailException> iterator() {
        return new CloseableIteration<Tuple, SailException>(){
            CloseableIteration<? extends BindingSet, QueryEvaluationException> bindingSet;
            RepositoryConnection repositoryConnection;
            {
                if (Select.this.repository != null && Select.this.connection == null) {
                    this.repositoryConnection = Select.this.repository.getConnection();
                    this.bindingSet = this.repositoryConnection.prepareTupleQuery(Select.this.query).evaluate();
                } else {
                    QueryParserFactory queryParserFactory = (QueryParserFactory)QueryParserRegistry.getInstance().get((Object)QueryLanguage.SPARQL).get();
                    ParsedQuery parsedQuery = queryParserFactory.getParser().parseQuery(Select.this.query, null);
                    this.bindingSet = Select.this.connection.evaluate(parsedQuery.getTupleExpr(), parsedQuery.getDataset(), (BindingSet)new MapBindingSet(), true);
                }
            }

            public void close() throws SailException {
                try {
                    this.bindingSet.close();
                }
                finally {
                    if (this.repositoryConnection != null) {
                        this.repositoryConnection.close();
                    }
                }
            }

            public boolean hasNext() throws SailException {
                return this.bindingSet.hasNext();
            }

            public Tuple next() throws SailException {
                return new Tuple((BindingSet)this.bindingSet.next());
            }

            public void remove() throws SailException {
            }
        };
    }

    @Override
    public int depth() {
        return 0;
    }

    @Override
    public void getPlanAsGraphvizDot(StringBuilder stringBuilder) {
        stringBuilder.append(this.getId() + " [label=\"" + StringEscapeUtils.escapeJava((String)this.toString()) + "\"];").append("\n");
        if (this.repository != null) {
            stringBuilder.append(System.identityHashCode(this.repository) + " -> " + this.getId()).append("\n");
        }
        if (this.connection != null) {
            stringBuilder.append(System.identityHashCode((Object)this.connection) + " -> " + this.getId()).append("\n");
        }
    }

    @Override
    public String getId() {
        return System.identityHashCode(this) + "";
    }

    @Override
    public IteratorData getIteratorDataType() {
        return IteratorData.tripleBased;
    }

    public String toString() {
        return "Select{query='" + this.query + '\'' + '}';
    }
}

