/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.planNodes;

import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.sail.shacl.planNodes.FilterPlanNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.PushBasedPlanNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.Tuple;

public class MaxLengthFilter
extends FilterPlanNode {
    private final long maxLength;

    public MaxLengthFilter(PlanNode parent, PushBasedPlanNode trueNode, PushBasedPlanNode falseNode, long maxLength) {
        super(parent, trueNode, falseNode);
        this.maxLength = maxLength;
    }

    @Override
    boolean checkTuple(Tuple t) {
        Value literal = t.line.get(1);
        return (long)literal.stringValue().length() <= this.maxLength;
    }

    @Override
    public String toString() {
        return "MaxLengthFilter{maxLength=" + this.maxLength + '}';
    }
}

