/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.planNodes;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringEscapeUtils;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.shacl.planNodes.IteratorData;
import org.eclipse.rdf4j.sail.shacl.planNodes.ParentProvider;
import org.eclipse.rdf4j.sail.shacl.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.PushBasedPlanNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.SupportsParentProvider;
import org.eclipse.rdf4j.sail.shacl.planNodes.Tuple;
import org.eclipse.rdf4j.sail.shacl.planNodes.TupleHelper;

public class InnerJoin
implements PlanNode {
    PlanNode left;
    PlanNode right;
    PushBasedPlanNode discardedLeft;
    PushBasedPlanNode discardedRight;

    public InnerJoin(final PlanNode left, final PlanNode right, PushBasedPlanNode discardedLeft, PushBasedPlanNode discardedRight) {
        this.left = left;
        this.right = right;
        this.discardedLeft = discardedLeft;
        this.discardedRight = discardedRight;
        if (discardedLeft instanceof SupportsParentProvider) {
            ((SupportsParentProvider)((Object)discardedLeft)).receiveParentProvider(new ParentProvider(){

                @Override
                public List<PlanNode> parent() {
                    return Arrays.asList(left, right);
                }
            });
        }
        if (discardedRight instanceof SupportsParentProvider) {
            ((SupportsParentProvider)((Object)discardedRight)).receiveParentProvider(new ParentProvider(){

                @Override
                public List<PlanNode> parent() {
                    return Arrays.asList(left, right);
                }
            });
        }
    }

    @Override
    public CloseableIteration<Tuple, SailException> iterator() {
        return new CloseableIteration<Tuple, SailException>(){
            CloseableIteration<Tuple, SailException> leftIterator;
            CloseableIteration<Tuple, SailException> rightIterator;
            Tuple next;
            Tuple nextLeft;
            Tuple nextRight;
            {
                this.leftIterator = InnerJoin.this.left.iterator();
                this.rightIterator = InnerJoin.this.right.iterator();
            }

            void calculateNext() {
                if (this.next != null) {
                    return;
                }
                if (this.nextLeft == null && this.leftIterator.hasNext()) {
                    this.nextLeft = (Tuple)this.leftIterator.next();
                }
                if (this.nextRight == null && this.rightIterator.hasNext()) {
                    this.nextRight = (Tuple)this.rightIterator.next();
                }
                if (this.nextLeft == null) {
                    if (InnerJoin.this.discardedRight != null) {
                        while (this.nextRight != null) {
                            InnerJoin.this.discardedRight.push(this.nextRight);
                            if (this.rightIterator.hasNext()) {
                                this.nextRight = (Tuple)this.rightIterator.next();
                                continue;
                            }
                            this.nextRight = null;
                        }
                    }
                    return;
                }
                while (this.next == null) {
                    if (this.nextRight != null) {
                        if (this.nextLeft.line.get(0) == this.nextRight.line.get(0) || this.nextLeft.line.get(0).equals(this.nextRight.line.get(0))) {
                            this.next = TupleHelper.join(this.nextLeft, this.nextRight);
                            this.nextRight = null;
                            continue;
                        }
                        int compareTo = this.nextLeft.compareTo(this.nextRight);
                        if (compareTo < 0) {
                            if (InnerJoin.this.discardedLeft != null) {
                                InnerJoin.this.discardedLeft.push(this.nextLeft);
                            }
                            if (this.leftIterator.hasNext()) {
                                this.nextLeft = (Tuple)this.leftIterator.next();
                                continue;
                            }
                            this.nextLeft = null;
                            break;
                        }
                        if (InnerJoin.this.discardedRight != null) {
                            InnerJoin.this.discardedRight.push(this.nextRight);
                        }
                        if (this.rightIterator.hasNext()) {
                            this.nextRight = (Tuple)this.rightIterator.next();
                            continue;
                        }
                        this.nextRight = null;
                        break;
                    }
                    return;
                }
            }

            public void close() throws SailException {
                this.leftIterator.close();
                this.rightIterator.close();
            }

            public boolean hasNext() throws SailException {
                this.calculateNext();
                return this.next != null;
            }

            public Tuple next() throws SailException {
                this.calculateNext();
                Tuple temp = this.next;
                this.next = null;
                return temp;
            }

            public void remove() throws SailException {
            }
        };
    }

    @Override
    public int depth() {
        return Math.max(this.left.depth(), this.right.depth());
    }

    @Override
    public void getPlanAsGraphvizDot(StringBuilder stringBuilder) {
        this.left.getPlanAsGraphvizDot(stringBuilder);
        stringBuilder.append(this.getId() + " [label=\"" + StringEscapeUtils.escapeJava((String)this.toString()) + "\"];").append("\n");
        stringBuilder.append(this.left.getId() + " -> " + this.getId() + " [label=\"left\"];").append("\n");
        stringBuilder.append(this.right.getId() + " -> " + this.getId() + " [label=\"right\"];").append("\n");
        this.right.getPlanAsGraphvizDot(stringBuilder);
        if (this.discardedRight != null && this.discardedRight instanceof PlanNode) {
            stringBuilder.append(this.getId() + " -> " + ((PlanNode)((Object)this.discardedRight)).getId() + " [label=\"discardedRight\"];").append("\n");
        }
        if (this.discardedLeft != null && this.discardedLeft instanceof PlanNode) {
            stringBuilder.append(this.getId() + " -> " + ((PlanNode)((Object)this.discardedLeft)).getId() + " [label=\"discardedLeft\"];").append("\n");
        }
    }

    @Override
    public String getId() {
        return System.identityHashCode(this) + "";
    }

    @Override
    public IteratorData getIteratorDataType() {
        if (this.left.getIteratorDataType() == this.right.getIteratorDataType()) {
            return this.left.getIteratorDataType();
        }
        throw new IllegalStateException("Not implemented support for when left and right have different types of data");
    }

    public String toString() {
        return "InnerJoin";
    }
}

