/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.planNodes;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringEscapeUtils;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.shacl.planNodes.FilterPlanNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.IteratorData;
import org.eclipse.rdf4j.sail.shacl.planNodes.ParentProvider;
import org.eclipse.rdf4j.sail.shacl.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.PushBasedPlanNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.SupportsParentProvider;
import org.eclipse.rdf4j.sail.shacl.planNodes.Tuple;

public class DirectTupleFromFilter
implements PlanNode,
PushBasedPlanNode,
SupportsParentProvider {
    private CloseableIteration<Tuple, SailException> parentIterator;
    Tuple next = null;
    private ParentProvider parentProvider;

    @Override
    public CloseableIteration<Tuple, SailException> iterator() {
        return new CloseableIteration<Tuple, SailException>(){

            private void calculateNext() {
                while (DirectTupleFromFilter.this.next == null && DirectTupleFromFilter.this.parentIterator.hasNext()) {
                    DirectTupleFromFilter.this.parentIterator.next();
                }
            }

            public void close() throws SailException {
                DirectTupleFromFilter.this.parentIterator.close();
            }

            public boolean hasNext() throws SailException {
                this.calculateNext();
                return DirectTupleFromFilter.this.next != null;
            }

            public Tuple next() throws SailException {
                this.calculateNext();
                Tuple temp = DirectTupleFromFilter.this.next;
                DirectTupleFromFilter.this.next = null;
                return temp;
            }

            public void remove() throws SailException {
            }
        };
    }

    @Override
    public int depth() {
        return this.parentProvider.parent().stream().mapToInt(PlanNode::depth).sum() + 2;
    }

    @Override
    public void getPlanAsGraphvizDot(StringBuilder stringBuilder) {
        stringBuilder.append(this.getId() + " [label=\"" + StringEscapeUtils.escapeJava((String)this.toString()) + "\"];").append("\n");
        if (this.parentProvider instanceof PlanNode) {
            ((PlanNode)((Object)this.parentProvider)).getPlanAsGraphvizDot(stringBuilder);
        }
        if (this.parentProvider instanceof FilterPlanNode) {
            ((FilterPlanNode)this.parentProvider).getPlanAsGraphvizDot(stringBuilder);
        }
    }

    public String toString() {
        return "DirectTupleFromFilter";
    }

    @Override
    public String getId() {
        return System.identityHashCode(this) + "";
    }

    @Override
    public IteratorData getIteratorDataType() {
        List collect = this.parentProvider.parent().stream().map(PlanNode::getIteratorDataType).distinct().collect(Collectors.toList());
        if (collect.size() == 1) {
            return (IteratorData)((Object)collect.get(0));
        }
        throw new IllegalStateException("Not implemented yet");
    }

    @Override
    public void push(Tuple t) {
        this.next = t;
    }

    @Override
    public void parentIterator(CloseableIteration<Tuple, SailException> iterator) {
        this.parentIterator = iterator;
    }

    @Override
    public void receiveParentProvider(ParentProvider parentProvider) {
        this.parentProvider = parentProvider;
    }
}

