/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.rdf4j.IsolationLevel;
import org.eclipse.rdf4j.IsolationLevels;
import org.eclipse.rdf4j.common.iteration.Iterations;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.vocabulary.RDF4J;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.sail.SailRepository;
import org.eclipse.rdf4j.repository.sail.SailRepositoryConnection;
import org.eclipse.rdf4j.sail.NotifyingSailConnection;
import org.eclipse.rdf4j.sail.Sail;
import org.eclipse.rdf4j.sail.SailConnectionListener;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.UpdateContext;
import org.eclipse.rdf4j.sail.helpers.NotifyingSailConnectionWrapper;
import org.eclipse.rdf4j.sail.memory.MemoryStore;
import org.eclipse.rdf4j.sail.shacl.AST.NodeShape;
import org.eclipse.rdf4j.sail.shacl.NoShapesLoadedException;
import org.eclipse.rdf4j.sail.shacl.ShaclSail;
import org.eclipse.rdf4j.sail.shacl.ShaclSailValidationException;
import org.eclipse.rdf4j.sail.shacl.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.Tuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShaclSailConnection
extends NotifyingSailConnectionWrapper {
    private static final Logger logger = LoggerFactory.getLogger(ShaclSailConnection.class);
    private NotifyingSailConnection previousStateConnection;
    private Repository addedStatements;
    private Repository removedStatements;
    private boolean isShapeRefreshNeeded = false;
    public final ShaclSail sail;
    public Stats stats;
    private HashSet<Statement> addedStatementsSet = new HashSet();
    private HashSet<Statement> removedStatementsSet = new HashSet();
    private SailRepositoryConnection shapesConnection;

    ShaclSailConnection(ShaclSail sail, NotifyingSailConnection connection, NotifyingSailConnection previousStateConnection, SailRepositoryConnection shapesConnection) {
        super(connection);
        this.previousStateConnection = previousStateConnection;
        this.shapesConnection = shapesConnection;
        this.sail = sail;
        if (sail.config.validationEnabled) {
            this.addConnectionListener(new SailConnectionListener(){

                public void statementAdded(Statement statement) {
                    boolean add = ShaclSailConnection.this.addedStatementsSet.add(statement);
                    if (!add) {
                        ShaclSailConnection.this.removedStatementsSet.remove(statement);
                    }
                }

                public void statementRemoved(Statement statement) {
                    boolean add = ShaclSailConnection.this.removedStatementsSet.add(statement);
                    if (!add) {
                        ShaclSailConnection.this.addedStatementsSet.remove(statement);
                    }
                }
            });
        }
    }

    public NotifyingSailConnection getPreviousStateConnection() {
        return this.previousStateConnection;
    }

    public Repository getAddedStatements() {
        return this.addedStatements;
    }

    public Repository getRemovedStatements() {
        return this.removedStatements;
    }

    public void begin() throws SailException {
        this.begin(this.sail.getDefaultIsolationLevel());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void begin(IsolationLevel level) throws SailException {
        assert (this.addedStatements == null);
        assert (this.removedStatements == null);
        this.stats = new Stats();
        ShaclSail shaclSail = this.sail;
        synchronized (shaclSail) {
            super.begin(level);
            this.shapesConnection.begin((IsolationLevel)IsolationLevels.SERIALIZABLE);
            this.previousStateConnection.begin((IsolationLevel)IsolationLevels.SNAPSHOT);
        }
    }

    private SailRepository getNewMemorySail() {
        MemoryStore sail = new MemoryStore();
        sail.setDefaultIsolationLevel((IsolationLevel)IsolationLevels.NONE);
        SailRepository repository = new SailRepository((Sail)sail);
        repository.initialize();
        return repository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws SailException {
        ShaclSail shaclSail = this.sail;
        synchronized (shaclSail) {
            this.refreshShapes(this.shapesConnection);
            if (!(this.sail.isIgnoreNoShapesLoadedException() || this.addedStatementsSet.isEmpty() && this.removedStatementsSet.isEmpty() || !this.sail.getNodeShapes().isEmpty())) {
                throw new NoShapesLoadedException();
            }
            try {
                List<Tuple> invalidTuples = this.validate();
                boolean valid = invalidTuples.isEmpty();
                this.previousStateConnection.commit();
                if (!valid) {
                    this.rollback();
                    this.refreshShapes(this.shapesConnection);
                    throw new ShaclSailValidationException(invalidTuples);
                }
                this.shapesConnection.commit();
                super.commit();
            }
            finally {
                this.cleanup();
            }
        }
    }

    public void addStatement(UpdateContext modify, Resource subj, IRI pred, Value obj, Resource ... contexts) throws SailException {
        if (contexts.length == 1 && contexts[0].equals(RDF4J.SHACL_SHAPE_GRAPH)) {
            this.shapesConnection.add(subj, pred, obj, new Resource[0]);
            this.isShapeRefreshNeeded = true;
        } else {
            super.addStatement(modify, subj, pred, obj, contexts);
        }
    }

    public void removeStatement(UpdateContext modify, Resource subj, IRI pred, Value obj, Resource ... contexts) throws SailException {
        if (contexts.length == 1 && contexts[0].equals(RDF4J.SHACL_SHAPE_GRAPH)) {
            this.shapesConnection.remove(subj, pred, obj, new Resource[0]);
            this.isShapeRefreshNeeded = true;
        } else {
            super.removeStatement(modify, subj, pred, obj, contexts);
        }
    }

    public void addStatement(Resource subj, IRI pred, Value obj, Resource ... contexts) throws SailException {
        if (contexts.length == 1 && RDF4J.SHACL_SHAPE_GRAPH.equals((Object)contexts[0])) {
            this.shapesConnection.add(subj, pred, obj, new Resource[0]);
            this.isShapeRefreshNeeded = true;
        } else {
            super.addStatement(subj, pred, obj, contexts);
        }
    }

    public void removeStatements(Resource subj, IRI pred, Value obj, Resource ... contexts) throws SailException {
        if (contexts.length == 1 && contexts[0].equals(RDF4J.SHACL_SHAPE_GRAPH)) {
            this.shapesConnection.remove(subj, pred, obj, new Resource[0]);
            this.isShapeRefreshNeeded = true;
        } else {
            super.removeStatements(subj, pred, obj, contexts);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() throws SailException {
        ShaclSail shaclSail = this.sail;
        synchronized (shaclSail) {
            this.previousStateConnection.commit();
            this.cleanup();
            this.shapesConnection.rollback();
            super.rollback();
        }
    }

    private void cleanup() {
        if (this.addedStatements != null) {
            this.addedStatements.shutDown();
            this.addedStatements = null;
        }
        if (this.removedStatements != null) {
            this.removedStatements.shutDown();
            this.removedStatements = null;
        }
        this.addedStatementsSet.clear();
        this.removedStatementsSet.clear();
        this.stats = null;
        this.isShapeRefreshNeeded = false;
    }

    private void refreshShapes(SailRepositoryConnection shapesRepoConnection) {
        if (this.isShapeRefreshNeeded) {
            this.sail.refreshShapes(shapesRepoConnection);
            this.isShapeRefreshNeeded = false;
        }
    }

    private List<Tuple> validate() {
        if (!this.sail.config.validationEnabled) {
            return Collections.emptyList();
        }
        this.fillAddedAndRemovedStatementRepositories();
        ArrayList<Tuple> ret = new ArrayList<Tuple>();
        List<NodeShape> nodeShapes = NodeShape.Factory.getShapes(this.shapesConnection);
        for (NodeShape nodeShape : nodeShapes) {
            List<PlanNode> planNodes = nodeShape.generatePlans(this, nodeShape, this.sail.config.logValidationPlans);
            for (PlanNode planNode : planNodes) {
                Stream stream = Iterations.stream(planNode.iterator());
                Throwable throwable = null;
                try {
                    List collect = stream.collect(Collectors.toList());
                    ret.addAll(collect);
                    boolean valid = collect.size() == 0;
                    if (valid || !this.sail.config.logValidationViolations) continue;
                    logger.info("SHACL not valid. The following experimental debug results were produced: \n\tNodeShape: {} \n\t\t{}", (Object)nodeShape.toString(), (Object)collect.stream().map(a -> a.toString() + " -cause-> " + a.getCause()).collect(Collectors.joining("\n\t\t")));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (stream == null) continue;
                    if (throwable != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    stream.close();
                }
            }
        }
        return ret;
    }

    void fillAddedAndRemovedStatementRepositories() {
        this.addedStatements = this.getNewMemorySail();
        this.removedStatements = this.getNewMemorySail();
        this.addedStatementsSet.forEach(this.stats::added);
        this.removedStatementsSet.forEach(this.stats::removed);
        try (RepositoryConnection connection = this.addedStatements.getConnection();){
            connection.begin((IsolationLevel)IsolationLevels.NONE);
            this.addedStatementsSet.stream().filter(statement -> !this.removedStatementsSet.contains(statement)).forEach(x$0 -> connection.add(x$0, new Resource[0]));
            connection.commit();
        }
        connection = this.removedStatements.getConnection();
        var2_2 = null;
        try {
            connection.begin((IsolationLevel)IsolationLevels.NONE);
            this.removedStatementsSet.stream().filter(statement -> !this.addedStatementsSet.contains(statement)).forEach(x$0 -> connection.add(x$0, new Resource[0]));
            connection.commit();
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (connection != null) {
                if (var2_2 != null) {
                    try {
                        connection.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    connection.close();
                }
            }
        }
    }

    public synchronized void close() throws SailException {
        if (this.isActive()) {
            this.rollback();
        }
        this.shapesConnection.close();
        this.previousStateConnection.close();
        super.close();
    }

    public class Stats {
        boolean hasAdded;
        boolean hasRemoved;

        public void added(Statement statement) {
            this.hasAdded = true;
        }

        public void removed(Statement statement) {
            this.hasRemoved = true;
        }

        public boolean hasAdded() {
            return this.hasAdded;
        }

        public boolean hasRemoved() {
            return this.hasRemoved;
        }
    }
}

