/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.vocabulary.SHACL;
import org.eclipse.rdf4j.repository.sail.SailRepository;
import org.eclipse.rdf4j.repository.sail.SailRepositoryConnection;
import org.eclipse.rdf4j.sail.NotifyingSail;
import org.eclipse.rdf4j.sail.NotifyingSailConnection;
import org.eclipse.rdf4j.sail.Sail;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.config.SailConfigException;
import org.eclipse.rdf4j.sail.helpers.NotifyingSailWrapper;
import org.eclipse.rdf4j.sail.memory.MemoryStore;
import org.eclipse.rdf4j.sail.shacl.AST.NodeShape;
import org.eclipse.rdf4j.sail.shacl.ShaclSailConfig;
import org.eclipse.rdf4j.sail.shacl.ShaclSailConnection;
import org.eclipse.rdf4j.sail.shacl.planNodes.LoggingNode;

public class ShaclSail
extends NotifyingSailWrapper {
    private List<NodeShape> nodeShapes;
    final ShaclSailConfig config = new ShaclSailConfig();
    private static String SH_OR_UPDATE_QUERY;
    private static String SH_OR_NODE_SHAPE_UPDATE_QUERY;
    private SailRepository shapesRepo;

    public ShaclSail(NotifyingSail baseSail) {
        super(baseSail);
        String path = null;
        if (baseSail.getDataDir() != null) {
            path = baseSail.getDataDir().getPath();
        } else {
            try {
                path = Files.createTempDirectory("shacl-shapes", new FileAttribute[0]).toString();
            }
            catch (IOException e) {
                throw new SailConfigException((Throwable)e);
            }
        }
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        path = path + "-shapes-graph/";
        this.shapesRepo = new SailRepository((Sail)new MemoryStore(new File(path)));
        this.shapesRepo.initialize();
    }

    public ShaclSail() {
    }

    public static List<IRI> getSupportedShaclPredicates() {
        return Arrays.asList(SHACL.TARGET_CLASS, SHACL.PATH, SHACL.PROPERTY, SHACL.OR, SHACL.MIN_COUNT, SHACL.MAX_COUNT, SHACL.MIN_LENGTH, SHACL.MAX_LENGTH, SHACL.PATTERN, SHACL.FLAGS, SHACL.NODE_KIND_PROP, SHACL.LANGUAGE_IN, SHACL.DATATYPE);
    }

    public void initialize() throws SailException {
        super.initialize();
        try (SailRepositoryConnection shapesRepoConnection = this.shapesRepo.getConnection();){
            this.refreshShapes(shapesRepoConnection);
        }
    }

    void refreshShapes(SailRepositoryConnection shapesRepoConnection) throws SailException {
        try (SailRepositoryConnection beforeCommitConnection = this.shapesRepo.getConnection();){
            long size = beforeCommitConnection.size(new Resource[0]);
            if (size > 0L) {
                throw new IllegalStateException("ShaclSail does not support modifying shapes that are already loaded or loading more shapes");
            }
        }
        this.runInferencingSparqlQueries(shapesRepoConnection);
        this.nodeShapes = NodeShape.Factory.getShapes(shapesRepoConnection);
    }

    public void shutDown() throws SailException {
        try {
            this.shapesRepo.shutDown();
        }
        finally {
            this.shapesRepo = null;
        }
        super.shutDown();
    }

    public NotifyingSailConnection getConnection() throws SailException {
        return new ShaclSailConnection(this, super.getConnection(), super.getConnection(), this.shapesRepo.getConnection());
    }

    public void disableValidation() {
        this.config.validationEnabled = false;
    }

    public void enableValidation() {
        this.config.validationEnabled = true;
    }

    public boolean isLogValidationPlans() {
        return this.config.logValidationPlans;
    }

    public boolean isIgnoreNoShapesLoadedException() {
        return this.config.ignoreNoShapesLoadedException;
    }

    public void setIgnoreNoShapesLoadedException(boolean ignoreNoShapesLoadedException) {
        this.config.ignoreNoShapesLoadedException = ignoreNoShapesLoadedException;
    }

    public void setLogValidationPlans(boolean logValidationPlans) {
        this.config.logValidationPlans = logValidationPlans;
    }

    List<NodeShape> getNodeShapes() {
        return this.nodeShapes;
    }

    private void runInferencingSparqlQueries(SailRepositoryConnection shaclSailConnection) {
        long prevSize;
        long currentSize = shaclSailConnection.size(new Resource[0]);
        do {
            prevSize = currentSize;
            shaclSailConnection.prepareUpdate(SH_OR_NODE_SHAPE_UPDATE_QUERY).execute();
            shaclSailConnection.prepareUpdate(SH_OR_UPDATE_QUERY).execute();
        } while (prevSize != (currentSize = shaclSailConnection.size(new Resource[0])));
    }

    public void setGlobalLogValidationExecution(boolean loggingEnabled) {
        LoggingNode.loggingEnabled = loggingEnabled;
    }

    public boolean isGlobalLogValidationExecution() {
        return LoggingNode.loggingEnabled;
    }

    public boolean isLogValidationViolations() {
        return this.config.logValidationViolations;
    }

    public void setLogValidationViolations(boolean logValidationViolations) {
        this.config.logValidationViolations = logValidationViolations;
    }

    static {
        try {
            SH_OR_UPDATE_QUERY = IOUtils.toString((InputStream)ShaclSail.class.getClassLoader().getResourceAsStream("shacl-sparql-inference/sh_or.rq"), (String)"UTF-8");
            SH_OR_NODE_SHAPE_UPDATE_QUERY = IOUtils.toString((InputStream)ShaclSail.class.getClassLoader().getResourceAsStream("shacl-sparql-inference/sh_or_node_shape.rq"), (String)"UTF-8");
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }
}

