/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.AST;

import java.util.Objects;
import java.util.stream.Stream;
import org.eclipse.rdf4j.common.iteration.Iteration;
import org.eclipse.rdf4j.common.iteration.Iterations;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.vocabulary.SHACL;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.sail.SailRepositoryConnection;
import org.eclipse.rdf4j.sail.shacl.AST.Path;

public class SimplePath
extends Path {
    private final IRI path;

    SimplePath(Resource id, SailRepositoryConnection connection) {
        super(id);
        try (Stream stream = Iterations.stream((Iteration)connection.getStatements(id, SHACL.PATH, null, true, new Resource[0]));){
            this.path = stream.map(Statement::getObject).map(v -> (IRI)v).findAny().orElseThrow(() -> new RuntimeException("Expected to find sh:path on " + id));
        }
    }

    public String toString() {
        return "Path{path=" + this.path + '}';
    }

    @Override
    public boolean requiresEvaluation(Repository addedStatements, Repository removedStatements) {
        try (RepositoryConnection addedStatementsConnection = addedStatements.getConnection();){
            boolean requiresEvalutation = addedStatementsConnection.hasStatement(null, this.path, null, false, new Resource[0]);
        }
        var5_4 = null;
        try (RepositoryConnection removedStatementsConnection = removedStatements.getConnection();){
        }
        catch (Throwable throwable) {
            var5_4 = throwable;
            throw throwable;
        }
        return requiresEvalutation |= removedStatementsConnection.hasStatement(null, this.path, null, false, new Resource[0]);
    }

    @Override
    public String getQuery() {
        return "?a <" + this.path + "> ?c. ";
    }

    public IRI getPath() {
        return this.path;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimplePath that = (SimplePath)o;
        return Objects.equals(this.path, that.path);
    }

    public int hashCode() {
        return Objects.hash(this.path);
    }
}

