/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.AST;

import java.util.Optional;
import java.util.stream.Stream;
import org.eclipse.rdf4j.common.iteration.Iteration;
import org.eclipse.rdf4j.common.iteration.Iterations;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.vocabulary.SHACL;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.sail.SailRepositoryConnection;
import org.eclipse.rdf4j.sail.shacl.AST.NodeShape;
import org.eclipse.rdf4j.sail.shacl.AST.PathPropertyShape;
import org.eclipse.rdf4j.sail.shacl.AST.StandardisedPlanHelper;
import org.eclipse.rdf4j.sail.shacl.ShaclSailConnection;
import org.eclipse.rdf4j.sail.shacl.SourceConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.planNodes.EnrichWithShape;
import org.eclipse.rdf4j.sail.shacl.planNodes.LoggingNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.PatternFilter;
import org.eclipse.rdf4j.sail.shacl.planNodes.PlanNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PatternPropertyShape
extends PathPropertyShape {
    private final String pattern;
    private final Optional<String> flags;
    private static final Logger logger = LoggerFactory.getLogger(PatternPropertyShape.class);

    PatternPropertyShape(Resource id, SailRepositoryConnection connection, NodeShape nodeShape) {
        super(id, connection, nodeShape);
        try (Stream stream = Iterations.stream((Iteration)connection.getStatements(id, SHACL.PATTERN, null, true, new Resource[0]));){
            this.pattern = stream.map(Statement::getObject).map(Value::stringValue).findAny().orElseThrow(() -> new RuntimeException("Expected to find sh:pattern on " + id));
        }
        stream = Iterations.stream((Iteration)connection.getStatements(id, SHACL.FLAGS, null, true, new Resource[0]));
        var5_5 = null;
        try {
            this.flags = stream.map(Statement::getObject).map(Value::stringValue).findAny();
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
        finally {
            if (stream != null) {
                if (var5_5 != null) {
                    try {
                        stream.close();
                    }
                    catch (Throwable throwable) {
                        var5_5.addSuppressed(throwable);
                    }
                } else {
                    stream.close();
                }
            }
        }
    }

    @Override
    public PlanNode getPlan(ShaclSailConnection shaclSailConnection, NodeShape nodeShape, boolean printPlans, boolean assumeBaseSailValid) {
        PlanNode invalidValues = StandardisedPlanHelper.getGenericSingleObjectPlan(shaclSailConnection, nodeShape, (parent, trueNode, falseNode) -> new PatternFilter(parent, trueNode, falseNode, this.pattern, this.flags), this);
        if (printPlans) {
            String planAsGraphvizDot = this.getPlanAsGraphvizDot(invalidValues, shaclSailConnection);
            logger.info(planAsGraphvizDot);
        }
        return new EnrichWithShape(new LoggingNode(invalidValues), this);
    }

    @Override
    public boolean requiresEvaluation(Repository addedStatements, Repository removedStatements) {
        return true;
    }

    @Override
    public SourceConstraintComponent getSourceConstraintComponent() {
        return SourceConstraintComponent.PatternConstraintComponent;
    }
}

