/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.AST;

import java.util.stream.Stream;
import org.eclipse.rdf4j.common.iteration.Iteration;
import org.eclipse.rdf4j.common.iteration.Iterations;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.vocabulary.SHACL;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.sail.SailRepositoryConnection;
import org.eclipse.rdf4j.sail.shacl.AST.NodeShape;
import org.eclipse.rdf4j.sail.shacl.AST.PathPropertyShape;
import org.eclipse.rdf4j.sail.shacl.AST.StandardisedPlanHelper;
import org.eclipse.rdf4j.sail.shacl.ShaclSailConnection;
import org.eclipse.rdf4j.sail.shacl.SourceConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.planNodes.EnrichWithShape;
import org.eclipse.rdf4j.sail.shacl.planNodes.LoggingNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.NodeKindFilter;
import org.eclipse.rdf4j.sail.shacl.planNodes.PlanNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeKindPropertyShape
extends PathPropertyShape {
    private final NodeKind nodeKind;
    private static final Logger logger = LoggerFactory.getLogger(NodeKindPropertyShape.class);

    NodeKindPropertyShape(Resource id, SailRepositoryConnection connection, NodeShape nodeShape) {
        super(id, connection, nodeShape);
        try (Stream stream = Iterations.stream((Iteration)connection.getStatements(id, SHACL.NODE_KIND_PROP, null, true, new Resource[0]));){
            this.nodeKind = stream.map(Statement::getObject).map(v -> (Resource)v).map(NodeKind::from).findAny().orElseThrow(() -> new RuntimeException("Expected to find sh:nodeKind on " + id));
        }
    }

    @Override
    public PlanNode getPlan(ShaclSailConnection shaclSailConnection, NodeShape nodeShape, boolean printPlans, boolean assumeBaseSailValid) {
        PlanNode invalidValues = StandardisedPlanHelper.getGenericSingleObjectPlan(shaclSailConnection, nodeShape, (parent, trueNode, falseNode) -> new NodeKindFilter(parent, trueNode, falseNode, this.nodeKind), this);
        if (printPlans) {
            String planAsGraphvizDot = this.getPlanAsGraphvizDot(invalidValues, shaclSailConnection);
            logger.info(planAsGraphvizDot);
        }
        return new EnrichWithShape(new LoggingNode(invalidValues), this);
    }

    @Override
    public boolean requiresEvaluation(Repository addedStatements, Repository removedStatements) {
        return true;
    }

    @Override
    public SourceConstraintComponent getSourceConstraintComponent() {
        return SourceConstraintComponent.NodeKindConstraintComponent;
    }

    public static enum NodeKind {
        BlankNode(SHACL.BLANK_NODE),
        IRI(SHACL.IRI),
        Literal(SHACL.LITERAL),
        BlankNodeOrIRI(SHACL.BLANK_NODE_OR_IRI),
        BlankNodeOrLiteral(SHACL.BLANK_NODE_OR_LITERAL),
        IRIOrLiteral(SHACL.IRI_OR_LITERAL);

        IRI iri;

        private NodeKind(IRI iri) {
            this.iri = iri;
        }

        public static NodeKind from(Resource resource) {
            for (NodeKind value : NodeKind.values()) {
                if (!value.iri.equals((Object)resource)) continue;
                return value;
            }
            throw new IllegalStateException("Unknown nodeKind: " + resource);
        }
    }
}

