/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.AST;

import java.util.stream.Stream;
import org.eclipse.rdf4j.common.iteration.Iteration;
import org.eclipse.rdf4j.common.iteration.Iterations;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.impl.SimpleLiteral;
import org.eclipse.rdf4j.model.vocabulary.SHACL;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.sail.SailRepositoryConnection;
import org.eclipse.rdf4j.sail.shacl.AST.NodeShape;
import org.eclipse.rdf4j.sail.shacl.AST.PathPropertyShape;
import org.eclipse.rdf4j.sail.shacl.AST.StandardisedPlanHelper;
import org.eclipse.rdf4j.sail.shacl.ShaclSailConnection;
import org.eclipse.rdf4j.sail.shacl.SourceConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.planNodes.EnrichWithShape;
import org.eclipse.rdf4j.sail.shacl.planNodes.LoggingNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.MinLengthFilter;
import org.eclipse.rdf4j.sail.shacl.planNodes.PlanNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MinLengthPropertyShape
extends PathPropertyShape {
    private final long minLength;
    private static final Logger logger = LoggerFactory.getLogger(MinLengthPropertyShape.class);

    MinLengthPropertyShape(Resource id, SailRepositoryConnection connection, NodeShape nodeShape) {
        super(id, connection, nodeShape);
        try (Stream stream = Iterations.stream((Iteration)connection.getStatements(id, SHACL.MIN_LENGTH, null, true, new Resource[0]));){
            this.minLength = stream.map(Statement::getObject).map(v -> ((SimpleLiteral)v).integerValue().longValue()).findAny().orElseThrow(() -> new RuntimeException("Expected to find sh:minLength on " + id));
        }
    }

    @Override
    public PlanNode getPlan(ShaclSailConnection shaclSailConnection, NodeShape nodeShape, boolean printPlans, boolean assumeBaseSailValid) {
        PlanNode invalidValues = StandardisedPlanHelper.getGenericSingleObjectPlan(shaclSailConnection, nodeShape, (parent, trueNode, falseNode) -> new MinLengthFilter(parent, trueNode, falseNode, this.minLength), this);
        if (printPlans) {
            String planAsGraphvizDot = this.getPlanAsGraphvizDot(invalidValues, shaclSailConnection);
            logger.info(planAsGraphvizDot);
        }
        return new EnrichWithShape(new LoggingNode(invalidValues), this);
    }

    @Override
    public boolean requiresEvaluation(Repository addedStatements, Repository removedStatements) {
        return true;
    }

    @Override
    public SourceConstraintComponent getSourceConstraintComponent() {
        return SourceConstraintComponent.MinLengthConstraintComponent;
    }
}

