/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.AST;

import java.util.stream.Stream;
import org.eclipse.rdf4j.common.iteration.Iteration;
import org.eclipse.rdf4j.common.iteration.Iterations;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.model.vocabulary.SHACL;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.sail.SailRepositoryConnection;
import org.eclipse.rdf4j.sail.NotifyingSailConnection;
import org.eclipse.rdf4j.sail.shacl.AST.NodeShape;
import org.eclipse.rdf4j.sail.shacl.AST.PathPropertyShape;
import org.eclipse.rdf4j.sail.shacl.AST.TargetClass;
import org.eclipse.rdf4j.sail.shacl.ShaclSailConnection;
import org.eclipse.rdf4j.sail.shacl.SourceConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.planNodes.BulkedExternalLeftOuterJoin;
import org.eclipse.rdf4j.sail.shacl.planNodes.DirectTupleFromFilter;
import org.eclipse.rdf4j.sail.shacl.planNodes.EnrichWithShape;
import org.eclipse.rdf4j.sail.shacl.planNodes.GroupByCount;
import org.eclipse.rdf4j.sail.shacl.planNodes.LeftOuterJoin;
import org.eclipse.rdf4j.sail.shacl.planNodes.LoggingNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.MinCountFilter;
import org.eclipse.rdf4j.sail.shacl.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.Select;
import org.eclipse.rdf4j.sail.shacl.planNodes.TrimTuple;
import org.eclipse.rdf4j.sail.shacl.planNodes.UnionNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.Unique;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MinCountPropertyShape
extends PathPropertyShape {
    private long minCount;
    private static final Logger logger = LoggerFactory.getLogger(MinCountPropertyShape.class);
    private boolean optimizeWhenNoStatementsRemoved = true;

    MinCountPropertyShape(Resource id, SailRepositoryConnection connection, NodeShape nodeShape) {
        super(id, connection, nodeShape);
        try (Stream stream = Iterations.stream((Iteration)connection.getStatements(id, SHACL.MIN_COUNT, null, true, new Resource[0]));){
            this.minCount = stream.map(Statement::getObject).map(v -> (Literal)v).map(Literal::longValue).findAny().orElseThrow(() -> new RuntimeException("Expect to find sh:minCount on " + id));
        }
    }

    public String toString() {
        return "MinCountPropertyShape{minCount=" + this.minCount + '}';
    }

    @Override
    public PlanNode getPlan(ShaclSailConnection shaclSailConnection, NodeShape nodeShape, boolean printPlans, boolean assumeBaseSailValid) {
        LoggingNode topNode;
        if (!this.optimizeWhenNoStatementsRemoved || shaclSailConnection.stats.hasRemoved()) {
            LoggingNode planRemovedStatements;
            LoggingNode filteredPlanRemovedStatements = planRemovedStatements = new LoggingNode(new TrimTuple(new LoggingNode(super.getPlanRemovedStatements(shaclSailConnection, nodeShape)), 1));
            if (nodeShape instanceof TargetClass) {
                filteredPlanRemovedStatements = new LoggingNode(((TargetClass)nodeShape).getTypeFilterPlan((NotifyingSailConnection)shaclSailConnection, planRemovedStatements));
            }
            LoggingNode planAddedStatements = new LoggingNode(nodeShape.getPlanAddedStatements(shaclSailConnection, nodeShape));
            LoggingNode mergeNode = new LoggingNode(new UnionNode(planAddedStatements, filteredPlanRemovedStatements));
            LoggingNode unique = new LoggingNode(new Unique(mergeNode));
            if (assumeBaseSailValid) {
                topNode = new LoggingNode(new LeftOuterJoin(unique, super.getPlanAddedStatements(shaclSailConnection, nodeShape)));
            } else {
                PlanNode planAddedStatements1 = super.getPlanAddedStatements(shaclSailConnection, nodeShape);
                if (nodeShape instanceof TargetClass) {
                    planAddedStatements1 = new LoggingNode(((TargetClass)nodeShape).getTypeFilterPlan((NotifyingSailConnection)shaclSailConnection, planAddedStatements1));
                }
                topNode = new LoggingNode(new UnionNode(unique, planAddedStatements1));
            }
        } else {
            LoggingNode planAddedForShape = new LoggingNode(nodeShape.getPlanAddedStatements(shaclSailConnection, nodeShape));
            LoggingNode select = new LoggingNode(new Select(shaclSailConnection.getAddedStatements(), this.path.getQuery()));
            if (assumeBaseSailValid) {
                topNode = new LoggingNode(new LeftOuterJoin(planAddedForShape, select));
            } else {
                if (nodeShape instanceof TargetClass) {
                    select = new LoggingNode(((TargetClass)nodeShape).getTypeFilterPlan((NotifyingSailConnection)shaclSailConnection, select));
                }
                topNode = new LoggingNode(new UnionNode(planAddedForShape, select));
            }
        }
        LoggingNode groupBy = new LoggingNode(new GroupByCount(topNode));
        DirectTupleFromFilter filteredStatements = new DirectTupleFromFilter();
        new MinCountFilter(groupBy, null, filteredStatements, this.minCount);
        LoggingNode minCountFilter = new LoggingNode(filteredStatements);
        LoggingNode trimTuple = new LoggingNode(new TrimTuple(minCountFilter, 1));
        LoggingNode bulkedExternalLeftOuterJoin2 = new LoggingNode(new BulkedExternalLeftOuterJoin((PlanNode)trimTuple, (NotifyingSailConnection)shaclSailConnection, this.path.getQuery()));
        LoggingNode groupBy2 = new LoggingNode(new GroupByCount(bulkedExternalLeftOuterJoin2));
        DirectTupleFromFilter filteredStatements2 = new DirectTupleFromFilter();
        new MinCountFilter(groupBy2, null, filteredStatements2, this.minCount);
        if (printPlans) {
            String planAsGraphvizDot = this.getPlanAsGraphvizDot(filteredStatements2, shaclSailConnection);
            logger.info(planAsGraphvizDot);
        }
        return new EnrichWithShape(new LoggingNode(filteredStatements2), this);
    }

    @Override
    public boolean requiresEvaluation(Repository addedStatements, Repository removedStatements) {
        boolean requiresEvalutation = false;
        if (this.nodeShape instanceof TargetClass) {
            Resource targetClass = ((TargetClass)this.nodeShape).targetClass;
            try (RepositoryConnection addedStatementsConnection = addedStatements.getConnection();){
                requiresEvalutation = addedStatementsConnection.hasStatement(null, RDF.TYPE, (Value)targetClass, false, new Resource[0]);
            }
        } else {
            requiresEvalutation = true;
        }
        return super.requiresEvaluation(addedStatements, removedStatements) | requiresEvalutation;
    }

    @Override
    public SourceConstraintComponent getSourceConstraintComponent() {
        return SourceConstraintComponent.MinCountConstraintComponent;
    }
}

