/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.AST;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.rdf4j.common.iteration.Iteration;
import org.eclipse.rdf4j.common.iteration.Iterations;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.vocabulary.SHACL;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.sail.SailRepositoryConnection;
import org.eclipse.rdf4j.sail.shacl.AST.NodeShape;
import org.eclipse.rdf4j.sail.shacl.AST.PathPropertyShape;
import org.eclipse.rdf4j.sail.shacl.AST.StandardisedPlanHelper;
import org.eclipse.rdf4j.sail.shacl.ShaclSailConnection;
import org.eclipse.rdf4j.sail.shacl.SourceConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.planNodes.EnrichWithShape;
import org.eclipse.rdf4j.sail.shacl.planNodes.LanguageInFilter;
import org.eclipse.rdf4j.sail.shacl.planNodes.LoggingNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.PlanNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LanguageInPropertyShape
extends PathPropertyShape {
    private final List<String> languageIn;
    private static final Logger logger = LoggerFactory.getLogger(LanguageInPropertyShape.class);

    LanguageInPropertyShape(Resource id, SailRepositoryConnection connection, NodeShape nodeShape) {
        super(id, connection, nodeShape);
        try (Stream stream = Iterations.stream((Iteration)connection.getStatements(id, SHACL.LANGUAGE_IN, null, true, new Resource[0]));){
            Resource orList = stream.map(Statement::getObject).map(v -> (Resource)v).findAny().orElseThrow(() -> new RuntimeException("Expected to find sh:languageIn on " + id));
            this.languageIn = LanguageInPropertyShape.toList(connection, orList).stream().map(Value::stringValue).collect(Collectors.toList());
        }
    }

    @Override
    public PlanNode getPlan(ShaclSailConnection shaclSailConnection, NodeShape nodeShape, boolean printPlans, boolean assumeBaseSailValid) {
        PlanNode invalidValues = StandardisedPlanHelper.getGenericSingleObjectPlan(shaclSailConnection, nodeShape, (parent, trueNode, falseNode) -> new LanguageInFilter(parent, trueNode, falseNode, this.languageIn), this);
        if (printPlans) {
            String planAsGraphvizDot = this.getPlanAsGraphvizDot(invalidValues, shaclSailConnection);
            logger.info(planAsGraphvizDot);
        }
        return new EnrichWithShape(new LoggingNode(invalidValues), this);
    }

    @Override
    public boolean requiresEvaluation(Repository addedStatements, Repository removedStatements) {
        return true;
    }

    @Override
    public SourceConstraintComponent getSourceConstraintComponent() {
        return SourceConstraintComponent.LanguageInConstraintComponent;
    }
}

