/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.planNodes;

import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.Iterations;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.shacl.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.Tuple;

public class LoggingNode
implements PlanNode {
    PlanNode parent;
    boolean pullAll = true;
    public static boolean loggingEnabled = false;

    public LoggingNode(PlanNode parent) {
        this.parent = parent;
    }

    @Override
    public CloseableIteration<Tuple, SailException> iterator() {
        if (!loggingEnabled) {
            return this.parent.iterator();
        }
        return new CloseableIteration<Tuple, SailException>(){
            CloseableIteration<Tuple, SailException> parentIterator;
            {
                this.parentIterator = LoggingNode.this.parent.iterator();
                if (LoggingNode.this.pullAll) {
                    this.parentIterator = this.cachedIterator(this.parentIterator);
                }
            }

            private CloseableIteration<Tuple, SailException> cachedIterator(CloseableIteration<Tuple, SailException> fromIterator) {
                try (Stream stream = Iterations.stream(fromIterator);){
                    final List collect = stream.collect(Collectors.toList());
                    CloseableIteration<Tuple, SailException> closeableIteration = new CloseableIteration<Tuple, SailException>(){
                        Iterator<Tuple> iterator;
                        {
                            this.iterator = collect.iterator();
                        }

                        public void close() throws SailException {
                        }

                        public boolean hasNext() throws SailException {
                            return this.iterator.hasNext();
                        }

                        public Tuple next() throws SailException {
                            return this.iterator.next();
                        }

                        public void remove() throws SailException {
                        }
                    };
                    return closeableIteration;
                }
            }

            public void close() throws SailException {
                this.parentIterator.close();
            }

            public boolean hasNext() throws SailException {
                boolean hasNext = this.parentIterator.hasNext();
                return hasNext;
            }

            public Tuple next() throws SailException {
                assert (this.parentIterator.hasNext()) : this.parentIterator.getClass().getSimpleName() + " does not have any more items but next was still called!!!";
                Tuple next = (Tuple)this.parentIterator.next();
                assert (next != null);
                System.out.println(LoggingNode.this.leadingSpace() + LoggingNode.this.parent.getClass().getSimpleName() + ".next():  " + next.toString());
                return next;
            }

            public void remove() throws SailException {
            }
        };
    }

    @Override
    public int depth() {
        return this.parent.depth() + 1;
    }

    private String leadingSpace() {
        StringBuilder ret = new StringBuilder();
        int depth = this.depth();
        while (--depth > 0) {
            ret.append("    ");
        }
        return ret.toString();
    }
}

