/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.planNodes;

import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.shacl.planNodes.DepthProvider;
import org.eclipse.rdf4j.sail.shacl.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.PushBasedPlanNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.SupportsDepthProvider;
import org.eclipse.rdf4j.sail.shacl.planNodes.Tuple;
import org.eclipse.rdf4j.sail.shacl.planNodes.TupleHelper;

public class InnerJoin
implements PlanNode {
    PlanNode left;
    PlanNode right;
    PushBasedPlanNode discardedLeft;
    PushBasedPlanNode discardedRight;

    public InnerJoin(final PlanNode left, final PlanNode right, PushBasedPlanNode discardedLeft, PushBasedPlanNode discardedRight) {
        this.left = left;
        this.right = right;
        this.discardedLeft = discardedLeft;
        this.discardedRight = discardedRight;
        if (discardedLeft instanceof SupportsDepthProvider) {
            ((SupportsDepthProvider)((Object)discardedLeft)).receiveDepthProvider(new DepthProvider(){

                @Override
                public int depth() {
                    return Math.max(left.depth(), right.depth()) + 1;
                }
            });
        }
        if (discardedRight instanceof SupportsDepthProvider) {
            ((SupportsDepthProvider)((Object)discardedRight)).receiveDepthProvider(new DepthProvider(){

                @Override
                public int depth() {
                    return Math.max(left.depth(), right.depth()) + 1;
                }
            });
        }
    }

    @Override
    public CloseableIteration<Tuple, SailException> iterator() {
        return new CloseableIteration<Tuple, SailException>(){
            CloseableIteration<Tuple, SailException> leftIterator;
            CloseableIteration<Tuple, SailException> rightIterator;
            Tuple next;
            Tuple nextLeft;
            Tuple nextRight;
            {
                this.leftIterator = InnerJoin.this.left.iterator();
                this.rightIterator = InnerJoin.this.right.iterator();
            }

            void calculateNext() {
                if (this.next != null) {
                    return;
                }
                if (this.nextLeft == null && this.leftIterator.hasNext()) {
                    this.nextLeft = (Tuple)this.leftIterator.next();
                }
                if (this.nextRight == null && this.rightIterator.hasNext()) {
                    this.nextRight = (Tuple)this.rightIterator.next();
                }
                if (this.nextLeft == null) {
                    if (InnerJoin.this.discardedRight != null) {
                        while (this.nextRight != null) {
                            InnerJoin.this.discardedRight.push(this.nextRight);
                            if (this.rightIterator.hasNext()) {
                                this.nextRight = (Tuple)this.rightIterator.next();
                                continue;
                            }
                            this.nextRight = null;
                        }
                    }
                    return;
                }
                while (this.next == null) {
                    if (this.nextRight != null) {
                        if (this.nextLeft.line.get(0) == this.nextRight.line.get(0) || this.nextLeft.line.get(0).equals(this.nextRight.line.get(0))) {
                            this.next = TupleHelper.join(this.nextLeft, this.nextRight);
                            this.nextRight = null;
                            continue;
                        }
                        int compareTo = this.nextLeft.compareTo(this.nextRight);
                        if (compareTo < 0) {
                            if (InnerJoin.this.discardedLeft != null) {
                                InnerJoin.this.discardedLeft.push(this.nextLeft);
                            }
                            if (this.leftIterator.hasNext()) {
                                this.nextLeft = (Tuple)this.leftIterator.next();
                                continue;
                            }
                            this.nextLeft = null;
                            break;
                        }
                        if (InnerJoin.this.discardedRight != null) {
                            InnerJoin.this.discardedRight.push(this.nextRight);
                        }
                        if (this.rightIterator.hasNext()) {
                            this.nextRight = (Tuple)this.rightIterator.next();
                            continue;
                        }
                        this.nextRight = null;
                        break;
                    }
                    return;
                }
            }

            public void close() throws SailException {
                this.leftIterator.close();
                this.rightIterator.close();
            }

            public boolean hasNext() throws SailException {
                this.calculateNext();
                return this.next != null;
            }

            public Tuple next() throws SailException {
                this.calculateNext();
                Tuple temp = this.next;
                this.next = null;
                return temp;
            }

            public void remove() throws SailException {
            }
        };
    }

    @Override
    public int depth() {
        return Math.max(this.left.depth(), this.right.depth());
    }
}

