/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.planNodes;

import java.util.Arrays;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.sail.NotifyingSailConnection;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.shacl.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.Tuple;

public class ExternalTypeFilterNode
implements PlanNode {
    NotifyingSailConnection shaclSailConnection;
    Resource filterOnType;
    PlanNode parent;

    public ExternalTypeFilterNode(NotifyingSailConnection shaclSailConnection, Resource filterOnType, PlanNode parent) {
        this.shaclSailConnection = shaclSailConnection;
        this.filterOnType = filterOnType;
        this.parent = parent;
    }

    @Override
    public CloseableIteration<Tuple, SailException> iterator() {
        return new CloseableIteration<Tuple, SailException>(){
            Tuple next = null;
            CloseableIteration<Tuple, SailException> parentIterator;
            {
                this.parentIterator = ExternalTypeFilterNode.this.parent.iterator();
            }

            void calculateNext() {
                while (this.next == null && this.parentIterator.hasNext()) {
                    Tuple temp = (Tuple)this.parentIterator.next();
                    Resource subject = (Resource)temp.line.get(0);
                    if (!ExternalTypeFilterNode.this.shaclSailConnection.hasStatement(subject, RDF.TYPE, (Value)ExternalTypeFilterNode.this.filterOnType, true, new Resource[0])) continue;
                    this.next = temp;
                    this.next.addHistory(new Tuple(Arrays.asList(subject, RDF.TYPE, ExternalTypeFilterNode.this.filterOnType)));
                }
            }

            public void close() throws SailException {
                this.parentIterator.close();
            }

            public boolean hasNext() throws SailException {
                this.calculateNext();
                return this.next != null;
            }

            public Tuple next() throws SailException {
                this.calculateNext();
                Tuple temp = this.next;
                this.next = null;
                return temp;
            }

            public void remove() throws SailException {
            }
        };
    }

    @Override
    public int depth() {
        return this.parent.depth() + 1;
    }
}

