/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.AST;

import java.util.stream.Stream;
import org.eclipse.rdf4j.common.iteration.Iteration;
import org.eclipse.rdf4j.common.iteration.Iterations;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.vocabulary.SHACL;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.sail.SailRepositoryConnection;
import org.eclipse.rdf4j.sail.NotifyingSailConnection;
import org.eclipse.rdf4j.sail.shacl.AST.PathPropertyShape;
import org.eclipse.rdf4j.sail.shacl.AST.Shape;
import org.eclipse.rdf4j.sail.shacl.AST.TargetClass;
import org.eclipse.rdf4j.sail.shacl.ShaclSailConnection;
import org.eclipse.rdf4j.sail.shacl.planNodes.BufferedTupleFromFilter;
import org.eclipse.rdf4j.sail.shacl.planNodes.BulkedExternalLeftOuterJoin;
import org.eclipse.rdf4j.sail.shacl.planNodes.DirectTupleFromFilter;
import org.eclipse.rdf4j.sail.shacl.planNodes.GroupByCount;
import org.eclipse.rdf4j.sail.shacl.planNodes.LoggingNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.MaxCountFilter;
import org.eclipse.rdf4j.sail.shacl.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.TrimTuple;
import org.eclipse.rdf4j.sail.shacl.planNodes.UnionNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.Unique;

public class MaxCountPropertyShape
extends PathPropertyShape {
    private long maxCount;

    MaxCountPropertyShape(Resource id, SailRepositoryConnection connection, Shape shape) {
        super(id, connection, shape);
        try (Stream stream = Iterations.stream((Iteration)connection.getStatements(id, SHACL.MAX_COUNT, null, true, new Resource[0]));){
            this.maxCount = stream.map(Statement::getObject).map(v -> (Literal)v).map(Literal::longValue).findAny().orElseThrow(() -> new RuntimeException("Expected to find sh:maxCount on " + id));
        }
    }

    public String toString() {
        return "MaxCountPropertyShape{maxCount=" + this.maxCount + '}';
    }

    @Override
    public PlanNode getPlan(ShaclSailConnection shaclSailConnection, Shape shape) {
        LoggingNode planAddedStatements = new LoggingNode(shape.getPlanAddedStatements(shaclSailConnection, shape));
        LoggingNode planAddedStatements1 = new LoggingNode(super.getPlanAddedStatements(shaclSailConnection, shape));
        if (shape instanceof TargetClass) {
            planAddedStatements1 = new LoggingNode(((TargetClass)shape).getTypeFilterPlan((NotifyingSailConnection)shaclSailConnection, planAddedStatements1));
        }
        LoggingNode mergeNode = new LoggingNode(new UnionNode(planAddedStatements, planAddedStatements1));
        LoggingNode groupByCount1 = new LoggingNode(new GroupByCount(mergeNode));
        BufferedTupleFromFilter validValues = new BufferedTupleFromFilter();
        BufferedTupleFromFilter invalidValues = new BufferedTupleFromFilter();
        new MaxCountFilter(groupByCount1, validValues, invalidValues, this.maxCount);
        LoggingNode trimmed = new LoggingNode(new TrimTuple(validValues, 1));
        LoggingNode unique = new LoggingNode(new Unique(trimmed));
        LoggingNode bulkedExternalLeftOuterJoin = new LoggingNode(new BulkedExternalLeftOuterJoin((PlanNode)unique, (NotifyingSailConnection)shaclSailConnection, this.path.getQuery()));
        LoggingNode groupByCount = new LoggingNode(new GroupByCount(bulkedExternalLeftOuterJoin));
        DirectTupleFromFilter directTupleFromFilter = new DirectTupleFromFilter();
        new MaxCountFilter(groupByCount, null, directTupleFromFilter, this.maxCount);
        UnionNode mergeNode1 = new UnionNode(new LoggingNode(directTupleFromFilter), new LoggingNode(invalidValues));
        return new LoggingNode(mergeNode1);
    }

    @Override
    public boolean requiresEvaluation(Repository addedStatements, Repository removedStatements) {
        return true;
    }
}

