/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.planNodes;

import java.util.Arrays;
import java.util.List;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.shacl.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.Tuple;

public class GroupByCount
implements PlanNode {
    PlanNode parent;

    public GroupByCount(PlanNode parent) {
        this.parent = parent;
    }

    @Override
    public CloseableIteration<Tuple, SailException> iterator() {
        return new CloseableIteration<Tuple, SailException>(){
            CloseableIteration<Tuple, SailException> parentIterator;
            Tuple tempNext;
            Tuple next;
            {
                this.parentIterator = GroupByCount.this.parent.iterator();
            }

            private void calculateNext() {
                if (this.next != null) {
                    return;
                }
                if (this.tempNext == null && this.parentIterator.hasNext()) {
                    this.tempNext = (Tuple)this.parentIterator.next();
                }
                if (this.tempNext == null) {
                    return;
                }
                long count = 0L;
                this.next = new Tuple();
                Value subject = this.tempNext.line.get(0);
                while (this.tempNext != null && (this.tempNext.line.get(0) == subject || this.tempNext.line.get(0).equals(subject))) {
                    this.next.addHistory(this.tempNext);
                    if (this.tempNext.line.size() > 1) {
                        ++count;
                    }
                    if (this.parentIterator.hasNext()) {
                        this.tempNext = (Tuple)this.parentIterator.next();
                        continue;
                    }
                    this.tempNext = null;
                }
                List<Value> line = Arrays.asList(subject, SimpleValueFactory.getInstance().createLiteral(count));
                this.next.line = line;
            }

            public void close() throws SailException {
                this.parentIterator.close();
            }

            public boolean hasNext() throws SailException {
                this.calculateNext();
                return this.next != null;
            }

            public Tuple next() throws SailException {
                this.calculateNext();
                Tuple temp = this.next;
                this.next = null;
                return temp;
            }

            public void remove() throws SailException {
            }
        };
    }

    @Override
    public int depth() {
        return this.parent.depth() + 1;
    }
}

