/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.planNodes;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.stream.Stream;
import org.eclipse.rdf4j.IsolationLevel;
import org.eclipse.rdf4j.IsolationLevels;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.Iteration;
import org.eclipse.rdf4j.common.iteration.Iterations;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.impl.MapBindingSet;
import org.eclipse.rdf4j.query.parser.ParsedQuery;
import org.eclipse.rdf4j.query.parser.QueryParserFactory;
import org.eclipse.rdf4j.query.parser.QueryParserRegistry;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.sail.NotifyingSailConnection;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.shacl.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.Tuple;
import org.eclipse.rdf4j.sail.shacl.planNodes.TupleHelper;

public class BulkedExternalLeftOuterJoin
implements PlanNode {
    private IRI predicate;
    NotifyingSailConnection baseSailConnection;
    PlanNode leftNode;
    Repository repository;
    String query;

    public BulkedExternalLeftOuterJoin(PlanNode leftNode, Repository repository, String query) {
        this.leftNode = leftNode;
        this.repository = repository;
        this.query = query;
    }

    public BulkedExternalLeftOuterJoin(PlanNode leftNode, Repository repository, IRI predicate) {
        this.leftNode = leftNode;
        this.repository = repository;
        this.predicate = predicate;
    }

    public BulkedExternalLeftOuterJoin(PlanNode leftNode, NotifyingSailConnection baseSailConnection, String query) {
        this.leftNode = leftNode;
        this.query = query;
        this.baseSailConnection = baseSailConnection;
    }

    @Override
    public CloseableIteration<Tuple, SailException> iterator() {
        return new CloseableIteration<Tuple, SailException>(){
            LinkedList<Tuple> left = new LinkedList();
            LinkedList<Tuple> right = new LinkedList();
            CloseableIteration<Tuple, SailException> leftNodeIterator;
            {
                this.leftNodeIterator = BulkedExternalLeftOuterJoin.this.leftNode.iterator();
            }

            private void calculateNext() {
                if (!this.left.isEmpty()) {
                    return;
                }
                while (this.left.size() < 100 && this.leftNodeIterator.hasNext()) {
                    this.left.addFirst((Tuple)this.leftNodeIterator.next());
                }
                if (this.left.isEmpty()) {
                    return;
                }
                if (BulkedExternalLeftOuterJoin.this.query != null) {
                    StringBuilder newQuery = new StringBuilder("select * where { VALUES (?a) { \n");
                    this.left.stream().map(tuple -> tuple.line.get(0)).map(v -> (Resource)v).forEach(r -> newQuery.append("( <").append(r.toString()).append("> )\n"));
                    newQuery.append("\n}").append(BulkedExternalLeftOuterJoin.this.query).append("} order by ?a");
                    if (BulkedExternalLeftOuterJoin.this.repository != null) {
                        try (RepositoryConnection connection = BulkedExternalLeftOuterJoin.this.repository.getConnection();){
                            connection.begin((IsolationLevel)IsolationLevels.NONE);
                            try (Stream stream = Iterations.stream((Iteration)connection.prepareTupleQuery(newQuery.toString()).evaluate());){
                                stream.map(Tuple::new).forEach(this.right::addFirst);
                            }
                            connection.commit();
                        }
                    }
                    QueryParserFactory queryParserFactory = (QueryParserFactory)QueryParserRegistry.getInstance().get((Object)QueryLanguage.SPARQL).get();
                    ParsedQuery parsedQuery = queryParserFactory.getParser().parseQuery(newQuery.toString(), null);
                    try (CloseableIteration evaluate = BulkedExternalLeftOuterJoin.this.baseSailConnection.evaluate(parsedQuery.getTupleExpr(), parsedQuery.getDataset(), (BindingSet)new MapBindingSet(), true);){
                        while (evaluate.hasNext()) {
                            BindingSet next2 = (BindingSet)evaluate.next();
                            this.right.addFirst(new Tuple(next2));
                        }
                    }
                }
                try (RepositoryConnection connection = BulkedExternalLeftOuterJoin.this.repository.getConnection();){
                    connection.begin((IsolationLevel)IsolationLevels.NONE);
                    for (Tuple tuple2 : this.left) {
                        Stream stream = Iterations.stream((Iteration)connection.getStatements((Resource)tuple2.line.get(0), BulkedExternalLeftOuterJoin.this.predicate, null, new Resource[0]));
                        Throwable throwable = null;
                        try {
                            stream.forEach(next -> this.right.addFirst(new Tuple(Arrays.asList(next.getSubject(), next.getObject()))));
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (stream == null) continue;
                            if (throwable != null) {
                                try {
                                    stream.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            stream.close();
                        }
                    }
                    connection.commit();
                }
            }

            public void close() throws SailException {
                this.leftNodeIterator.close();
            }

            public boolean hasNext() throws SailException {
                this.calculateNext();
                return !this.left.isEmpty();
            }

            public Tuple next() throws SailException {
                this.calculateNext();
                if (!this.left.isEmpty()) {
                    Tuple leftPeek = this.left.peekLast();
                    Tuple joined = null;
                    if (!this.right.isEmpty()) {
                        Tuple rightPeek = this.right.peekLast();
                        if (rightPeek.line.get(0) == leftPeek.line.get(0) || rightPeek.line.get(0).equals(leftPeek.line.get(0))) {
                            joined = TupleHelper.join(leftPeek, rightPeek);
                            this.right.removeLast();
                            Tuple rightPeek2 = this.right.peekLast();
                            if (rightPeek2 == null || !rightPeek2.line.get(0).equals(leftPeek.line.get(0))) {
                                this.left.removeLast();
                            }
                        }
                    }
                    if (joined != null) {
                        return joined;
                    }
                    this.left.removeLast();
                    return leftPeek;
                }
                return null;
            }

            public void remove() throws SailException {
            }
        };
    }

    @Override
    public int depth() {
        return this.leftNode.depth() + 1;
    }
}

