/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.planNodes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.BindingSet;

public class Tuple
implements Comparable<Tuple> {
    private List<Tuple> history = new ArrayList<Tuple>();
    public List<Value> line = new ArrayList<Value>();

    public Tuple(List<Value> list) {
        this.line = list;
    }

    public Tuple(List<Value> list, Tuple historyTuple) {
        this.line = list;
        this.addHistory(historyTuple);
    }

    public Tuple() {
    }

    public Tuple(BindingSet bindingset) {
        bindingset.getBindingNames().stream().sorted().forEach(name -> this.line.add(bindingset.getValue(name)));
    }

    public List<Value> getlist() {
        return this.line;
    }

    public String toString() {
        return "Tuple{line=" + Arrays.toString(this.line.toArray()) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Tuple tuple = (Tuple)o;
        if (tuple.line.size() != this.line.size()) {
            return false;
        }
        for (int i = 0; i < this.line.size(); ++i) {
            if (this.line.get(i) == tuple.line.get(i) || this.line.get(i).equals(tuple.line.get(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.line);
    }

    @Override
    public int compareTo(Tuple o) {
        for (int i = 0; i < Math.min(o.line.size(), this.line.size()); ++i) {
            int compareTo = this.line.get(i).toString().compareTo(o.line.get(i).toString());
            if (compareTo == 0) continue;
            return compareTo;
        }
        return 0;
    }

    public String getCause() {
        return "[ " + String.join((CharSequence)" , ", this.history.stream().distinct().map(Object::toString).collect(Collectors.toList())) + " ]";
    }

    public void addHistory(Tuple tuple) {
        this.history.addAll(tuple.history);
        this.history.add(tuple);
    }
}

