/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.AST;

import java.util.stream.Stream;
import org.eclipse.rdf4j.common.iteration.Iteration;
import org.eclipse.rdf4j.common.iteration.Iterations;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.model.vocabulary.SHACL;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.sail.SailRepositoryConnection;
import org.eclipse.rdf4j.sail.shacl.AST.Shape;
import org.eclipse.rdf4j.sail.shacl.ShaclSailConnection;
import org.eclipse.rdf4j.sail.shacl.planNodes.ExternalTypeFilterNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.LoggingNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.Select;
import org.eclipse.rdf4j.sail.shacl.planNodes.TrimTuple;

public class TargetClass
extends Shape {
    Resource targetClass;

    TargetClass(Resource id, SailRepositoryConnection connection) {
        super(id, connection);
        try (Stream stream = Iterations.stream((Iteration)connection.getStatements(id, SHACL.TARGET_CLASS, null, new Resource[0]));){
            this.targetClass = stream.map(Statement::getObject).map(v -> (Resource)v).findAny().orElseThrow(() -> new RuntimeException("Expected to find sh:targetClass on " + id));
        }
    }

    @Override
    public PlanNode getPlan(ShaclSailConnection shaclSailConnection, Shape shape) {
        return new TrimTuple(new LoggingNode(new Select(shaclSailConnection, this.getQuery())), 1);
    }

    @Override
    public PlanNode getPlanAddedStatements(ShaclSailConnection shaclSailConnection, Shape shape) {
        return new TrimTuple(new LoggingNode(new Select(shaclSailConnection.addedStatements, this.getQuery())), 1);
    }

    @Override
    public PlanNode getPlanRemovedStatements(ShaclSailConnection shaclSailConnection, Shape shape) {
        return new Select(shaclSailConnection.removedStatements, this.getQuery());
    }

    @Override
    public boolean requiresEvalutation(Repository addedStatements, Repository removedStatements) {
        boolean requiresEvalutation;
        try (RepositoryConnection addedStatementsConnection = addedStatements.getConnection();){
            requiresEvalutation = addedStatementsConnection.hasStatement(null, RDF.TYPE, (Value)this.targetClass, false, new Resource[0]);
        }
        return super.requiresEvalutation(addedStatements, removedStatements) || requiresEvalutation;
    }

    @Override
    public String getQuery() {
        return "BIND(rdf:type as ?b) \n BIND(<" + this.targetClass + "> as ?c) \n ?a ?b ?c.";
    }

    public PlanNode getTypeFilterPlan(ShaclSailConnection shaclSailConnection, PlanNode parent) {
        return new ExternalTypeFilterNode(shaclSailConnection, this.targetClass, parent);
    }
}

