/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.AST;

import java.util.stream.Stream;
import org.eclipse.rdf4j.common.iteration.Iteration;
import org.eclipse.rdf4j.common.iteration.Iterations;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.model.vocabulary.SHACL;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.sail.SailRepositoryConnection;
import org.eclipse.rdf4j.sail.shacl.AST.PathPropertyShape;
import org.eclipse.rdf4j.sail.shacl.AST.Shape;
import org.eclipse.rdf4j.sail.shacl.AST.TargetClass;
import org.eclipse.rdf4j.sail.shacl.ShaclSailConnection;
import org.eclipse.rdf4j.sail.shacl.planNodes.BulkedExternalLeftOuterJoin;
import org.eclipse.rdf4j.sail.shacl.planNodes.DirectTupleFromFilter;
import org.eclipse.rdf4j.sail.shacl.planNodes.GroupByCount;
import org.eclipse.rdf4j.sail.shacl.planNodes.LeftOuterJoin;
import org.eclipse.rdf4j.sail.shacl.planNodes.LoggingNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.MergeNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.MinCountFilter;
import org.eclipse.rdf4j.sail.shacl.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.Select;
import org.eclipse.rdf4j.sail.shacl.planNodes.TrimTuple;
import org.eclipse.rdf4j.sail.shacl.planNodes.Unique;

public class MinCountPropertyShape
extends PathPropertyShape {
    private long minCount;
    private boolean optimizeWhenNoStatementsRemoved = true;

    MinCountPropertyShape(Resource id, SailRepositoryConnection connection, Shape shape) {
        super(id, connection, shape);
        try (Stream stream = Iterations.stream((Iteration)connection.getStatements(id, SHACL.MIN_COUNT, null, true, new Resource[0]));){
            this.minCount = stream.map(Statement::getObject).map(v -> (Literal)v).map(Literal::longValue).findAny().orElseThrow(() -> new RuntimeException("Expect to find sh:minCount on " + id));
        }
    }

    public String toString() {
        return "MinCountPropertyShape{maxCount=" + this.minCount + '}';
    }

    @Override
    public PlanNode getPlan(ShaclSailConnection shaclSailConnection, Shape shape) {
        LoggingNode topNode;
        if (!this.optimizeWhenNoStatementsRemoved || shaclSailConnection.stats.hasRemoved()) {
            LoggingNode planRemovedStatements;
            LoggingNode filteredPlanRemovedStatements = planRemovedStatements = new LoggingNode(new TrimTuple(new LoggingNode(super.getPlanRemovedStatements(shaclSailConnection, shape)), 1));
            if (shape instanceof TargetClass) {
                filteredPlanRemovedStatements = new LoggingNode(((TargetClass)shape).getTypeFilterPlan(shaclSailConnection, planRemovedStatements));
            }
            TrimTuple planAddedStatements = new TrimTuple(new LoggingNode(shape.getPlanAddedStatements(shaclSailConnection, shape)), 1);
            LoggingNode mergeNode = new LoggingNode(new MergeNode(planAddedStatements, filteredPlanRemovedStatements));
            LoggingNode unique = new LoggingNode(new Unique(mergeNode));
            topNode = new LoggingNode(new LeftOuterJoin(unique, super.getPlanAddedStatements(shaclSailConnection, shape)));
        } else {
            String query = shape.getQuery();
            query = query + "\n OPTIONAL { " + this.path.getQuery() + " }";
            topNode = new LoggingNode(new TrimTuple(new Select(shaclSailConnection.addedStatements, query), 1));
        }
        LoggingNode groupBy = new LoggingNode(new GroupByCount(topNode));
        DirectTupleFromFilter filteredStatements = new DirectTupleFromFilter();
        new MinCountFilter(groupBy, null, filteredStatements, this.minCount);
        LoggingNode minCountFilter = new LoggingNode(filteredStatements);
        LoggingNode trimTuple = new LoggingNode(new TrimTuple(minCountFilter, 1));
        LoggingNode bulkedExternalLeftOuterJoin2 = new LoggingNode(new BulkedExternalLeftOuterJoin((PlanNode)trimTuple, shaclSailConnection, this.path.getQuery()));
        LoggingNode groupBy2 = new LoggingNode(new GroupByCount(bulkedExternalLeftOuterJoin2));
        DirectTupleFromFilter filteredStatements2 = new DirectTupleFromFilter();
        new MinCountFilter(groupBy2, null, filteredStatements2, this.minCount);
        return new LoggingNode(filteredStatements2);
    }

    @Override
    public boolean requiresEvalutation(Repository addedStatements, Repository removedStatements) {
        boolean requiresEvalutation = false;
        if (this.shape instanceof TargetClass) {
            Resource targetClass = ((TargetClass)this.shape).targetClass;
            try (RepositoryConnection addedStatementsConnection = addedStatements.getConnection();){
                requiresEvalutation = addedStatementsConnection.hasStatement(null, RDF.TYPE, (Value)targetClass, false, new Resource[0]);
            }
        } else {
            requiresEvalutation = true;
        }
        return super.requiresEvalutation(addedStatements, removedStatements) | requiresEvalutation;
    }
}

