/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.planNodes;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.shacl.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.Tuple;

public class MergeNode
implements PlanNode {
    PlanNode[] nodes;

    public MergeNode(PlanNode ... nodes) {
        this.nodes = nodes;
    }

    @Override
    public CloseableIteration<Tuple, SailException> iterator() {
        return new CloseableIteration<Tuple, SailException>(){
            List<CloseableIteration<Tuple, SailException>> iterators;
            Tuple[] peekList;
            Tuple next;
            {
                this.iterators = Arrays.stream(MergeNode.this.nodes).map(PlanNode::iterator).collect(Collectors.toList());
                this.peekList = new Tuple[MergeNode.this.nodes.length];
            }

            private void calculateNext() {
                if (this.next != null) {
                    return;
                }
                for (int i = 0; i < this.peekList.length; ++i) {
                    CloseableIteration<Tuple, SailException> iterator;
                    if (this.peekList[i] != null || !(iterator = this.iterators.get(i)).hasNext()) continue;
                    this.peekList[i] = (Tuple)iterator.next();
                }
                Tuple sortedFirst = null;
                int sortedFirstIndex = -1;
                for (int i = 0; i < this.peekList.length; ++i) {
                    if (this.peekList[i] == null) continue;
                    if (sortedFirst == null) {
                        sortedFirst = this.peekList[i];
                        sortedFirstIndex = i;
                        continue;
                    }
                    if (this.peekList[i].compareTo(sortedFirst) >= 0) continue;
                    sortedFirst = this.peekList[i];
                    sortedFirstIndex = i;
                }
                if (sortedFirstIndex >= 0) {
                    this.peekList[sortedFirstIndex] = null;
                }
                this.next = sortedFirst;
            }

            public void close() throws SailException {
                this.iterators.forEach(CloseableIteration::close);
            }

            public boolean hasNext() throws SailException {
                this.calculateNext();
                return this.next != null;
            }

            public Tuple next() throws SailException {
                this.calculateNext();
                Tuple temp = this.next;
                this.next = null;
                return temp;
            }

            public void remove() throws SailException {
            }
        };
    }

    @Override
    public int depth() {
        return Arrays.stream(this.nodes).mapToInt(PlanNode::depth).max().orElse(0) + 1;
    }
}

