/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.planNodes;

import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.shacl.planNodes.DepthProvider;
import org.eclipse.rdf4j.sail.shacl.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.PushBasedPlanNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.SupportsDepthProvider;
import org.eclipse.rdf4j.sail.shacl.planNodes.Tuple;

public abstract class FilterPlanNode<T extends PushBasedPlanNode & SupportsDepthProvider>
implements DepthProvider {
    PlanNode parent;
    T trueNode;
    T falseNode;

    abstract boolean checkTuple(Tuple var1);

    public FilterPlanNode(PlanNode parent, T trueNode, T falseNode) {
        this.parent = parent;
        this.trueNode = trueNode;
        this.falseNode = falseNode;
        CloseableIteration<Tuple, SailException> iterator = this.iterator();
        if (trueNode != null) {
            trueNode.parentIterator(iterator);
            ((SupportsDepthProvider)trueNode).receiveDepthProvider(this);
        }
        if (falseNode != null) {
            falseNode.parentIterator(iterator);
            ((SupportsDepthProvider)falseNode).receiveDepthProvider(this);
        }
    }

    private CloseableIteration<Tuple, SailException> iterator() {
        return new CloseableIteration<Tuple, SailException>(){
            CloseableIteration<Tuple, SailException> parentIterator;
            Tuple next;
            boolean closed;
            {
                this.parentIterator = FilterPlanNode.this.parent.iterator();
                this.closed = false;
            }

            private void calculateNext() {
                if (this.next != null) {
                    return;
                }
                while (this.parentIterator.hasNext() && this.next == null) {
                    Tuple temp = (Tuple)this.parentIterator.next();
                    if (FilterPlanNode.this.checkTuple(temp)) {
                        if (FilterPlanNode.this.trueNode != null) {
                            FilterPlanNode.this.trueNode.push(temp);
                        }
                    } else if (FilterPlanNode.this.falseNode != null) {
                        FilterPlanNode.this.falseNode.push(temp);
                    }
                    this.next = temp;
                }
            }

            public void close() throws SailException {
                if (this.closed) {
                    return;
                }
                this.closed = true;
                this.parentIterator.close();
            }

            public boolean hasNext() throws SailException {
                this.calculateNext();
                if (this.next == null) {
                    this.close();
                }
                return this.next != null;
            }

            public Tuple next() throws SailException {
                Tuple temp = this.next;
                this.next = null;
                return temp;
            }

            public void remove() throws SailException {
            }
        };
    }

    @Override
    public int depth() {
        return this.parent.depth() + 1;
    }
}

