/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.testsuite.sail;

import java.util.Random;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.sail.Sail;
import org.eclipse.rdf4j.sail.SailConnection;
import org.eclipse.rdf4j.sail.SailException;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public abstract class SailInterruptTest {
    private Sail store;
    private ValueFactory vf;

    @BeforeAll
    public static void setUpClass() {
        System.setProperty("org.eclipse.rdf4j.repository.debug", "true");
    }

    @AfterAll
    public static void afterClass() throws Exception {
        System.setProperty("org.eclipse.rdf4j.repository.debug", "false");
    }

    @BeforeEach
    public void setUp() {
        this.store = this.createSail();
        this.store.init();
        this.vf = this.store.getValueFactory();
    }

    protected abstract Sail createSail() throws SailException;

    @AfterEach
    public void tearDown() {
        this.store.shutDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testQueryInterrupt() throws Exception {
        Random r = new Random(12345L);
        try (SailConnection con = this.store.getConnection();){
            con.begin();
            for (int i = 0; i < 1000; ++i) {
                this.insertTestStatement(con, r.nextInt());
            }
            con.commit();
        }
        Runnable queryJob = () -> {
            while (!Thread.currentThread().isInterrupted()) {
                try {
                    this.iterateStatements();
                }
                catch (Throwable throwable) {}
            }
        };
        Thread queryThread = new Thread(queryJob);
        queryThread.start();
        queryThread.join(50L);
        queryThread.interrupt();
        queryThread.join();
        this.iterateStatements();
    }

    private void insertTestStatement(SailConnection connection, int seed) throws SailException {
        IRI subj = this.vf.createIRI("http://test#s" + seed % 293);
        IRI pred = this.vf.createIRI("http://test#p" + seed % 29);
        Literal obj = this.vf.createLiteral(Integer.toString(seed % 2903));
        connection.addStatement((Resource)subj, pred, (Value)obj, new Resource[0]);
    }

    private void iterateStatements() throws SailException {
        try (SailConnection con = this.store.getConnection();
             CloseableIteration iter = con.getStatements(null, null, null, true, new Resource[0]);){
            while (iter.hasNext()) {
                iter.next();
            }
        }
    }
}

