/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.testsuite.sail;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Iterator;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Namespace;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Triple;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.base.CoreDatatype;
import org.eclipse.rdf4j.model.util.Values;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.model.vocabulary.RDFS;
import org.eclipse.rdf4j.model.vocabulary.XSD;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.impl.EmptyBindingSet;
import org.eclipse.rdf4j.query.impl.MapBindingSet;
import org.eclipse.rdf4j.query.parser.ParsedTupleQuery;
import org.eclipse.rdf4j.query.parser.QueryParserUtil;
import org.eclipse.rdf4j.sail.Sail;
import org.eclipse.rdf4j.sail.SailConnection;
import org.eclipse.rdf4j.sail.SailException;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=60L)
public abstract class RDFStoreTest {
    private static final String EXAMPLE_NS = "http://example.org/";
    private static final String PAINTER = "Painter";
    private static final String PAINTS = "paints";
    private static final String PAINTING = "Painting";
    private static final String PICASSO = "picasso";
    private static final String REMBRANDT = "rembrandt";
    private static final String GUERNICA = "guernica";
    private static final String NIGHTWATCH = "nightwatch";
    private static final String CONTEXT_1 = "context1";
    private static final String CONTEXT_2 = "context2";
    protected IRI painter;
    protected IRI paints;
    protected IRI painting;
    protected IRI picasso;
    protected IRI rembrandt;
    protected IRI guernica;
    protected IRI nightwatch;
    protected IRI context1;
    protected IRI context2;
    protected Sail sail;
    protected SailConnection con;
    protected ValueFactory vf;

    @BeforeAll
    public static void setUpClass() {
        System.setProperty("org.eclipse.rdf4j.repository.debug", "true");
    }

    @AfterAll
    public static void afterClass() throws Exception {
        System.setProperty("org.eclipse.rdf4j.repository.debug", "false");
    }

    protected abstract Sail createSail();

    @BeforeEach
    public void setUp() {
        this.sail = this.createSail();
        this.con = this.sail.getConnection();
        this.vf = this.sail.getValueFactory();
        this.painter = this.vf.createIRI(EXAMPLE_NS, PAINTER);
        this.paints = this.vf.createIRI(EXAMPLE_NS, PAINTS);
        this.painting = this.vf.createIRI(EXAMPLE_NS, PAINTING);
        this.picasso = this.vf.createIRI(EXAMPLE_NS, PICASSO);
        this.guernica = this.vf.createIRI(EXAMPLE_NS, GUERNICA);
        this.rembrandt = this.vf.createIRI(EXAMPLE_NS, REMBRANDT);
        this.nightwatch = this.vf.createIRI(EXAMPLE_NS, NIGHTWATCH);
        this.context1 = this.vf.createIRI(EXAMPLE_NS, CONTEXT_1);
        this.context2 = this.vf.createIRI(EXAMPLE_NS, CONTEXT_2);
    }

    @AfterEach
    public void tearDown() {
        block7: {
            try {
                if (!this.con.isOpen()) break block7;
                try {
                    if (this.con.isActive()) {
                        this.con.rollback();
                    }
                }
                finally {
                    this.con.close();
                }
            }
            finally {
                this.sail.shutDown();
                this.sail = null;
            }
        }
    }

    @Test
    public void testEmptyRepository() {
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)this.countAllElements(), (String)"Empty repository should not return any statements");
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)this.countContext1Elements(), (String)"Named context should be empty");
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)this.countElements(this.con.getContextIDs()), (String)"Empty repository should not return any context identifiers");
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)this.countQueryResults("select * where { ?s ?p ?o}"), (String)"Empty repository should not return any query results");
    }

    @Test
    public void testValueRoundTrip1() {
        IRI subj = this.vf.createIRI("http://example.org/picasso");
        IRI pred = this.vf.createIRI("http://example.org/paints");
        IRI obj = this.vf.createIRI("http://example.org/guernica");
        this.testValueRoundTrip((Resource)subj, pred, (Value)obj);
    }

    @Test
    public void testValueRoundTrip2() {
        BNode subj = this.vf.createBNode();
        IRI pred = this.vf.createIRI("http://example.org/paints");
        IRI obj = this.vf.createIRI("http://example.org/guernica");
        this.testValueRoundTrip((Resource)subj, pred, (Value)obj);
    }

    @Test
    public void testValueRoundTrip3() {
        IRI subj = this.vf.createIRI("http://example.org/picasso");
        IRI pred = this.vf.createIRI("http://example.org/paints");
        Literal obj = this.vf.createLiteral(GUERNICA);
        this.testValueRoundTrip((Resource)subj, pred, (Value)obj);
    }

    @Test
    public void testValueRoundTrip4() {
        IRI subj = this.vf.createIRI("http://example.org/picasso");
        IRI pred = this.vf.createIRI("http://example.org/paints");
        Literal obj = this.vf.createLiteral(GUERNICA, "es");
        this.testValueRoundTrip((Resource)subj, pred, (Value)obj);
    }

    @Test
    public void testValueRoundTrip5() {
        IRI subj = this.vf.createIRI("http://example.org/picasso");
        IRI pred = this.vf.createIRI("http://example.org/paints");
        Literal obj = this.vf.createLiteral(3);
        this.testValueRoundTrip((Resource)subj, pred, (Value)obj);
    }

    @Test
    public void testDecimalRoundTrip() {
        IRI subj = this.vf.createIRI("http://example.org/picasso");
        IRI pred = this.vf.createIRI("http://example.org/paints");
        Literal obj = this.vf.createLiteral("3", XSD.DECIMAL);
        this.testValueRoundTrip((Resource)subj, pred, (Value)obj);
    }

    @Test
    public void testTimeZoneRoundTrip() {
        IRI subj = this.vf.createIRI("http://example.org/picasso");
        IRI pred = this.vf.createIRI("http://example.org/paints");
        Literal obj = this.vf.createLiteral("2006-08-23+00:00", (CoreDatatype)CoreDatatype.XSD.DATE);
        this.testValueRoundTrip((Resource)subj, pred, (Value)obj);
        this.con.begin();
        this.con.removeStatements(null, null, null, new Resource[0]);
        this.con.commit();
        obj = this.vf.createLiteral("2006-08-23", (CoreDatatype)CoreDatatype.XSD.DATE);
        this.testValueRoundTrip((Resource)subj, pred, (Value)obj);
    }

    @Test
    public void testLongURIRoundTrip() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 512; ++i) {
            sb.append(Character.toChars(65 + i % 26));
        }
        IRI subj = this.vf.createIRI("http://example.org/picasso");
        IRI pred = this.vf.createIRI("http://example.org/paints");
        IRI obj = this.vf.createIRI("http://example.org/guernica" + sb.toString());
        this.testValueRoundTrip((Resource)subj, pred, (Value)obj);
    }

    @Test
    public void testLongLiteralRoundTrip() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 512; ++i) {
            sb.append(Character.toChars(65 + i % 26));
        }
        IRI subj = this.vf.createIRI("http://example.org/picasso");
        IRI pred = this.vf.createIRI("http://example.org/paints");
        Literal obj = this.vf.createLiteral(GUERNICA + sb.toString());
        this.testValueRoundTrip((Resource)subj, pred, (Value)obj);
    }

    @Test
    public void testReallyLongLiteralRoundTrip() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 1024000; ++i) {
            sb.append(Character.toChars(65 + i % 26));
        }
        IRI subj = this.vf.createIRI("http://example.org/picasso");
        IRI pred = this.vf.createIRI("http://example.org/paints");
        Literal obj = this.vf.createLiteral(GUERNICA + sb.toString());
        this.testValueRoundTrip((Resource)subj, pred, (Value)obj);
    }

    @Test
    public void testLongLangRoundTrip() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 512; ++i) {
            sb.append(Character.toChars(65 + i % 26));
        }
        IRI subj = this.vf.createIRI("http://example.org/picasso");
        IRI pred = this.vf.createIRI("http://example.org/paints");
        Literal obj = this.vf.createLiteral(GUERNICA + sb.toString(), "es");
        this.testValueRoundTrip((Resource)subj, pred, (Value)obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testValueRoundTrip(Resource subj, IRI pred, Value obj) {
        this.con.begin();
        this.con.addStatement(subj, pred, obj, new Resource[0]);
        this.con.commit();
        try (CloseableIteration stIter = this.con.getStatements(null, null, null, false, new Resource[0]);){
            org.junit.jupiter.api.Assertions.assertTrue((boolean)stIter.hasNext());
            Statement st = (Statement)stIter.next();
            org.junit.jupiter.api.Assertions.assertEquals((Object)subj, (Object)st.getSubject());
            org.junit.jupiter.api.Assertions.assertEquals((Object)pred, (Object)st.getPredicate());
            org.junit.jupiter.api.Assertions.assertEquals((Object)obj, (Object)st.getObject());
            org.junit.jupiter.api.Assertions.assertFalse((boolean)stIter.hasNext());
        }
        ParsedTupleQuery tupleQuery = QueryParserUtil.parseTupleQuery((QueryLanguage)QueryLanguage.SPARQL, (String)("SELECT * WHERE { ?S ?P ?O. FILTER(?P = <" + pred.stringValue() + ">)}"), null);
        try (CloseableIteration iter = this.con.evaluate(tupleQuery.getTupleExpr(), null, EmptyBindingSet.getInstance(), false);){
            org.junit.jupiter.api.Assertions.assertTrue((boolean)iter.hasNext());
            BindingSet bindings = (BindingSet)iter.next();
            org.junit.jupiter.api.Assertions.assertEquals((Object)subj, (Object)bindings.getValue("S"));
            org.junit.jupiter.api.Assertions.assertEquals((Object)pred, (Object)bindings.getValue("P"));
            org.junit.jupiter.api.Assertions.assertEquals((Object)obj, (Object)bindings.getValue("O"));
            org.junit.jupiter.api.Assertions.assertTrue((!iter.hasNext() ? 1 : 0) != 0);
        }
    }

    @Test
    public void testCreateURI1() {
        IRI picasso1 = this.vf.createIRI(EXAMPLE_NS, PICASSO);
        IRI picasso2 = this.vf.createIRI("http://example.org/picasso");
        this.con.begin();
        this.con.addStatement((Resource)picasso1, this.paints, (Value)this.guernica, new Resource[0]);
        this.con.addStatement((Resource)picasso2, this.paints, (Value)this.guernica, new Resource[0]);
        this.con.commit();
        org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)this.con.size(new Resource[0]), (String)"createURI(Sring) and createURI(String, String) should create equal URIs");
    }

    @Test
    public void testCreateURI2() {
        IRI picasso1 = this.vf.createIRI("http://example.org/picasso");
        IRI picasso2 = this.vf.createIRI(EXAMPLE_NS, PICASSO);
        this.con.begin();
        this.con.addStatement((Resource)picasso1, this.paints, (Value)this.guernica, new Resource[0]);
        this.con.addStatement((Resource)picasso2, this.paints, (Value)this.guernica, new Resource[0]);
        this.con.commit();
        org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)this.con.size(new Resource[0]), (String)"createURI(Sring) and createURI(String, String) should create equal URIs");
    }

    @Test
    public void testInvalidDateTime() {
        Literal date1 = this.vf.createLiteral("2004-12-20", XSD.DATETIME);
        Literal date2 = this.vf.createLiteral("2004-12-20", (CoreDatatype)CoreDatatype.XSD.DATETIME);
        org.junit.jupiter.api.Assertions.assertEquals((Object)date1, (Object)date2);
    }

    @Test
    public void testSize() {
        org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)this.con.size(new Resource[0]), (String)"Size of empty repository should be 0");
        this.con.begin();
        this.con.addStatement((Resource)this.painter, RDF.TYPE, (Value)RDFS.CLASS, new Resource[0]);
        this.con.addStatement((Resource)this.painting, RDF.TYPE, (Value)RDFS.CLASS, new Resource[0]);
        this.con.addStatement((Resource)this.picasso, RDF.TYPE, (Value)this.painter, new Resource[]{this.context1});
        this.con.addStatement((Resource)this.guernica, RDF.TYPE, (Value)this.painting, new Resource[]{this.context1});
        this.con.addStatement((Resource)this.picasso, this.paints, (Value)this.guernica, new Resource[]{this.context1});
        this.con.commit();
        org.junit.jupiter.api.Assertions.assertEquals((long)5L, (long)this.con.size(new Resource[0]), (String)"Size of repository should be 5");
        org.junit.jupiter.api.Assertions.assertEquals((long)3L, (long)this.con.size(new Resource[]{this.context1}), (String)"Size of named context should be 3");
        IRI unknownContext = this.vf.createIRI("http://example.org/unknown");
        org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)this.con.size(new Resource[]{unknownContext}), (String)"Size of unknown context should be 0");
        IRI uriImplContext1 = this.vf.createIRI(this.context1.toString());
        org.junit.jupiter.api.Assertions.assertEquals((long)3L, (long)this.con.size(new Resource[]{uriImplContext1}), (String)"Size of named context (defined as URIImpl) should be 3");
    }

    @Test
    public void testAddData() {
        this.con.begin();
        this.con.addStatement((Resource)this.painter, RDF.TYPE, (Value)RDFS.CLASS, new Resource[0]);
        this.con.addStatement((Resource)this.painting, RDF.TYPE, (Value)RDFS.CLASS, new Resource[0]);
        this.con.addStatement((Resource)this.picasso, RDF.TYPE, (Value)this.painter, new Resource[]{this.context1});
        this.con.addStatement((Resource)this.guernica, RDF.TYPE, (Value)this.painting, new Resource[]{this.context1});
        this.con.addStatement((Resource)this.picasso, this.paints, (Value)this.guernica, new Resource[]{this.context1});
        this.con.commit();
        org.junit.jupiter.api.Assertions.assertEquals((int)5, (int)this.countAllElements(), (String)"Repository should contain 5 statements in total");
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)this.countContext1Elements(), (String)"Named context should contain 3 statements");
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)this.countElements(this.con.getContextIDs()), (String)"Repository should have 1 context identifier");
        org.junit.jupiter.api.Assertions.assertEquals((int)5, (int)this.countQueryResults("select * where {?s ?p ?o}"), (String)"Repository should contain 5 statements in total");
        Assertions.assertThat((boolean)this.con.hasStatement((Resource)this.painter, RDF.TYPE, (Value)RDFS.CLASS, true, new Resource[0])).isTrue();
        Assertions.assertThat((boolean)this.con.hasStatement((Resource)this.painting, RDF.TYPE, (Value)RDFS.CLASS, true, new Resource[0])).isTrue();
        Assertions.assertThat((boolean)this.con.hasStatement((Resource)this.picasso, RDF.TYPE, (Value)this.painter, true, new Resource[0])).isTrue();
        Assertions.assertThat((boolean)this.con.hasStatement((Resource)this.guernica, RDF.TYPE, (Value)this.painting, true, new Resource[0])).isTrue();
        Assertions.assertThat((boolean)this.con.hasStatement((Resource)this.picasso, this.paints, (Value)this.guernica, true, new Resource[0])).isTrue();
        Assertions.assertThat((boolean)this.con.hasStatement((Resource)this.painter, this.paints, (Value)this.painting, true, new Resource[0])).isFalse();
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)this.countQueryResults("select * where { ex:picasso ?P ?O}"), (String)"Repository should contain 2 statements matching (picasso, _, _)");
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)this.countQueryResults("select * where {ex:picasso ex:paints ?O}"), (String)"Repository should contain 1 statement matching (picasso, paints, _)");
        org.junit.jupiter.api.Assertions.assertEquals((int)4, (int)this.countQueryResults("select * where {?S rdf:type ?O}"), (String)"Repository should contain 4 statements matching (_, type, _)");
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)this.countQueryResults("select * where { ?S ?P rdfs:Class }"), (String)"Repository should contain 2 statements matching (_, _, Class)");
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)this.countQueryResults("select * where {?S ?P rdf:type}"), (String)"Repository should contain 0 statements matching (_, _, type)");
    }

    @Test
    public void testAddTripleContext() {
        this.con.begin();
        this.con.addStatement((Resource)this.painter, RDF.TYPE, (Value)RDFS.CLASS, new Resource[0]);
        this.con.commit();
        Triple tripleContext = Values.triple((Resource)this.guernica, (IRI)RDF.TYPE, (Value)this.painting);
        this.con.begin();
        Assertions.assertThatExceptionOfType(SailException.class).isThrownBy(() -> this.con.addStatement((Resource)this.picasso, this.paints, (Value)this.guernica, new Resource[]{tripleContext})).withMessageStartingWith("context argument can not be of type Triple: ");
        this.con.commit();
        this.con.begin();
        this.con.addStatement((Resource)this.picasso, this.paints, (Value)this.guernica, new Resource[]{this.context1});
        this.con.commit();
        Assertions.assertThat((boolean)this.con.hasStatement((Resource)this.picasso, this.paints, (Value)this.guernica, true, new Resource[]{tripleContext})).isFalse();
        Assertions.assertThat((boolean)this.con.hasStatement((Resource)this.painter, RDF.TYPE, (Value)RDFS.CLASS, true, new Resource[0])).isTrue();
        Assertions.assertThat((boolean)this.con.hasStatement((Resource)this.picasso, this.paints, (Value)this.guernica, true, new Resource[]{this.context1})).isTrue();
    }

    @Test
    public void testAddWhileQuerying() {
        BindingSet bindings;
        this.con.begin();
        this.con.addStatement((Resource)this.painter, RDF.TYPE, (Value)RDFS.CLASS, new Resource[0]);
        this.con.addStatement((Resource)this.painting, RDF.TYPE, (Value)RDFS.CLASS, new Resource[0]);
        this.con.addStatement((Resource)this.picasso, RDF.TYPE, (Value)this.painter, new Resource[0]);
        this.con.addStatement((Resource)this.guernica, RDF.TYPE, (Value)this.painting, new Resource[0]);
        this.con.addStatement((Resource)this.picasso, this.paints, (Value)this.guernica, new Resource[0]);
        this.con.commit();
        ParsedTupleQuery tupleQuery = QueryParserUtil.parseTupleQuery((QueryLanguage)QueryLanguage.SPARQL, (String)"SELECT ?C WHERE { [] a ?C }", null);
        CloseableIteration iter = this.con.evaluate(tupleQuery.getTupleExpr(), null, EmptyBindingSet.getInstance(), false);
        this.con.begin();
        while (iter.hasNext()) {
            bindings = (BindingSet)iter.next();
            Value c = bindings.getValue("C");
            if (!(c instanceof Resource)) continue;
            this.con.addStatement((Resource)c, RDF.TYPE, (Value)RDFS.CLASS, new Resource[0]);
        }
        this.con.commit();
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)this.countElements(this.con.getStatements(null, RDF.TYPE, (Value)RDFS.CLASS, false, new Resource[0])));
        tupleQuery = QueryParserUtil.parseTupleQuery((QueryLanguage)QueryLanguage.SPARQL, (String)"SELECT ?P WHERE { [] ?P [] .}", null);
        iter = this.con.evaluate(tupleQuery.getTupleExpr(), null, EmptyBindingSet.getInstance(), false);
        while (iter.hasNext()) {
            bindings = (BindingSet)iter.next();
            Value p = bindings.getValue("P");
            if (!(p instanceof IRI)) continue;
            this.con.begin();
            this.con.addStatement((Resource)((IRI)p), RDF.TYPE, (Value)RDF.PROPERTY, new Resource[0]);
            this.con.commit();
        }
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)this.countElements(this.con.getStatements(null, RDF.TYPE, (Value)RDF.PROPERTY, false, new Resource[0])));
    }

    @Test
    public void testRemoveAndClear() {
        this.con.begin();
        this.con.addStatement((Resource)this.painter, RDF.TYPE, (Value)RDFS.CLASS, new Resource[0]);
        this.con.addStatement((Resource)this.painting, RDF.TYPE, (Value)RDFS.CLASS, new Resource[0]);
        this.con.addStatement((Resource)this.picasso, RDF.TYPE, (Value)this.painter, new Resource[]{this.context1});
        this.con.addStatement((Resource)this.guernica, RDF.TYPE, (Value)this.painting, new Resource[]{this.context1});
        this.con.addStatement((Resource)this.picasso, this.paints, (Value)this.guernica, new Resource[]{this.context1});
        this.con.commit();
        this.con.begin();
        this.con.removeStatements((Resource)this.painting, RDF.TYPE, (Value)RDFS.CLASS, new Resource[0]);
        this.con.commit();
        org.junit.jupiter.api.Assertions.assertEquals((int)4, (int)this.countAllElements(), (String)"Repository should contain 4 statements in total");
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)this.countContext1Elements(), (String)"Named context should contain 3 statements");
        Assertions.assertThat((boolean)this.con.hasStatement((Resource)this.painting, RDF.TYPE, (Value)RDFS.CLASS, true, new Resource[0])).isFalse();
        this.con.begin();
        this.con.removeStatements(null, null, null, new Resource[]{this.context1});
        this.con.commit();
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)this.countAllElements(), (String)"Repository should contain 1 statement in total");
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)this.countContext1Elements(), (String)"Named context should be empty");
        this.con.begin();
        this.con.clear(new Resource[0]);
        this.con.commit();
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)this.countAllElements(), (String)"Repository should no longer contain any statements");
    }

    @Test
    public void testClose() {
        try {
            this.con.close();
            this.con.addStatement((Resource)this.painter, RDF.TYPE, (Value)RDFS.CLASS, new Resource[0]);
            Assertions.fail((String)"Operation on connection after close should result in IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (SailException e) {
            throw e;
        }
    }

    @Test
    public void testContexts() {
        this.con.begin();
        this.con.addStatement((Resource)this.painter, RDF.TYPE, (Value)RDFS.CLASS, new Resource[0]);
        this.con.addStatement((Resource)this.painting, RDF.TYPE, (Value)RDFS.CLASS, new Resource[0]);
        this.con.addStatement((Resource)this.picasso, RDF.TYPE, (Value)this.painter, new Resource[]{this.context1});
        this.con.addStatement((Resource)this.guernica, RDF.TYPE, (Value)this.painting, new Resource[]{this.context1});
        this.con.addStatement((Resource)this.picasso, this.paints, (Value)this.guernica, new Resource[]{this.context1});
        this.con.addStatement((Resource)this.rembrandt, RDF.TYPE, (Value)this.painter, new Resource[]{this.context2});
        this.con.addStatement((Resource)this.nightwatch, RDF.TYPE, (Value)this.painting, new Resource[]{this.context2});
        this.con.addStatement((Resource)this.rembrandt, this.paints, (Value)this.nightwatch, new Resource[]{this.context2});
        this.con.commit();
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)this.countContext1Elements(), (String)"context1 should contain 3 statements");
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)this.countElements(this.con.getStatements(null, null, null, false, new Resource[]{this.context2})), (String)"context2 should contain 3 statements");
        org.junit.jupiter.api.Assertions.assertEquals((int)8, (int)this.countAllElements(), (String)"Repository should contain 8 statements");
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)this.countElements(this.con.getStatements(null, null, null, false, new Resource[]{null})), (String)"statements without context should equal 2");
        org.junit.jupiter.api.Assertions.assertEquals((int)5, (int)this.countElements(this.con.getStatements(null, null, null, false, new Resource[]{null, this.context1})), (String)"Statements without context and statements in context 1 together should total 5");
        org.junit.jupiter.api.Assertions.assertEquals((int)5, (int)this.countElements(this.con.getStatements(null, null, null, false, new Resource[]{null, this.context2})), (String)"Statements without context and statements in context 2 together should total 5");
        org.junit.jupiter.api.Assertions.assertEquals((int)6, (int)this.countElements(this.con.getStatements(null, null, null, false, new Resource[]{this.context1, this.context2})), (String)"Statements in context 1 and in context 2 together should total 6");
        this.con.begin();
        this.con.removeStatements((Resource)this.picasso, null, null, new Resource[]{this.context1});
        this.con.commit();
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)this.countContext1Elements(), (String)"context1 should contain 1 statements");
        org.junit.jupiter.api.Assertions.assertEquals((int)6, (int)this.countAllElements(), (String)"Repository should contain 6 statements");
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)this.countElements(this.con.getStatements(null, null, null, false, new Resource[]{null, this.context1})), (String)"Statements without context and statements in context 1 together should total 3");
        org.junit.jupiter.api.Assertions.assertEquals((int)5, (int)this.countElements(this.con.getStatements(null, null, null, false, new Resource[]{this.context2, null})), (String)"Statements without context and statements in context 2 together should total 5");
        org.junit.jupiter.api.Assertions.assertEquals((int)4, (int)this.countElements(this.con.getStatements(null, null, null, false, new Resource[]{this.context1, this.context2})), (String)"Statements in context 1 and in context 2 together should total 4");
    }

    @Test
    public void testQueryBindings() {
        this.con.begin();
        this.con.addStatement((Resource)this.painter, RDF.TYPE, (Value)RDFS.CLASS, new Resource[0]);
        this.con.addStatement((Resource)this.painting, RDF.TYPE, (Value)RDFS.CLASS, new Resource[0]);
        this.con.addStatement((Resource)this.picasso, RDF.TYPE, (Value)this.painter, new Resource[]{this.context1});
        this.con.addStatement((Resource)this.guernica, RDF.TYPE, (Value)this.painting, new Resource[]{this.context1});
        this.con.addStatement((Resource)this.picasso, this.paints, (Value)this.guernica, new Resource[]{this.context1});
        this.con.commit();
        ParsedTupleQuery tupleQuery = QueryParserUtil.parseTupleQuery((QueryLanguage)QueryLanguage.SPARQL, (String)"select ?X where { ?X a ?Y . ?Y a rdfs:Class. }", null);
        TupleExpr tupleExpr = tupleQuery.getTupleExpr();
        MapBindingSet bindings = new MapBindingSet(2);
        CloseableIteration iter = this.con.evaluate(tupleExpr, null, (BindingSet)bindings, false);
        int resultCount = this.verifyQueryResult((CloseableIteration<? extends BindingSet>)iter, 1);
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)resultCount, (String)"Wrong number of query results");
        bindings.addBinding("Y", (Value)this.painter);
        iter = this.con.evaluate(tupleExpr, null, (BindingSet)bindings, false);
        resultCount = this.verifyQueryResult((CloseableIteration<? extends BindingSet>)iter, 1);
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)resultCount, (String)"Wrong number of query results");
        bindings.addBinding("Z", (Value)this.painting);
        iter = this.con.evaluate(tupleExpr, null, (BindingSet)bindings, false);
        resultCount = this.verifyQueryResult((CloseableIteration<? extends BindingSet>)iter, 1);
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)resultCount, (String)"Wrong number of query results");
        bindings.removeBinding("Y");
        iter = this.con.evaluate(tupleExpr, null, (BindingSet)bindings, false);
        resultCount = this.verifyQueryResult((CloseableIteration<? extends BindingSet>)iter, 1);
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)resultCount, (String)"Wrong number of query results");
        tupleQuery = QueryParserUtil.parseTupleQuery((QueryLanguage)QueryLanguage.SPARQL, (String)"select ?X WHERE { ?X a ?Y . ?Y a rdfs:Class. filter(?Y = ?Z) }", null);
        tupleExpr = tupleQuery.getTupleExpr();
        bindings.clear();
        iter = this.con.evaluate(tupleExpr, null, (BindingSet)bindings, false);
        resultCount = this.verifyQueryResult((CloseableIteration<? extends BindingSet>)iter, 1);
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)resultCount, (String)"Wrong number of query results");
        bindings.addBinding("Z", (Value)this.painter);
        iter = this.con.evaluate(tupleExpr, null, (BindingSet)bindings, false);
        resultCount = this.verifyQueryResult((CloseableIteration<? extends BindingSet>)iter, 1);
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)resultCount, (String)"Wrong number of query results");
    }

    @Test
    public void testStatementEquals() {
        Statement st = this.vf.createStatement((Resource)this.picasso, RDF.TYPE, (Value)this.painter);
        org.junit.jupiter.api.Assertions.assertEquals((Object)st, (Object)this.vf.createStatement((Resource)this.picasso, RDF.TYPE, (Value)this.painter));
        org.junit.jupiter.api.Assertions.assertNotEquals((Object)st, (Object)this.vf.createStatement((Resource)this.picasso, RDF.TYPE, (Value)this.painter, (Resource)this.context1));
        org.junit.jupiter.api.Assertions.assertNotEquals((Object)st, (Object)this.vf.createStatement((Resource)this.picasso, RDF.TYPE, (Value)this.painter, (Resource)this.context2));
    }

    @Test
    public void testStatementSerialization() throws Exception {
        Statement st = this.vf.createStatement((Resource)this.picasso, RDF.TYPE, (Value)this.painter);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(baos);
        out.writeObject(st);
        out.close();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        ObjectInputStream in = new ObjectInputStream(bais);
        Statement deserializedStatement = (Statement)in.readObject();
        in.close();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)st.equals((Object)deserializedStatement));
    }

    @Test
    public void testGetNamespaces() {
        this.con.begin();
        this.con.setNamespace("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        this.con.commit();
        try (CloseableIteration namespaces = this.con.getNamespaces();){
            org.junit.jupiter.api.Assertions.assertTrue((boolean)namespaces.hasNext());
            Namespace rdf = (Namespace)namespaces.next();
            org.junit.jupiter.api.Assertions.assertEquals((Object)"rdf", (Object)rdf.getPrefix());
            org.junit.jupiter.api.Assertions.assertEquals((Object)"http://www.w3.org/1999/02/22-rdf-syntax-ns#", (Object)rdf.getName());
            org.junit.jupiter.api.Assertions.assertFalse((boolean)namespaces.hasNext());
        }
    }

    @Test
    public void testGetNamespace() {
        this.con.begin();
        this.con.setNamespace("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        this.con.commit();
        org.junit.jupiter.api.Assertions.assertEquals((Object)"http://www.w3.org/1999/02/22-rdf-syntax-ns#", (Object)this.con.getNamespace("rdf"));
    }

    @Test
    public void testClearNamespaces() {
        this.con.begin();
        this.con.setNamespace("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        this.con.setNamespace("rdfs", "http://www.w3.org/2000/01/rdf-schema#");
        this.con.clearNamespaces();
        this.con.commit();
        org.junit.jupiter.api.Assertions.assertTrue((!this.con.getNamespaces().hasNext() ? 1 : 0) != 0);
    }

    @Test
    public void testRemoveNamespaces() {
        this.con.begin();
        this.con.setNamespace("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        this.con.removeNamespace("rdf");
        this.con.commit();
        org.junit.jupiter.api.Assertions.assertNull((Object)this.con.getNamespace("rdf"));
    }

    @Test
    public void testNullNamespaceDisallowed() {
        try {
            this.con.setNamespace("foo", null);
            Assertions.fail((String)"Expected NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testNullPrefixDisallowed() {
        try {
            this.con.setNamespace(null, "foo");
            Assertions.fail((String)"Expected NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            this.con.getNamespace(null);
            Assertions.fail((String)"Expected NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            this.con.removeNamespace(null);
            Assertions.fail((String)"Expected NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testGetContextIDs() {
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)this.countElements(this.con.getContextIDs()));
        this.con.begin();
        this.con.addStatement((Resource)this.picasso, this.paints, (Value)this.guernica, new Resource[]{this.context1});
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)this.countElements(this.con.getContextIDs()));
        org.junit.jupiter.api.Assertions.assertEquals((Object)this.context1, this.first(this.con.getContextIDs()));
        this.con.removeStatements((Resource)this.picasso, this.paints, (Value)this.guernica, new Resource[]{this.context1});
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)this.countElements(this.con.getContextIDs()));
        this.con.commit();
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)this.countElements(this.con.getContextIDs()));
        this.con.begin();
        this.con.addStatement((Resource)this.picasso, this.paints, (Value)this.guernica, new Resource[]{this.context2});
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)this.countElements(this.con.getContextIDs()));
        org.junit.jupiter.api.Assertions.assertEquals((Object)this.context2, this.first(this.con.getContextIDs()));
        this.con.commit();
    }

    @Test
    public void testOldURI() {
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)this.countAllElements());
        this.con.begin();
        this.con.addStatement((Resource)this.painter, RDF.TYPE, (Value)RDFS.CLASS, new Resource[0]);
        this.con.addStatement((Resource)this.painting, RDF.TYPE, (Value)RDFS.CLASS, new Resource[0]);
        this.con.addStatement((Resource)this.picasso, RDF.TYPE, (Value)this.painter, new Resource[]{this.context1});
        this.con.addStatement((Resource)this.guernica, RDF.TYPE, (Value)this.painting, new Resource[]{this.context1});
        this.con.addStatement((Resource)this.picasso, this.paints, (Value)this.guernica, new Resource[]{this.context1});
        org.junit.jupiter.api.Assertions.assertEquals((int)5, (int)this.countAllElements());
        this.con.commit();
        this.con.begin();
        this.con.clear(new Resource[0]);
        this.con.commit();
        this.con.begin();
        this.con.addStatement((Resource)this.picasso, this.paints, (Value)this.guernica, new Resource[]{this.context1});
        this.con.commit();
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)this.countAllElements());
    }

    @Test
    public void testDualConnections() throws Exception {
        try (SailConnection con2 = this.sail.getConnection();){
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)this.countAllElements());
            this.con.begin();
            this.con.addStatement((Resource)this.painter, RDF.TYPE, (Value)RDFS.CLASS, new Resource[0]);
            this.con.addStatement((Resource)this.painting, RDF.TYPE, (Value)RDFS.CLASS, new Resource[0]);
            this.con.addStatement((Resource)this.picasso, RDF.TYPE, (Value)this.painter, new Resource[]{this.context1});
            this.con.addStatement((Resource)this.guernica, RDF.TYPE, (Value)this.painting, new Resource[]{this.context1});
            this.con.commit();
            org.junit.jupiter.api.Assertions.assertEquals((int)4, (int)this.countAllElements());
            con2.begin();
            con2.addStatement((Resource)RDF.NIL, RDF.TYPE, (Value)RDF.LIST, new Resource[0]);
            String query = "SELECT * WHERE { ?S ?P ?O }";
            ParsedTupleQuery tupleQuery = QueryParserUtil.parseTupleQuery((QueryLanguage)QueryLanguage.SPARQL, (String)query, null);
            org.junit.jupiter.api.Assertions.assertEquals((int)5, (int)this.countElements(con2.evaluate(tupleQuery.getTupleExpr(), null, EmptyBindingSet.getInstance(), false)));
            Runnable clearer = () -> {
                try {
                    this.con.begin();
                    this.con.clear(new Resource[0]);
                    this.con.commit();
                }
                catch (SailException e) {
                    throw new RuntimeException(e);
                }
            };
            Thread thread = new Thread(clearer);
            thread.start();
            Thread.yield();
            Thread.yield();
            con2.commit();
            thread.join();
        }
    }

    @Test
    public void testBNodeReuse() {
        this.con.begin();
        this.con.addStatement((Resource)RDF.VALUE, RDF.VALUE, (Value)RDF.VALUE, new Resource[0]);
        org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)this.con.size(new Resource[0]));
        BNode b1 = this.vf.createBNode();
        this.con.addStatement((Resource)b1, RDF.VALUE, (Value)b1, new Resource[0]);
        this.con.removeStatements((Resource)b1, RDF.VALUE, (Value)b1, new Resource[0]);
        org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)this.con.size(new Resource[0]));
        BNode b2 = this.vf.createBNode();
        this.con.addStatement((Resource)b2, RDF.VALUE, (Value)b2, new Resource[0]);
        this.con.addStatement((Resource)b1, RDF.VALUE, (Value)b1, new Resource[0]);
        org.junit.jupiter.api.Assertions.assertEquals((long)3L, (long)this.con.size(new Resource[0]));
        this.con.commit();
    }

    @Test
    public void testDuplicateCount() {
        this.con.begin();
        this.con.addStatement((Resource)RDF.SUBJECT, RDF.PREDICATE, (Value)RDF.OBJECT, new Resource[0]);
        this.con.commit();
        this.con.begin();
        this.con.addStatement((Resource)RDF.SUBJECT, RDF.PREDICATE, (Value)RDF.OBJECT, new Resource[0]);
        org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)this.con.size(new Resource[0]), (String)"Statement should appear once");
        this.con.commit();
    }

    @Test
    public void testDuplicateGetStatement() {
        this.con.begin();
        this.con.addStatement((Resource)RDF.SUBJECT, RDF.PREDICATE, (Value)RDF.OBJECT, new Resource[0]);
        this.con.commit();
        this.con.begin();
        this.con.addStatement((Resource)RDF.SUBJECT, RDF.PREDICATE, (Value)RDF.OBJECT, new Resource[0]);
        try (Stream stream = this.con.getStatements(null, null, null, false, new Resource[0]).stream();){
            long count = stream.count();
            org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)count, (String)"Statement should appear once");
        }
        this.con.commit();
    }

    @Test
    public void testDuplicateGetStatementAfterCommit() {
        this.con.begin();
        this.con.addStatement((Resource)RDF.SUBJECT, RDF.PREDICATE, (Value)RDF.OBJECT, new Resource[0]);
        this.con.commit();
        this.con.begin();
        this.con.addStatement((Resource)RDF.SUBJECT, RDF.PREDICATE, (Value)RDF.OBJECT, new Resource[0]);
        this.con.commit();
        try (Stream stream = this.con.getStatements(null, null, null, false, new Resource[0]).stream();){
            long count = stream.count();
            org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)count, (String)"Statement should appear once");
        }
    }

    @Test
    public void testDuplicateCountAfterComit() {
        this.con.begin();
        this.con.addStatement((Resource)RDF.SUBJECT, RDF.PREDICATE, (Value)RDF.OBJECT, new Resource[0]);
        this.con.commit();
        this.con.begin();
        this.con.addStatement((Resource)RDF.SUBJECT, RDF.PREDICATE, (Value)RDF.OBJECT, new Resource[0]);
        this.con.commit();
        org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)this.con.size(new Resource[0]), (String)"Statement should appear once");
    }

    @Test
    public void testDuplicateCountMultipleTimes() {
        this.con.begin();
        this.con.addStatement((Resource)RDF.SUBJECT, RDF.PREDICATE, (Value)RDF.OBJECT, new Resource[0]);
        this.con.commit();
        this.con.begin();
        this.con.addStatement((Resource)RDF.SUBJECT, RDF.PREDICATE, (Value)RDF.OBJECT, new Resource[0]);
        org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)this.con.size(new Resource[0]), (String)"Statement should appear once");
        org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)this.con.size(new Resource[0]), (String)"Statement should appear once");
        org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)this.con.size(new Resource[0]), (String)"Statement should appear once");
        this.con.commit();
    }

    private <T, X extends Exception> T first(CloseableIteration<T> iter) throws X {
        try (CloseableIteration<T> closeableIteration = iter;){
            if (iter.hasNext()) {
                Object object = iter.next();
                return (T)object;
            }
        }
        return null;
    }

    protected int countContext1Elements() {
        return this.countElements(this.con.getStatements(null, null, null, false, new Resource[]{this.context1}));
    }

    protected int countAllElements() {
        return this.countElements(this.con.getStatements(null, null, null, false, new Resource[0]));
    }

    private <T, X extends Exception> int countElements(CloseableIteration<T> iter) throws X {
        int count = 0;
        try (CloseableIteration<T> closeableIteration = iter;){
            while (iter.hasNext()) {
                iter.next();
                ++count;
            }
        }
        return count;
    }

    protected int countQueryResults(String query) {
        ParsedTupleQuery tupleQuery = QueryParserUtil.parseTupleQuery((QueryLanguage)QueryLanguage.SPARQL, (String)("PREFIX ex: <http://example.org/> \n" + query), null);
        return this.countElements(this.con.evaluate(tupleQuery.getTupleExpr(), null, EmptyBindingSet.getInstance(), false));
    }

    private int verifyQueryResult(CloseableIteration<? extends BindingSet> resultIter, int expectedBindingCount) throws QueryEvaluationException {
        int resultCount = 0;
        while (resultIter.hasNext()) {
            BindingSet resultBindings = (BindingSet)resultIter.next();
            ++resultCount;
            org.junit.jupiter.api.Assertions.assertEquals((int)expectedBindingCount, (int)resultBindings.getBindingNames().size(), (String)"Wrong number of binding names for binding set");
            int bindingCount = 0;
            Iterator bindingIter = resultBindings.iterator();
            while (bindingIter.hasNext()) {
                bindingIter.next();
                ++bindingCount;
            }
            org.junit.jupiter.api.Assertions.assertEquals((int)expectedBindingCount, (int)bindingCount, (String)"Wrong number of bindings in binding set");
        }
        return resultCount;
    }
}

