/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.testsuite.sail;

import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.Iterations;
import org.eclipse.rdf4j.common.transaction.IsolationLevel;
import org.eclipse.rdf4j.common.transaction.IsolationLevels;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.model.vocabulary.RDFS;
import org.eclipse.rdf4j.model.vocabulary.XSD;
import org.eclipse.rdf4j.sail.Sail;
import org.eclipse.rdf4j.sail.SailConflictException;
import org.eclipse.rdf4j.sail.SailConnection;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.UnknownSailTransactionStateException;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SailIsolationLevelTest {
    private final Logger logger = LoggerFactory.getLogger(SailIsolationLevelTest.class);
    protected Sail store;
    private ValueFactory vf;
    private String failedMessage;
    private Throwable failed;

    @BeforeAll
    public static void setUpClass() {
        System.setProperty("org.eclipse.rdf4j.repository.debug", "true");
    }

    @AfterAll
    public static void afterClass() {
        System.setProperty("org.eclipse.rdf4j.repository.debug", "false");
    }

    @BeforeEach
    public void setUp() {
        this.store = this.createSail();
        this.store.init();
        this.vf = this.store.getValueFactory();
        this.failed = null;
    }

    @AfterEach
    public void tearDown() {
        this.store.shutDown();
    }

    protected abstract Sail createSail() throws SailException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isSupported(IsolationLevels level) throws SailException {
        SailConnection con = this.store.getConnection();
        try {
            con.begin((IsolationLevel)level);
            boolean bl = true;
            return bl;
        }
        catch (UnknownSailTransactionStateException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            con.rollback();
            con.close();
        }
    }

    @Test
    public void testNone() {
        this.readPending((IsolationLevel)IsolationLevels.NONE);
    }

    @Test
    public void testReadUncommitted() {
        this.rollbackTriple((IsolationLevel)IsolationLevels.READ_UNCOMMITTED);
        this.readPending((IsolationLevel)IsolationLevels.READ_UNCOMMITTED);
        this.readPendingWhileActive((IsolationLevel)IsolationLevels.READ_UNCOMMITTED);
    }

    @Test
    public void testReadCommitted() throws Exception {
        this.readCommitted((IsolationLevel)IsolationLevels.READ_COMMITTED);
        this.rollbackTriple((IsolationLevel)IsolationLevels.READ_COMMITTED);
        this.readPending((IsolationLevel)IsolationLevels.READ_COMMITTED);
        this.readPendingWhileActive((IsolationLevel)IsolationLevels.READ_COMMITTED);
    }

    @Test
    public void testSnapshotRead() throws Exception {
        if (this.isSupported(IsolationLevels.SNAPSHOT_READ)) {
            this.snapshotRead((IsolationLevel)IsolationLevels.SNAPSHOT_READ);
            this.readCommitted((IsolationLevel)IsolationLevels.SNAPSHOT_READ);
            this.rollbackTriple((IsolationLevel)IsolationLevels.SNAPSHOT_READ);
            this.readPending((IsolationLevel)IsolationLevels.SNAPSHOT_READ);
            this.readPendingWhileActive((IsolationLevel)IsolationLevels.SNAPSHOT_READ);
        } else {
            this.logger.warn("{} does not support {}", (Object)this.store, (Object)IsolationLevels.SNAPSHOT_READ);
        }
    }

    @Test
    public void testSnapshot() throws Exception {
        if (this.isSupported(IsolationLevels.SNAPSHOT)) {
            this.snapshot(IsolationLevels.SNAPSHOT);
            this.snapshotRead((IsolationLevel)IsolationLevels.SNAPSHOT);
            this.repeatableRead(IsolationLevels.SNAPSHOT);
            this.readCommitted((IsolationLevel)IsolationLevels.SNAPSHOT);
            this.rollbackTriple((IsolationLevel)IsolationLevels.SNAPSHOT);
            this.readPending((IsolationLevel)IsolationLevels.SNAPSHOT);
            this.readPendingWhileActive((IsolationLevel)IsolationLevels.SNAPSHOT);
        } else {
            this.logger.warn("{} does not support {}", (Object)this.store, (Object)IsolationLevels.SNAPSHOT);
        }
    }

    @Test
    public void testSerializable() throws Exception {
        if (this.isSupported(IsolationLevels.SERIALIZABLE)) {
            this.serializable(IsolationLevels.SERIALIZABLE);
            this.snapshot(IsolationLevels.SERIALIZABLE);
            this.snapshotRead((IsolationLevel)IsolationLevels.SERIALIZABLE);
            this.repeatableRead(IsolationLevels.SERIALIZABLE);
            this.readCommitted((IsolationLevel)IsolationLevels.SERIALIZABLE);
            this.rollbackTriple((IsolationLevel)IsolationLevels.SERIALIZABLE);
            this.readPending((IsolationLevel)IsolationLevels.SERIALIZABLE);
            this.readPendingWhileActive((IsolationLevel)IsolationLevels.SERIALIZABLE);
        } else {
            this.logger.warn("{} does not support {}", (Object)this.store, (Object)IsolationLevels.SERIALIZABLE);
        }
    }

    @Test
    public void testLargeTransactionReadCommitted() throws InterruptedException {
        if (this.isSupported(IsolationLevels.READ_COMMITTED)) {
            this.testLargeTransaction((IsolationLevel)IsolationLevels.READ_COMMITTED, 1000);
        } else {
            this.logger.warn("Isolation level not supporter.");
        }
    }

    @Test
    public void testLargeTransactionSnapshot() throws InterruptedException {
        if (this.isSupported(IsolationLevels.SNAPSHOT)) {
            this.testLargeTransaction((IsolationLevel)IsolationLevels.SNAPSHOT, 1000);
        } else {
            this.logger.warn("Isolation level not supporter.");
        }
    }

    @Test
    public void testLargeTransactionSnapshotRead() throws InterruptedException {
        if (this.isSupported(IsolationLevels.SNAPSHOT_READ)) {
            this.testLargeTransaction((IsolationLevel)IsolationLevels.SNAPSHOT_READ, 1000);
        } else {
            this.logger.warn("Isolation level not supporter.");
        }
    }

    @Test
    public void testLargeTransactionSerializable() throws InterruptedException {
        if (this.isSupported(IsolationLevels.SERIALIZABLE)) {
            this.testLargeTransaction((IsolationLevel)IsolationLevels.SERIALIZABLE, 1000);
        } else {
            this.logger.warn("Isolation level not supporter.");
        }
    }

    public void testLargeTransaction(IsolationLevel isolationLevel, int count) throws InterruptedException {
        try (SailConnection connection = this.store.getConnection();){
            connection.begin((IsolationLevel)IsolationLevels.NONE);
            connection.clear(new Resource[0]);
            connection.commit();
        }
        AtomicBoolean failure = new AtomicBoolean(false);
        Runnable runnable = () -> {
            try (SailConnection connection = this.store.getConnection();){
                while (true) {
                    block10: {
                        try {
                            connection.begin(isolationLevel);
                            List statements = Iterations.asList((CloseableIteration)connection.getStatements(null, null, null, false, new Resource[0]));
                            connection.commit();
                            if (statements.isEmpty()) break block10;
                            if (statements.size() != count) {
                                this.logger.error("Size was {}. Expected 0 or {}", (Object)statements.size(), (Object)count);
                                this.logger.error("\n[\n\t{}\n]", (Object)statements.stream().map(Object::toString).reduce((a, b) -> a + " , \n\t" + b).get());
                                failure.set(true);
                            }
                            break;
                        }
                        catch (SailConflictException ignored) {
                            connection.rollback();
                        }
                    }
                    Thread.yield();
                }
            }
        };
        Thread thread = new Thread(runnable);
        thread.start();
        SimpleValueFactory vf = SimpleValueFactory.getInstance();
        try (SailConnection connection = this.store.getConnection();){
            connection.begin(isolationLevel);
            for (int i = 0; i < count; ++i) {
                connection.addStatement((Resource)RDFS.RESOURCE, RDFS.LABEL, (Value)vf.createLiteral(i), new Resource[0]);
            }
            this.logger.debug("Commit");
            connection.commit();
            Assertions.assertEquals((long)count, (long)connection.size(new Resource[0]));
        }
        this.logger.debug("Joining thread");
        thread.join();
        Assertions.assertFalse((boolean)failure.get());
    }

    private void readPending(IsolationLevel level) throws SailException {
        this.clear(this.store);
        try (SailConnection con = this.store.getConnection();){
            con.begin(level);
            con.addStatement((Resource)RDF.NIL, RDF.TYPE, (Value)RDF.LIST, new Resource[0]);
            Assertions.assertEquals((long)1L, (long)this.count(con, (Resource)RDF.NIL, RDF.TYPE, (Value)RDF.LIST, false, new Resource[0]));
            con.removeStatements((Resource)RDF.NIL, RDF.TYPE, (Value)RDF.LIST, new Resource[0]);
            con.commit();
        }
    }

    private void readPendingWhileActive(IsolationLevel level) throws SailException {
        this.clear(this.store);
        try (SailConnection con = this.store.getConnection();
             CloseableIteration unusedStatements = con.getStatements(null, null, null, true, new Resource[0]);){
            con.begin(level);
            con.addStatement((Resource)RDF.NIL, RDF.TYPE, (Value)RDF.LIST, new Resource[0]);
            Assertions.assertEquals((long)1L, (long)this.count(con, (Resource)RDF.NIL, RDF.TYPE, (Value)RDF.LIST, false, new Resource[0]));
            con.removeStatements((Resource)RDF.NIL, RDF.TYPE, (Value)RDF.LIST, new Resource[0]);
            con.commit();
        }
    }

    private void rollbackTriple(IsolationLevel level) throws SailException {
        this.clear(this.store);
        try (SailConnection con = this.store.getConnection();){
            con.begin(level);
            con.addStatement((Resource)RDF.NIL, RDF.TYPE, (Value)RDF.LIST, new Resource[0]);
            con.rollback();
            Assertions.assertEquals((long)0L, (long)this.count(con, (Resource)RDF.NIL, RDF.TYPE, (Value)RDF.LIST, false, new Resource[0]));
        }
    }

    private void readCommitted(IsolationLevel level) throws Exception {
        this.clear(this.store);
        CountDownLatch start = new CountDownLatch(2);
        CountDownLatch begin = new CountDownLatch(1);
        CountDownLatch uncommitted = new CountDownLatch(1);
        Thread writer = new Thread(() -> {
            try (SailConnection write = this.store.getConnection();){
                start.countDown();
                start.await();
                write.begin(level);
                write.addStatement((Resource)RDF.NIL, RDF.TYPE, (Value)RDF.LIST, new Resource[0]);
                begin.countDown();
                uncommitted.await(1L, TimeUnit.SECONDS);
                write.rollback();
            }
            catch (Throwable e) {
                this.fail("Writer failed", e);
            }
        });
        Thread reader = new Thread(() -> {
            try {
                SailConnection read = this.store.getConnection();
                try {
                    start.countDown();
                    start.await();
                    begin.await();
                    read.begin(level);
                    long counted = this.count(read, (Resource)RDF.NIL, RDF.TYPE, (Value)RDF.LIST, false, new Resource[0]);
                    uncommitted.countDown();
                    try {
                        read.commit();
                    }
                    catch (SailException e) {
                        read.rollback();
                        if (read != null) {
                            read.close();
                        }
                        return;
                    }
                    Assertions.assertEquals((long)0L, (long)counted);
                }
                finally {
                    if (read != null) {
                        try {
                            read.close();
                        }
                        catch (Throwable throwable) {
                            Throwable throwable2;
                            throwable2.addSuppressed(throwable);
                        }
                    }
                }
            }
            catch (Throwable e) {
                this.fail("Reader failed", e);
            }
        });
        reader.start();
        writer.start();
        reader.join();
        writer.join();
        this.assertNotFailed();
    }

    private void repeatableRead(IsolationLevels level) throws Exception {
        this.clear(this.store);
        CountDownLatch start = new CountDownLatch(2);
        CountDownLatch begin = new CountDownLatch(1);
        CountDownLatch observed = new CountDownLatch(1);
        CountDownLatch changed = new CountDownLatch(1);
        Thread writer = new Thread(() -> {
            try (SailConnection write = this.store.getConnection();){
                start.countDown();
                start.await();
                write.begin((IsolationLevel)level);
                write.addStatement((Resource)RDF.NIL, RDF.TYPE, (Value)RDF.LIST, new Resource[0]);
                write.commit();
                begin.countDown();
                observed.await(1L, TimeUnit.SECONDS);
                write.begin((IsolationLevel)level);
                write.removeStatements((Resource)RDF.NIL, RDF.TYPE, (Value)RDF.LIST, new Resource[0]);
                write.commit();
                changed.countDown();
            }
            catch (Throwable e) {
                this.fail("Writer failed", e);
            }
        });
        Thread reader = new Thread(() -> {
            try {
                SailConnection read = this.store.getConnection();
                try {
                    start.countDown();
                    start.await();
                    begin.await();
                    read.begin((IsolationLevel)level);
                    long first = this.count(read, (Resource)RDF.NIL, RDF.TYPE, (Value)RDF.LIST, false, new Resource[0]);
                    Assertions.assertEquals((long)1L, (long)first);
                    observed.countDown();
                    changed.await(1L, TimeUnit.SECONDS);
                    long second = this.count(read, (Resource)RDF.NIL, RDF.TYPE, (Value)RDF.LIST, false, new Resource[0]);
                    try {
                        read.commit();
                    }
                    catch (SailException e) {
                        read.rollback();
                        if (read != null) {
                            read.close();
                        }
                        return;
                    }
                    Assertions.assertEquals((long)first, (long)second);
                }
                finally {
                    if (read != null) {
                        try {
                            read.close();
                        }
                        catch (Throwable throwable) {
                            Throwable throwable2;
                            throwable2.addSuppressed(throwable);
                        }
                    }
                }
            }
            catch (Throwable e) {
                this.fail("Reader failed", e);
            }
        });
        reader.start();
        writer.start();
        reader.join();
        writer.join();
        this.assertNotFailed();
    }

    private void snapshotRead(IsolationLevel level) throws SailException {
        this.clear(this.store);
        SailConnection con = this.store.getConnection();
        try {
            con.begin(level);
            int size = 1000;
            for (int i = 0; i < size; ++i) {
                this.insertTestStatement(con, i);
            }
            int counter = 0;
            try (CloseableIteration stmts = con.getStatements(null, null, null, false, new Resource[0]);){
                while (stmts.hasNext()) {
                    Statement st = (Statement)stmts.next();
                    if (++counter >= size) continue;
                    con.removeStatements(st.getSubject(), st.getPredicate(), st.getObject(), new Resource[]{st.getContext()});
                    this.insertTestStatement(con, size + counter);
                    this.insertTestStatement(con, size + size + counter);
                }
            }
            try {
                con.commit();
            }
            catch (SailException e) {
                e.printStackTrace();
                if (con != null) {
                    con.close();
                }
                return;
            }
            Assertions.assertEquals((int)size, (int)counter);
        }
        finally {
            if (con != null) {
                try {
                    con.close();
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    throwable2.addSuppressed(throwable);
                }
            }
        }
    }

    private void snapshot(IsolationLevels level) throws Exception {
        this.clear(this.store);
        CountDownLatch start = new CountDownLatch(2);
        CountDownLatch begin = new CountDownLatch(1);
        CountDownLatch observed = new CountDownLatch(1);
        CountDownLatch changed = new CountDownLatch(1);
        Thread writer = new Thread(() -> {
            try (SailConnection write = this.store.getConnection();){
                start.countDown();
                start.await();
                write.begin((IsolationLevel)level);
                this.insertTestStatement(write, 1);
                write.commit();
                begin.countDown();
                observed.await(1L, TimeUnit.SECONDS);
                write.begin((IsolationLevel)level);
                this.insertTestStatement(write, 2);
                write.commit();
                changed.countDown();
            }
            catch (Throwable e) {
                this.fail("Writer failed", e);
            }
        });
        Thread reader = new Thread(() -> {
            try {
                SailConnection read = this.store.getConnection();
                try {
                    start.countDown();
                    start.await();
                    begin.await();
                    read.begin((IsolationLevel)level);
                    long first = this.count(read, null, null, null, false, new Resource[0]);
                    observed.countDown();
                    changed.await(1L, TimeUnit.SECONDS);
                    long second = this.count(read, null, null, null, false, new Resource[0]);
                    try {
                        read.commit();
                    }
                    catch (SailException e) {
                        read.rollback();
                        if (read != null) {
                            read.close();
                        }
                        return;
                    }
                    Assertions.assertEquals((long)first, (long)second);
                }
                finally {
                    if (read != null) {
                        try {
                            read.close();
                        }
                        catch (Throwable throwable) {
                            Throwable throwable2;
                            throwable2.addSuppressed(throwable);
                        }
                    }
                }
            }
            catch (Throwable e) {
                this.fail("Reader failed", e);
            }
        });
        reader.start();
        writer.start();
        reader.join();
        writer.join();
        this.assertNotFailed();
    }

    private void serializable(IsolationLevels level) throws Exception {
        this.clear(this.store);
        ValueFactory vf = this.store.getValueFactory();
        IRI subj = vf.createIRI("http://test#s");
        IRI pred = vf.createIRI("http://test#p");
        try (SailConnection prep = this.store.getConnection();){
            prep.begin((IsolationLevel)level);
            prep.addStatement((Resource)subj, pred, (Value)vf.createLiteral(1), new Resource[0]);
            prep.commit();
        }
        CountDownLatch start = new CountDownLatch(2);
        CountDownLatch observed = new CountDownLatch(2);
        Thread t1 = this.incrementBy(start, observed, level, vf, subj, pred, 3);
        Thread t2 = this.incrementBy(start, observed, level, vf, subj, pred, 5);
        t2.start();
        t1.start();
        t2.join();
        t1.join();
        this.assertNotFailed();
        try (SailConnection check = this.store.getConnection();){
            check.begin((IsolationLevel)level);
            Literal lit = this.readLiteral(check, subj, pred);
            int val = lit.intValue();
            if (val != 4 && val != 6) {
                Assertions.assertEquals((int)9, (int)val);
            }
            check.commit();
        }
    }

    protected Thread incrementBy(CountDownLatch start, CountDownLatch observed, IsolationLevels level, ValueFactory vf, IRI subj, IRI pred, int by) {
        return new Thread(() -> {
            try (SailConnection con = this.store.getConnection();){
                start.countDown();
                start.await();
                con.begin((IsolationLevel)level);
                Literal o1 = this.readLiteral(con, subj, pred);
                observed.countDown();
                observed.await(1L, TimeUnit.SECONDS);
                con.removeStatements((Resource)subj, pred, (Value)o1, new Resource[0]);
                con.addStatement((Resource)subj, pred, (Value)vf.createLiteral(o1.intValue() + by), new Resource[0]);
                try {
                    con.commit();
                }
                catch (SailException e) {
                    con.rollback();
                }
            }
            catch (Throwable e) {
                this.fail("Increment " + by + " failed", e);
            }
        });
    }

    private void clear(Sail store) throws SailException {
        try (SailConnection con = store.getConnection();){
            con.begin();
            con.clear(new Resource[0]);
            con.commit();
        }
    }

    protected long count(SailConnection con, Resource subj, IRI pred, Value obj, boolean includeInferred, Resource ... contexts) throws SailException {
        try (CloseableIteration stmts = con.getStatements(subj, pred, obj, includeInferred, contexts);){
            long counter = 0L;
            while (stmts.hasNext()) {
                stmts.next();
                ++counter;
            }
            long l = counter;
            return l;
        }
    }

    protected Literal readLiteral(SailConnection con, IRI subj, IRI pred) throws SailException {
        try (CloseableIteration stmts = con.getStatements((Resource)subj, pred, null, false, new Resource[0]);){
            if (!stmts.hasNext()) {
                Literal literal = null;
                return literal;
            }
            Value obj = ((Statement)stmts.next()).getObject();
            if (stmts.hasNext()) {
                Assertions.fail((String)("multiple literals: " + obj + " and " + stmts.next()));
            }
            Literal literal = (Literal)obj;
            return literal;
        }
    }

    protected void insertTestStatement(SailConnection connection, int i) throws SailException {
        Literal lit = this.vf.createLiteral(Integer.toString(i), XSD.INTEGER);
        connection.addStatement((Resource)this.vf.createIRI("http://test#s" + i), this.vf.createIRI("http://test#p"), (Value)lit, new Resource[]{this.vf.createIRI("http://test#context_" + i)});
    }

    protected synchronized void fail(String message, Throwable t) {
        this.failedMessage = message;
        this.failed = t;
    }

    protected synchronized void assertNotFailed() {
        if (this.failed != null) {
            throw (AssertionError)((Object)((Throwable)((Object)new AssertionError((Object)this.failedMessage))).initCause(this.failed));
        }
    }
}

